/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.similarity;

import java.util.Arrays;
import java.util.function.Function;
import org.basex.util.FTToken;
import org.basex.util.Token;

public final class Levenshtein {
    private static final int MAX_LENGTH = 128;
    private final int maxErrors;
    private final byte[][] matrix;

    public Levenshtein() {
        this(0);
    }

    public Levenshtein(int maxErrors) {
        this.maxErrors = maxErrors;
        this.matrix = new byte[130][130];
        int ml = this.matrix.length;
        for (int m = 0; m < ml; ++m) {
            this.matrix[0][m] = (byte)m;
            this.matrix[m][0] = (byte)m;
        }
    }

    public static Object similar(byte[] token, Object[] objects) {
        return Levenshtein.similar(token, objects, Function.identity());
    }

    public static Object similar(byte[] token, Object[] objects, Function<Object, Object> prepare) {
        Object similar = null;
        int err = Integer.MAX_VALUE;
        Levenshtein ls = new Levenshtein();
        for (Object obj : objects) {
            int d;
            byte[] compare = Token.token(prepare.apply(obj));
            if (compare == null || (d = ls.distance(token, compare, 0)) >= err) continue;
            similar = obj;
            err = d;
        }
        return err != Integer.MAX_VALUE ? similar : null;
    }

    public boolean similar(byte[] token, byte[] compare) {
        return this.similar(token, compare, this.maxErrors);
    }

    public boolean similar(byte[] token, byte[] compare, int max) {
        return this.distance(token, compare, max) != Integer.MAX_VALUE;
    }

    private int distance(byte[] token, byte[] compare, int max) {
        int k;
        int[] tkn = Levenshtein.normalize(token);
        int[] cmp = Levenshtein.normalize(compare);
        int tl = tkn.length;
        int cl = cmp.length;
        int dlen = Math.abs(cl - tl);
        if (max == 0 && (tl < 4 || cl < 4) || tl > 128 || cl > 128) {
            return dlen == 0 && Arrays.equals(tkn, cmp) ? 0 : Integer.MAX_VALUE;
        }
        int n = k = max == 0 ? Math.max(1, cl >> 2) : max;
        if (dlen > k) {
            return Integer.MAX_VALUE;
        }
        byte[][] m = this.matrix;
        int f = -1;
        int g = -1;
        for (int t = 0; t < tl; ++t) {
            int tn = tkn[t];
            int d = Integer.MAX_VALUE;
            for (int c = 0; c < cl; ++c) {
                int cn = cmp[c];
                int cost = Levenshtein.min(m[t][c + 1] + 1, m[t + 1][c] + 1, m[t][c] + (tn == cn ? (byte)0 : 1));
                if (tn == g && cn == f) {
                    cost = m[t][c];
                }
                m[t + 1][c + 1] = (byte)cost;
                d = Math.min(d, cost);
                g = cn;
            }
            if (d > k) {
                return Integer.MAX_VALUE;
            }
            f = tn;
        }
        int d = m[tl][cl];
        return d <= k ? d : Integer.MAX_VALUE;
    }

    private static int[] normalize(byte[] token) {
        int[] cps = Token.cps(token);
        int cl = cps.length;
        for (int c = 0; c < cl; ++c) {
            cps[c] = FTToken.noDiacritics(Token.lc(cps[c]));
        }
        return cps;
    }

    public static double distance(int[] token, int[] compare) {
        int tl = token.length;
        int cl = compare.length;
        int max = Math.max(tl, cl);
        if (max == 0) {
            return 1.0;
        }
        if (Math.abs(tl - cl) >= max) {
            return 0.0;
        }
        char[][] m = new char[tl + 1][cl + 1];
        for (int t = 0; t <= tl; ++t) {
            m[t][0] = (char)t;
        }
        for (int c = 0; c <= cl; ++c) {
            m[0][c] = (char)c;
        }
        int f = -1;
        int g = -1;
        for (int t = 0; t < tl; ++t) {
            int tn = token[t];
            for (int c = 0; c < cl; ++c) {
                int cn = compare[c];
                int cost = Levenshtein.min(m[t][c + 1] + '\u0001', m[t + 1][c] + '\u0001', m[t][c] + (tn == cn ? (char)'\u0000' : '\u0001'));
                if (tn == g && cn == f) {
                    cost = m[t][c];
                }
                m[t + 1][c + 1] = (char)cost;
                g = cn;
            }
            f = tn;
        }
        return (double)(max - m[tl][cl]) / (double)max;
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }
}

