/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;

public final class Blake3 {
    private static final int[] PERMUTATION = new int[]{2, 6, 3, 10, 7, 0, 4, 13, 1, 11, 12, 5, 9, 14, 15, 8};
    private static final int[] INITIAL = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int WORDS_SIZE = 16;
    private static final int HASH_SIZE = 32;
    private static final int BLOCK_SIZE = 64;
    private static final int CHUNK_SIZE = 1024;

    public byte[] digest(byte[] input) {
        int il = input.length;
        int[][] stack = new int[54][];
        State state = new State(0L);
        int sp = 0;
        int i = 0;
        while (i < il) {
            if (state.length() == 1024) {
                long chunks = state.counter + 1L;
                int[] value = state.node().value();
                long c = chunks;
                while ((c & 1L) == 0L) {
                    value = Blake3.node(stack[--sp], value).value();
                    c >>= 1;
                }
                stack[sp++] = value;
                state = new State(chunks);
            }
            int i2 = i + Math.min(1024 - state.length(), il - i);
            state.update(Arrays.copyOfRange(input, i, i2));
            i = i2;
        }
        Node node = state.node();
        int s = sp;
        while (--s >= 0) {
            node = Blake3.node(stack[s], node.value());
        }
        return node.finish();
    }

    private static Node node(int[] left, int[] right) {
        int[] words = new int[16];
        int w = 0;
        for (int l : left) {
            words[w++] = l;
        }
        for (int r : right) {
            words[w++] = r;
        }
        return new Node(INITIAL, words, 0L, 64, 4);
    }

    private static int[] compress(int[] value, int[] words, long counter, int length, int flags) {
        int lo = (int)(counter & 0xFFFFFFFFL);
        int hi = (int)(counter >> 32 & 0xFFFFFFFFL);
        int[] state = new int[]{value[0], value[1], value[2], value[3], value[4], value[5], value[6], value[7], INITIAL[0], INITIAL[1], INITIAL[2], INITIAL[3], lo, hi, length, flags};
        int[] wrds = new int[words.length];
        Blake3.round(state, words);
        Blake3.permute(words, wrds);
        Blake3.round(state, wrds);
        Blake3.permute(wrds, words);
        Blake3.round(state, words);
        Blake3.permute(words, wrds);
        Blake3.round(state, wrds);
        Blake3.permute(wrds, words);
        Blake3.round(state, words);
        Blake3.permute(words, wrds);
        Blake3.round(state, wrds);
        Blake3.permute(wrds, words);
        Blake3.round(state, words);
        for (int i = 0; i < 8; ++i) {
            int n = i;
            state[n] = state[n] ^ state[i + 8];
            int n2 = i + 8;
            state[n2] = state[n2] ^ value[i];
        }
        return state;
    }

    private static void round(int[] state, int[] words) {
        Blake3.mix(state, 0, 4, 8, 12, words[0], words[1]);
        Blake3.mix(state, 1, 5, 9, 13, words[2], words[3]);
        Blake3.mix(state, 2, 6, 10, 14, words[4], words[5]);
        Blake3.mix(state, 3, 7, 11, 15, words[6], words[7]);
        Blake3.mix(state, 0, 5, 10, 15, words[8], words[9]);
        Blake3.mix(state, 1, 6, 11, 12, words[10], words[11]);
        Blake3.mix(state, 2, 7, 8, 13, words[12], words[13]);
        Blake3.mix(state, 3, 4, 9, 14, words[14], words[15]);
    }

    private static void mix(int[] state, int a, int b, int c, int d, int mx, int my) {
        state[a] = state[a] + state[b] + mx;
        state[d] = Blake3.rotate(state[d] ^ state[a], 16);
        state[c] = state[c] + state[d];
        state[b] = Blake3.rotate(state[b] ^ state[c], 12);
        state[a] = state[a] + state[b] + my;
        state[d] = Blake3.rotate(state[d] ^ state[a], 8);
        state[c] = state[c] + state[d];
        state[b] = Blake3.rotate(state[b] ^ state[c], 7);
    }

    private static int rotate(int n, int length) {
        return n >>> length | n << 32 - length;
    }

    private static void permute(int[] words, int[] words2) {
        for (int i = 0; i < 16; ++i) {
            words2[i] = words[PERMUTATION[i]];
        }
    }

    private static final class State {
        final long counter;
        byte[] block = new byte[64];
        int[] value = INITIAL;
        byte length;
        byte cmp;

        private State(long counter) {
            this.counter = counter;
        }

        private int length() {
            return 64 * this.cmp + this.length;
        }

        private void update(byte[] input) {
            int add;
            int il = input.length;
            for (int i = 0; i < il; i += add) {
                if (this.length == 64) {
                    this.value = Arrays.copyOfRange(Blake3.compress(this.value, this.words(), this.counter, 64, this.cmp()), 0, 8);
                    this.block = new byte[64];
                    this.length = 0;
                    this.cmp = (byte)(this.cmp + 1);
                }
                add = Math.min(64 - this.length, il - i);
                System.arraycopy(input, i, this.block, this.length, add);
                this.length = (byte)(this.length + add);
            }
        }

        private Node node() {
            return new Node(this.value, this.words(), this.counter, this.length, this.cmp() | 2);
        }

        private int cmp() {
            return this.cmp == 0 ? 1 : 0;
        }

        private int[] words() {
            int tl = this.block.length >>> 2;
            int[] tmp = new int[tl];
            for (int t = 0; t < tl; ++t) {
                int b = t << 2;
                for (int j = 0; j < 4; ++j) {
                    int n = t;
                    tmp[n] = tmp[n] | (this.block[b + j] & 0xFF) << (j << 3);
                }
            }
            return tmp;
        }
    }

    private record Node(int[] value, int[] words, long counter, int length, int flags) {
        private final int[] value;

        public int[] value() {
            return Arrays.copyOfRange(Blake3.compress(this.value, this.words, this.counter, this.length, this.flags), 0, 8);
        }

        private byte[] finish() {
            byte[] hash = new byte[32];
            int o = 0;
            int i = 0;
            while (true) {
                for (int c : Blake3.compress(this.value, this.words, o, this.length, this.flags | 8)) {
                    int j = 0;
                    while (j < 4) {
                        hash[i] = (byte)(c >> (j << 3));
                        ++j;
                        ++i;
                    }
                    if (i != 32) continue;
                    return hash;
                }
                ++o;
            }
        }
    }
}

