/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Objects;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.value.type.SeqType;

public final class RecordField {
    final boolean optional;
    final SeqType seqType;
    private final Expr expr;

    public RecordField(boolean optional, SeqType seqType, Expr expr) {
        this.optional = optional;
        this.seqType = seqType;
        this.expr = expr;
    }

    public RecordField(boolean optional, SeqType seqType) {
        this(optional, seqType, null);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Expr expr() {
        return this.expr;
    }

    public SeqType seqType() {
        return this.seqType == null ? SeqType.ITEM_ZM : this.seqType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RecordField)) return false;
        RecordField rf = (RecordField)obj;
        if (this.optional != rf.optional) return false;
        if (!Objects.equals(this.seqType, rf.seqType)) return false;
        if (!Objects.equals(this.expr, rf.expr)) return false;
        return true;
    }

    public String toString() {
        QueryString qs = new QueryString();
        if (this.optional) {
            qs.token('?');
        }
        qs.token("as").token(this.seqType());
        return qs.toString();
    }
}

