/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class BytSeq
extends NativeSeq {
    private final byte[] values;

    private BytSeq(byte[] values) {
        super(values.length, (Type)AtomType.BYTE);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        byte[] values = new byte[size];
        for (int s = 0; s < size; ++s) {
            values[s] = (byte)in.readNum();
        }
        return BytSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (byte v : this.values) {
            out.writeNum(v);
        }
    }

    @Override
    public Itr itemAt(long index) {
        return new Itr(this.values[(int)index], this.type);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        byte[] tmp = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BytSeq.get(tmp);
    }

    public byte[] toJava() {
        return this.values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof BytSeq) {
            BytSeq seq = (BytSeq)obj;
            if (!Arrays.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public static Value get(byte[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Itr.get(values[0], AtomType.BYTE) : new BytSeq(values));
    }
}

