/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieOrder;

final class TrieUpdate {
    final Item key;
    final Value value;
    private final TrieOrder oldOrder;
    private TrieOrder newOrder;

    TrieUpdate(Item key, Value value, TrieOrder oldOrder) {
        this.key = key;
        this.value = value;
        this.oldOrder = oldOrder;
    }

    void add() {
        if (this.oldOrder != null) {
            this.newOrder = this.oldOrder.add(this.key);
        }
    }

    void remove(Item old) {
        if (this.oldOrder != null) {
            this.newOrder = this.oldOrder.remove(old);
        }
    }

    TrieOrder order() {
        return this.newOrder != null ? this.newOrder : this.oldOrder;
    }

    public String toString() {
        return String.valueOf(this.key) + "/" + String.valueOf(this.value) + ": " + String.valueOf(this.oldOrder) + " -> " + String.valueOf(this.newOrder);
    }
}

