/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.util.ArrayList;
import org.basex.io.IO;
import org.basex.query.util.pkg.PkgComponent;
import org.basex.query.util.pkg.PkgDep;
import org.basex.query.util.pkg.PkgType;

public final class Pkg {
    final ArrayList<PkgDep> dep = new ArrayList();
    final ArrayList<PkgComponent> comps = new ArrayList();
    final String name;
    private String path;
    PkgType type = PkgType.EXPATH;
    String abbrev;
    String spec;
    String version = "";

    public Pkg(String name) {
        this.name = name;
    }

    public Pkg path(String pth) {
        this.path = pth;
        this.type = IO.checkSuffix(this.path, IO.XQSUFFIXES) ? PkgType.XQUERY : (IO.checkSuffix(this.path, ".jar") ? PkgType.JAVA : PkgType.EXPATH);
        return this;
    }

    public String id() {
        return this.type == PkgType.EXPATH ? this.name + "-" + this.version : this.name;
    }

    public String name() {
        return this.name;
    }

    public String abbrev() {
        return this.abbrev;
    }

    public String spec() {
        return this.spec;
    }

    public String path() {
        return this.path;
    }

    public String version() {
        return this.type == PkgType.EXPATH ? this.version : "-";
    }

    public PkgType type() {
        return this.type;
    }

    public Pkg merge(Pkg pkg) {
        if (IO.checkSuffix(pkg.path, IO.XQSUFFIXES) && IO.checkSuffix(this.path, ".jar")) {
            pkg.type = PkgType.COMBINED;
            return pkg;
        }
        if (IO.checkSuffix(this.path, IO.XQSUFFIXES) && IO.checkSuffix(pkg.path, ".jar")) {
            this.type = PkgType.COMBINED;
        }
        return this;
    }

    public static String name(String pkg) {
        int idx = pkg.lastIndexOf(45);
        return idx == -1 ? pkg : pkg.substring(0, idx);
    }

    public static String version(String pkg) {
        return pkg.substring(pkg.lastIndexOf(45) + 1);
    }
}

