/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.parse;

import java.util.ArrayList;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.util.parse.LocalVars;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;

public final class Params {
    private ArrayList<Param> params;
    private SeqType type;

    public int size() {
        return this.params != null ? this.params.size() : 0;
    }

    public Params add(QNm name, SeqType st, Expr expr, InputInfo info) {
        Param param = new Param();
        param.name = name;
        param.type = st;
        param.expr = expr;
        param.info = info;
        if (this.params == null) {
            this.params = new ArrayList(4);
        }
        this.params.add(param);
        return this;
    }

    public Params seqType(SeqType st) {
        this.type = st;
        return this;
    }

    public Params finish(QueryContext qc, LocalVars vars) throws QueryException {
        int size = this.size();
        if (size > 0) {
            if (size > 1) {
                QNmSet names = new QNmSet();
                for (Param param : this.params) {
                    if (names.add(param.name)) continue;
                    throw QueryError.FUNCDUPL_X.get(param.info, param.name);
                }
            }
            for (Param param : this.params) {
                param.var = new Var(param.name, param.type, qc, param.info);
                vars.add(param.var);
            }
        }
        return this;
    }

    public Var[] vars() {
        int ps = this.size();
        Var[] vars = new Var[ps];
        for (int p = 0; p < ps; ++p) {
            vars[p] = this.params.get((int)p).var;
        }
        return vars;
    }

    public Expr[] defaults() {
        int ps = this.size();
        Expr[] defaults = new Expr[ps];
        for (int p = 0; p < ps; ++p) {
            defaults[p] = this.params.get((int)p).expr;
        }
        return defaults;
    }

    public SeqType seqType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('(');
        if (this.size() != 0) {
            for (Param param : this.params) {
                sb.append(sb.length() != 1 ? ", " : "").append(param);
            }
        }
        return sb.append(')').toString();
    }

    private static final class Param {
        private InputInfo info;
        private QNm name;
        private SeqType type;
        private Expr expr;
        private Var var;

        private Param() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append('$').append(this.name);
            if (this.type != null) {
                sb.append(" as ").append(this.type);
            }
            if (this.expr != null) {
                sb.append(" := ").append(this.expr);
            }
            return sb.toString();
        }
    }
}

