/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.node.InsertAfter;
import org.basex.query.up.primitives.node.InsertAttribute;
import org.basex.query.up.primitives.node.InsertBefore;
import org.basex.query.up.primitives.node.InsertInto;
import org.basex.query.up.primitives.node.InsertIntoAsFirst;
import org.basex.query.up.primitives.node.InsertIntoAsLast;
import org.basex.query.up.primitives.node.NodeCopy;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Insert
extends Update {
    private final Mode mode;

    public Insert(InputInfo info, Expr src, Mode mode, Expr trg) {
        super(info, trg, src);
        this.mode = mode;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter iter = this.arg(0).iter(qc);
        boolean sibling = this.mode == Mode.BEFORE || this.mode == Mode.AFTER;
        FBuilder builder = null;
        while ((item = iter.next()) != null) {
            Type type = item.type;
            if (!(type instanceof NodeType)) {
                throw (sibling ? QueryError.UPTRGTYP2_X : QueryError.UPTRGTYP_X).get(this.info, item);
            }
            ANode node = (ANode)item;
            ANode parent = node.parent();
            if (sibling) {
                if (type.oneOf(NodeType.ATTRIBUTE, NodeType.DOCUMENT_NODE)) {
                    throw QueryError.UPTRGTYP2_X.get(this.info, node);
                }
                if (parent == null) {
                    throw QueryError.UPPAREMPTY_X.get(this.info, node);
                }
            } else if (!type.oneOf(NodeType.ELEMENT, NodeType.DOCUMENT_NODE)) {
                throw QueryError.UPTRGTYP_X.get(this.info, node);
            }
            if (builder == null) {
                builder = this.builder(this.arg(1), qc);
            }
            Updates updates = qc.updates();
            ANodeList list = builder.attributes;
            if (list != null) {
                ANode target;
                ANode aNode = target = sibling ? parent : node;
                if (target.type != NodeType.ELEMENT) {
                    throw (sibling ? QueryError.UPATTELM_X : QueryError.UPATTELM2_X).get(this.info, target);
                }
                DBNode dbnode = updates.determineDataRef(target, qc);
                this.checkPerm(qc, Perm.WRITE, dbnode.data().meta.name);
                InsertAttribute up = new InsertAttribute(dbnode.pre(), dbnode.data(), this.info, this.checkNS(list, target));
                updates.add(up, qc);
            }
            if ((list = builder.children) == null) continue;
            DBNode dbnode = updates.determineDataRef(node, qc);
            this.checkPerm(qc, Perm.WRITE, dbnode.data().meta.name);
            NodeCopy up = switch (this.mode) {
                case Mode.BEFORE -> new InsertBefore(dbnode.pre(), dbnode.data(), this.info, list);
                case Mode.AFTER -> new InsertAfter(dbnode.pre(), dbnode.data(), this.info, list);
                case Mode.FIRST -> new InsertIntoAsFirst(dbnode.pre(), dbnode.data(), this.info, list);
                case Mode.LAST -> new InsertIntoAsLast(dbnode.pre(), dbnode.data(), this.info, list);
                default -> new InsertInto(dbnode.pre(), dbnode.data(), this.info, list);
            };
            updates.add(up, qc);
        }
        return Empty.VALUE;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Insert(this.info, this.arg(1).copy(cc, vm), this.mode, this.arg(0).copy(cc, vm)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Insert)) return false;
        Insert ins = (Insert)obj;
        if (this.mode != ins.mode) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("insert").token("nodes").token(this.arg(1)).token("into").token(this.arg(0));
    }

    public static enum Mode {
        INTO,
        FIRST,
        LAST,
        BEFORE,
        AFTER;

    }
}

