/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.FuncItem;
import org.basex.query.var.StaticVar;
import org.basex.util.list.IntList;

final class QueryCompiler {
    private final IdentityHashMap<Scope, Integer> ids = new IdentityHashMap();
    private final ArrayList<int[]> adjacent = new ArrayList();
    private final ArrayList<Scope> scopes = new ArrayList();
    private final IntList stack = new IntList();
    private final IntList list = new IntList();
    private int next;

    QueryCompiler() {
    }

    static void compile(CompileContext cc) throws QueryException {
        for (ArrayList<Scope> scps : new QueryCompiler().scopes(cc.qc.main)) {
            scps.get(0).compile(cc);
        }
    }

    private ArrayList<ArrayList<Scope>> scopes(MainModule main) {
        this.addScope(main);
        ArrayList<ArrayList<Scope>> lists = new ArrayList<ArrayList<Scope>>();
        this.tarjan(0, lists);
        return lists;
    }

    private void tarjan(int id, ArrayList<ArrayList<Scope>> result) {
        int ixv = id << 1;
        int llv = ixv + 1;
        int idx = this.next++;
        this.list.set(ixv, idx);
        this.list.set(llv, idx);
        this.stack.push(id);
        for (int w : this.adjacentTo(id)) {
            int ixw = w << 1;
            int llw = ixw + 1;
            if (this.list.size() <= ixw || this.list.get(ixw) < 0) {
                this.tarjan(w, result);
                this.list.set(llv, Math.min(this.list.get(llv), this.list.get(llw)));
                continue;
            }
            if (!this.stack.contains(w)) continue;
            this.list.set(llv, Math.min(this.list.get(llv), this.list.get(ixw)));
        }
        if (this.list.get(llv) == this.list.get(ixv)) {
            int w;
            ArrayList<Scope> out = new ArrayList<Scope>();
            do {
                w = this.stack.pop();
                out.add(this.scopes.get(w));
            } while (w != id);
            result.add(out);
        }
    }

    private int addScope(Scope scope) {
        int id = this.scopes.size();
        this.scopes.add(scope);
        this.adjacent.add(null);
        this.ids.put(scope, id);
        scope.reset();
        return id;
    }

    private int[] adjacentTo(int node) {
        int[] adj = this.adjacent.get(node);
        if (adj == null) {
            adj = this.neighbors(this.scopes.get(node));
            this.adjacent.set(node, adj);
        }
        return adj;
    }

    private int[] neighbors(final Scope curr) {
        final IntList neighbors = new IntList(0L);
        curr.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                return var != curr && this.add(var);
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                StaticFunc func = call.func();
                return func == null || this.add(func);
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }

            @Override
            public boolean funcItem(FuncItem func) {
                return this.add(func);
            }

            private boolean add(Scope scope) {
                Integer old = QueryCompiler.this.ids.get(scope);
                if (old == null) {
                    neighbors.add(QueryCompiler.this.addScope(scope));
                } else {
                    neighbors.addUnique(old);
                }
                return true;
            }
        });
        return neighbors.finish();
    }
}

