/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.basex.core.Text;
import org.basex.core.cmd.Test;
import org.basex.gui.GUI;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Checks;
import org.basex.util.Util;

interface ProjectCommands {
    public ProjectView view();

    public String search();

    public IOFile selectedFile();

    public List<IOFile> selectedFiles();

    public void refresh();

    default public GUIPopupCmd[] commands(GUIPopupCmd ... edit) {
        ArrayList<GUIPopupCmd> commands = new ArrayList<GUIPopupCmd>();
        commands.add(new GUIPopupCmd(Text.OPEN, new BaseXKeys[]{BaseXKeys.ENTER}){

            @Override
            public void execute() {
                for (IOFile file : ProjectCommands.this.selectedFiles()) {
                    ProjectCommands.this.view().open(file, ProjectCommands.this.search());
                }
            }

            @Override
            public boolean enabled(GUI main) {
                return ((Checks<IOFile>)file -> !file.isDir()).all(ProjectCommands.this.selectedFiles());
            }
        });
        commands.add(new GUIPopupCmd(Text.OPEN_EXTERNALLY, new BaseXKeys[]{BaseXKeys.SHIFT_ENTER}){

            @Override
            public void execute() {
                for (IOFile file : ProjectCommands.this.selectedFiles()) {
                    try {
                        file.open();
                    }
                    catch (IOException ex) {
                        Util.debug(ex);
                        BaseXDialog.error(ProjectCommands.this.view().gui, Util.info(Text.FILE_NOT_OPENED_X, file));
                    }
                }
            }

            @Override
            public boolean enabled(GUI main) {
                return ProjectCommands.this.selectedFile() != null;
            }
        });
        commands.add(new GUIPopupCmd(Text.RUN_TESTS, new BaseXKeys[]{BaseXKeys.TESTS}){

            @Override
            public void execute() {
                ProjectCommands.this.view().gui.execute(new Test(ProjectCommands.this.selectedFile().path()));
            }

            @Override
            public boolean enabled(GUI main) {
                IOFile file = ProjectCommands.this.selectedFile();
                return file != null && (file.isDir() || file.hasSuffix(IO.XQSUFFIXES));
            }
        });
        commands.add(new GUIPopupCmd(Text.SET_CONTEXT, new BaseXKeys[0]){

            @Override
            public void execute() {
                ProjectCommands.this.view().gui.editor.setContext(ProjectCommands.this.selectedFile());
            }

            @Override
            public boolean enabled(GUI main) {
                IOFile file = ProjectCommands.this.selectedFile();
                return file != null && !file.isDir() && file.hasSuffix(ProjectCommands.this.view().gui.gopts.xmlSuffixes());
            }
        });
        commands.add(null);
        commands.addAll(Arrays.asList(edit));
        commands.add(new GUIPopupCmd(Text.REFRESH, new BaseXKeys[]{BaseXKeys.REFRESH}){

            @Override
            public void execute() {
                ProjectCommands.this.refresh();
            }

            @Override
            public boolean enabled(GUI main) {
                return ProjectCommands.this.selectedFile() != null;
            }
        });
        commands.add(null);
        commands.add(new GUIPopupCmd(Text.COPY_PATH, new BaseXKeys[]{BaseXKeys.COPYPATH}){

            @Override
            public void execute() {
                BaseXLayout.copyPath(ProjectCommands.this.selectedFile().path());
            }

            @Override
            public boolean enabled(GUI main) {
                return ProjectCommands.this.selectedFile() != null;
            }
        });
        return (GUIPopupCmd[])commands.toArray(GUIPopupCmd[]::new);
    }
}

