/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqsequence;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.ObjectToXQItemConverter;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemBaseIterator;
import net.xqj.core.xqsequence.XQSequenceBase;

public final class ScrollableXQSequence
extends XQSequenceBase {
    private List<XQItemBase> list;
    private int position;

    private ScrollableXQSequence(XQItemBaseIterator iterator) throws XQException {
        XQItemBase base;
        this.list = new ArrayList<XQItemBase>();
        while ((base = iterator.next()) != null) {
            this.list.add((XQItemBase)base.clone());
        }
    }

    private ScrollableXQSequence() {
        this(new ArrayList<XQItemBase>());
    }

    private ScrollableXQSequence(List<XQItemBase> list) {
        this.list = list;
    }

    private ScrollableXQSequence(XQSequence sequence) throws XQException {
        this.list = new ArrayList<XQItemBase>();
        if (!sequence.isOnItem() && !sequence.next()) {
            return;
        }
        do {
            XQItem vItem = sequence.getItem();
            XQItemBase itemBase = ObjectToXQItemConverter.createXQItem(vItem, null);
            this.list.add(itemBase);
        } while (sequence.next());
    }

    static ScrollableXQSequence newInstance() throws XQException {
        return new ScrollableXQSequence();
    }

    static ScrollableXQSequence newInstance(XQItemBaseIterator iterator) throws XQException {
        return new ScrollableXQSequence(iterator);
    }

    static ScrollableXQSequence newInstance(List<XQItemBase> list) {
        return new ScrollableXQSequence(list);
    }

    static ScrollableXQSequence newInstance(XQSequence sequence) throws XQException {
        return new ScrollableXQSequence(sequence);
    }

    @Override
    public boolean absolute(int newPosition) throws XQException {
        if (this.list.isEmpty()) {
            return false;
        }
        this.position = newPosition > this.list.size() ? this.list.size() + 1 : (newPosition < -this.list.size() ? -this.list.size() - 1 : newPosition);
        return this.isOnItem();
    }

    @Override
    public void afterLast() throws XQException {
        this.position = this.list.size() + 1;
    }

    @Override
    public void beforeFirst() throws XQException {
        this.position = 0;
    }

    @Override
    public void close() throws XQException {
        this.list.clear();
    }

    @Override
    public int count() throws XQException {
        return this.list.size();
    }

    @Override
    public int getPosition() throws XQException {
        return this.position;
    }

    @Override
    public boolean isOnItem() throws XQException {
        return this.position != 0 && this.position <= this.list.size() && this.position >= -this.list.size() && !this.list.isEmpty();
    }

    @Override
    public boolean isScrollable() throws XQException {
        return true;
    }

    @Override
    public boolean first() throws XQException {
        if (!this.list.isEmpty()) {
            this.position = 1;
            return true;
        }
        return false;
    }

    @Override
    public XQItem getItem() throws XQException {
        try {
            return this.list.get(this.position < 0 ? this.list.size() + this.position : this.position - 1);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.list.isEmpty()) {
                throw new XQExceptionImpl("Scrollable XQSequence is empty.", "XQJSCS001");
            }
            if (this.position > this.list.size()) {
                throw new XQExceptionImpl("Scrollable XQSequence position (" + this.position + ") is after the last sequence item (" + this.list.size() + ").", "XQJSCS002");
            }
            if (this.position == 0) {
                throw new XQExceptionImpl("Scrollable XQSequence position is before the first sequence item.", "XQJSCS003");
            }
            throw new XQExceptionImpl("IndexOutOfBoundsException occurred within Scrollable XQSequence.\n" + e.getMessage(), "XQJSCS004", e);
        }
    }

    @Override
    public XQItemBase getItemIdentity() throws XQException {
        return (XQItemBase)this.getItem();
    }

    @Override
    public boolean isAfterLast() throws XQException {
        return this.position > this.list.size() && !this.list.isEmpty();
    }

    @Override
    public boolean isBeforeFirst() throws XQException {
        return (this.position == 0 || this.position < -this.list.size()) && !this.list.isEmpty();
    }

    @Override
    public boolean isFirst() throws XQException {
        return (this.position == 1 || this.position == -this.list.size()) && !this.list.isEmpty();
    }

    @Override
    public boolean isLast() throws XQException {
        return this.position != 0 && (this.position == this.list.size() || this.position == -1);
    }

    @Override
    public boolean last() throws XQException {
        this.position = this.list.size();
        return this.position > 0;
    }

    @Override
    public boolean next() throws XQException {
        return ++this.position != 0 && this.position <= this.list.size() && this.position >= -this.list.size();
    }

    @Override
    public boolean previous() throws XQException {
        return --this.position != 0 && this.position <= this.list.size() && this.position >= -this.list.size();
    }

    @Override
    public boolean relative(int itempos) throws XQException {
        int sum = this.position + itempos;
        this.position = sum < 0 ? 0 : (sum > this.list.size() ? this.list.size() + 1 : sum);
        return this.isOnItem();
    }

    @Override
    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getItem().instanceOf(type);
    }

    public final boolean hasNext() {
        return this.position != -1 && this.position < this.list.size() && this.position >= -this.list.size() && !this.list.isEmpty();
    }

    public String toString() {
        return "ScrollableXQSequence-" + this.instanceId;
    }

    @Override
    public void reset(XQItemBaseIterator iterator) throws XQException {
        XQItemBase base;
        this.list.clear();
        this.position = 0;
        while ((base = iterator.next()) != null) {
            this.list.add((XQItemBase)base.clone());
        }
    }
}

