/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.basex;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import net.xqj.basex.BaseXXQConnection;
import net.xqj.basex.BasicConnectionImpl;
import net.xqj.basic.BasicConnection;
import net.xqj.core.GenericXQDataSource;
import net.xqj.core.Version;
import net.xqj.core.exception.XQExceptionImpl;

public class BaseXXQDataSource
extends GenericXQDataSource
implements XQDataSource {
    private Properties properties = new Properties();
    private static final String SERVER_NAME = "serverName";
    private static final String DATABASE_NAME = "databaseName";
    private static final String PORT = "port";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String DESCRIPTION = "description";

    public BaseXXQDataSource() {
        this.properties.setProperty(SERVER_NAME, "localhost");
        this.properties.setProperty(PORT, "1984");
        this.properties.setProperty(DESCRIPTION, Version.getProductName() + " (Client/Server) " + Version.getProductVersion());
    }

    @Override
    public XQConnection getConnection() throws XQException {
        BasicConnection conn = this.createBasicConnectionInstance();
        return new BaseXXQConnection(conn, this);
    }

    @Override
    public XQConnection getConnection(String username, String passwd) throws XQException {
        BasicConnection conn = this.createBasicConnectionInstance();
        conn.hint(USER, username);
        conn.hint(PASSWORD, passwd);
        return new BaseXXQConnection(conn, this);
    }

    private BasicConnection createBasicConnectionInstance() throws XQException {
        BasicConnectionImpl conn = new BasicConnectionImpl();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = this.properties.getProperty(propertyName);
            conn.hint(propertyName, propertyValue);
        }
        return conn;
    }

    public void setServerName(String serverName) throws XQException {
        this.properties.setProperty(SERVER_NAME, serverName);
    }

    public String getServerName() throws XQException {
        return this.properties.getProperty(SERVER_NAME);
    }

    public void setDatabaseName(String databaseName) throws XQException {
        this.properties.setProperty(DATABASE_NAME, databaseName);
    }

    public String getDatabaseName() throws XQException {
        return this.properties.getProperty(DATABASE_NAME);
    }

    public void setUser(String user) throws XQException {
        this.properties.setProperty(USER, user);
    }

    public String getUser() throws XQException {
        return this.properties.getProperty(USER);
    }

    public void setPassword(String password) throws XQException {
        this.properties.setProperty(PASSWORD, password);
    }

    public String getPassword() throws XQException {
        return this.properties.getProperty(PASSWORD);
    }

    public void setPort(int port) throws XQException {
        this.properties.setProperty(PORT, String.valueOf(port));
    }

    public void setPort(String port) throws XQException {
        try {
            this.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            throw new XQException(e.getMessage());
        }
    }

    public int getPort() throws XQException {
        return Integer.parseInt(this.properties.getProperty(PORT));
    }

    @Override
    public String[] getSupportedPropertyNames() {
        String[] generic = super.getSupportedPropertyNames();
        String[] specific = new String[]{SERVER_NAME, DATABASE_NAME, PORT, USER, PASSWORD};
        String[] complete = new String[generic.length + specific.length];
        System.arraycopy(generic, 0, complete, 0, generic.length);
        System.arraycopy(specific, 0, complete, generic.length, specific.length);
        return complete;
    }

    @Override
    public void setReadOnly(String readOnly) throws XQException {
        super.setReadOnly(readOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws XQException {
        super.setReadOnly(readOnly);
    }

    @Override
    public boolean getReadOnly() throws XQException {
        return super.getReadOnly();
    }

    @Override
    public void setProperty(String name, String value) throws XQException {
        if (SERVER_NAME.equals(name)) {
            this.setServerName(value);
        } else if (DATABASE_NAME.equals(name)) {
            this.setDatabaseName(value);
        } else if (PORT.equals(name)) {
            this.setPort(value);
        } else if (USER.equals(name)) {
            this.setUser(value);
        } else if (PASSWORD.equals(name)) {
            this.setPassword(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public String getProperty(String name) throws XQException {
        if (SERVER_NAME.equals(name) || DATABASE_NAME.equals(name) || PORT.equals(name) || USER.equals(name) || PASSWORD.equals(name)) {
            return this.properties.getProperty(name);
        }
        return super.getProperty(name);
    }

    @Override
    public XQConnection getConnection(Connection con) throws XQException {
        throw new XQExceptionImpl(this.getClass().getName() + ".getConnection(java.sql.Connection c) is unsupported.", "XQJBS001");
    }
}

