//  Copyright (c) 2007-2020 Hartmut Kaiser
//  Copyright (c) 2014 Grant Mercer
//  Copyright (c) 2017 Taeguk Kwon
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#pragma once

#include <hpx/config.hpp>

/// See N4310: 1.3/3
#include <algorithm>

// Parallelism TS V1
#include <hpx/parallel/algorithms/adjacent_find.hpp>
#include <hpx/parallel/algorithms/all_any_none.hpp>
#include <hpx/parallel/algorithms/copy.hpp>
#include <hpx/parallel/algorithms/count.hpp>
#include <hpx/parallel/algorithms/equal.hpp>
#include <hpx/parallel/algorithms/fill.hpp>
#include <hpx/parallel/algorithms/find.hpp>
#include <hpx/parallel/algorithms/for_each.hpp>
#include <hpx/parallel/algorithms/generate.hpp>
#include <hpx/parallel/algorithms/includes.hpp>
#include <hpx/parallel/algorithms/is_heap.hpp>
#include <hpx/parallel/algorithms/is_partitioned.hpp>
#include <hpx/parallel/algorithms/is_sorted.hpp>
#include <hpx/parallel/algorithms/lexicographical_compare.hpp>
#include <hpx/parallel/algorithms/make_heap.hpp>
#include <hpx/parallel/algorithms/merge.hpp>
#include <hpx/parallel/algorithms/minmax.hpp>
#include <hpx/parallel/algorithms/mismatch.hpp>
#include <hpx/parallel/algorithms/move.hpp>
#include <hpx/parallel/algorithms/nth_element.hpp>
#include <hpx/parallel/algorithms/partial_sort.hpp>
#include <hpx/parallel/algorithms/partial_sort_copy.hpp>
#include <hpx/parallel/algorithms/partition.hpp>
#include <hpx/parallel/algorithms/remove.hpp>
#include <hpx/parallel/algorithms/remove_copy.hpp>
#include <hpx/parallel/algorithms/replace.hpp>
#include <hpx/parallel/algorithms/reverse.hpp>
#include <hpx/parallel/algorithms/rotate.hpp>
#include <hpx/parallel/algorithms/search.hpp>
#include <hpx/parallel/algorithms/set_difference.hpp>
#include <hpx/parallel/algorithms/set_intersection.hpp>
#include <hpx/parallel/algorithms/set_symmetric_difference.hpp>
#include <hpx/parallel/algorithms/set_union.hpp>
#include <hpx/parallel/algorithms/sort.hpp>
#include <hpx/parallel/algorithms/stable_sort.hpp>
#include <hpx/parallel/algorithms/swap_ranges.hpp>
#include <hpx/parallel/algorithms/transform.hpp>
#include <hpx/parallel/algorithms/unique.hpp>

// Parallelism TS V2
#include <hpx/parallel/algorithms/ends_with.hpp>
#include <hpx/parallel/algorithms/for_loop.hpp>
#include <hpx/parallel/algorithms/shift_left.hpp>
#include <hpx/parallel/algorithms/shift_right.hpp>
#include <hpx/parallel/algorithms/starts_with.hpp>
