/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;

public class SuperfluousRemover {
    private final Set<File> myParentPaths;
    private final boolean myCheckBefore;

    SuperfluousRemover(boolean checkBefore) {
        this.myCheckBefore = checkBefore;
        this.myParentPaths = new HashSet<File>();
    }

    protected boolean accept(@NotNull Change change) {
        ContentRevision otherRevision;
        if (change == null) {
            SuperfluousRemover.$$$reportNull$$$0(0);
        }
        ContentRevision mainRevision = this.myCheckBefore ? change.getBeforeRevision() : change.getAfterRevision();
        ContentRevision contentRevision = otherRevision = !this.myCheckBefore ? change.getBeforeRevision() : change.getAfterRevision();
        if (mainRevision == null || SvnRollbackEnvironment.isMoveRenameReplace(change)) {
            this.check(otherRevision.getFile().getIOFile());
            return true;
        }
        return false;
    }

    public void check(@NotNull File file) {
        boolean parentAlreadyRegistered;
        if (file == null) {
            SuperfluousRemover.$$$reportNull$$$0(1);
        }
        if (!(parentAlreadyRegistered = ContainerUtil.or(this.myParentPaths, parentCandidate -> VfsUtilCore.isAncestor((File)parentCandidate, (File)file, (boolean)true)))) {
            ContainerUtil.retainAll(this.myParentPaths, childCandidate -> !VfsUtilCore.isAncestor((File)file, (File)childCandidate, (boolean)true));
            this.myParentPaths.add(file);
        }
    }

    public Set<File> getParentPaths() {
        return this.myParentPaths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/rollback/SuperfluousRemover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

