/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.file.AFile;
import net.sourceforge.plantuml.file.AFileRegular;
import net.sourceforge.plantuml.file.AFileZipEntry;
import net.sourceforge.plantuml.file.AParentFolder;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.utils.Log;

public class ImportedFiles {
    private final List<SFile> imported;
    private final AParentFolder currentDir;

    private ImportedFiles(List<SFile> imported, AParentFolder currentDir) {
        this.imported = imported;
        this.currentDir = currentDir;
    }

    public ImportedFiles withCurrentDir(AParentFolder newCurrentDir) {
        if (newCurrentDir == null) {
            return this;
        }
        return new ImportedFiles(this.imported, newCurrentDir);
    }

    public static ImportedFiles createImportedFiles(AParentFolder newCurrentDir) {
        return new ImportedFiles(new ArrayList<SFile>(), newCurrentDir);
    }

    public String toString() {
        return "ImportedFiles=" + this.imported + " currentDir=" + this.currentDir;
    }

    public AFile getAFile(String nameOrPath) throws IOException {
        AParentFolder dir = this.currentDir;
        if (dir == null || this.isAbsolute(nameOrPath)) {
            return new AFileRegular(new SFile(nameOrPath).getCanonicalFile());
        }
        AFile filecurrent = dir.getAFile(nameOrPath);
        Log.info("ImportedFiles::getAFile filecurrent = " + filecurrent);
        if (filecurrent != null && filecurrent.isOk()) {
            return filecurrent;
        }
        for (SFile d : this.getPath()) {
            AFileZipEntry zipEntry;
            if (d.isDirectory()) {
                SFile file = d.file(nameOrPath);
                if (!file.exists()) continue;
                return new AFileRegular(file.getCanonicalFile());
            }
            if (!d.isFile() || !(zipEntry = new AFileZipEntry(d, nameOrPath)).isOk()) continue;
            return zipEntry;
        }
        return filecurrent;
    }

    public List<SFile> getPath() {
        ArrayList<SFile> result = new ArrayList<SFile>(this.imported);
        result.addAll(this.includePath());
        result.addAll(SecurityUtils.getPath("java.class.path"));
        return result;
    }

    private List<SFile> includePath() {
        return SecurityUtils.getPath("plantuml.include.path");
    }

    private boolean isAbsolute(String nameOrPath) {
        SFile f = new SFile(nameOrPath);
        return f.isAbsolute();
    }

    public void add(SFile file) {
        this.imported.add(file);
    }

    public AParentFolder getCurrentDir() {
        return this.currentDir;
    }

    public FileWithSuffix getFile(String filename, String suffix) throws IOException {
        String entry;
        AFile file;
        int idx = filename.indexOf(126);
        if (idx == -1) {
            file = this.getAFile(filename);
            entry = null;
        } else {
            file = this.getAFile(filename.substring(0, idx));
            entry = filename.substring(idx + 1);
        }
        if (file == null || !file.getUnderlyingFile().isFileOk()) {
            return FileWithSuffix.none();
        }
        return new FileWithSuffix(filename, suffix, file, entry);
    }
}

