/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.CodeInsightUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFragment;
import org.jetbrains.kotlin.com.intellij.psi.PsiTemplate;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiLiteralUtil;

public final class PsiFragmentImpl
extends LeafPsiElement
implements PsiFragment {
    public static final Key<Integer> FRAGMENT_INDENT_KEY = Key.create("FRAGMENT_INDENT_KEY");

    public PsiFragmentImpl(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == null) {
            PsiFragmentImpl.$$$reportNull$$$0(0);
        }
        if (text == null) {
            PsiFragmentImpl.$$$reportNull$$$0(1);
        }
        super(type2, text);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiFragmentImpl.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitFragment(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @Nullable
    public String getValue() {
        String content = PsiFragmentImpl.getFragmentContent(this);
        if (content == null) {
            return null;
        }
        CharSequence sequence2 = CodeInsightUtilCore.parseStringCharacters(content, null);
        if (sequence2 == null) {
            return null;
        }
        return sequence2.toString();
    }

    private static String getFragmentContent(PsiFragment fragment) {
        IElementType tokenType = fragment.getTokenType();
        if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
            String text = fragment.getText();
            return text.substring(1, text.length() - 2);
        }
        if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
            String text = fragment.getText();
            if (!text.endsWith("\"")) {
                return null;
            }
            return text.substring(1, text.length() - 1);
        }
        return PsiFragmentImpl.getTextBlockFragmentContent(fragment);
    }

    @Nullable
    private static String getTextBlockFragmentContent(PsiFragment fragment) {
        String content;
        IElementType tokenType = fragment.getTokenType();
        String text = fragment.getText();
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            char c;
            if (!text.startsWith("\"\"\"")) {
                return null;
            }
            int start = 3;
            while ((c = text.charAt(start++)) != '\n') {
                if (PsiLiteralUtil.isTextBlockWhiteSpace(c) && start != text.length()) continue;
                return null;
            }
            content = text.substring(start, text.length() - 2);
        } else if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
            content = text.substring(1, text.length() - 2);
        } else if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
            if (!text.endsWith("\"\"\"")) {
                return null;
            }
            content = text.substring(1, text.length() - 3);
        } else {
            return null;
        }
        int indent = PsiFragmentImpl.getTextBlockFragmentIndent(fragment);
        return indent < 0 ? null : PsiFragmentImpl.stripTextBlockIndent(tokenType, content, indent);
    }

    @NotNull
    private static String stripTextBlockIndent(IElementType tokenType, String content, int indent) {
        StringBuilder result2 = new StringBuilder();
        int strip = tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN ? 0 : -1;
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            int end;
            char c = content.charAt(i);
            if (strip >= 0) {
                if (c == '\n') {
                    strip = -1;
                } else if (strip <= indent) {
                    ++strip;
                }
            }
            if (c == '\n') {
                char d;
                while (result2.length() > 0 && (d = result2.charAt(end = result2.length() - 1)) != '\n' && Character.isWhitespace(d)) {
                    result2.deleteCharAt(end);
                }
                strip = 0;
            } else if (strip > indent && indent > 0) {
                end = result2.length();
                result2.delete(end - indent, end);
                strip = -1;
            }
            result2.append(c);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            PsiFragmentImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public static int getTextBlockFragmentIndent(PsiFragment fragment) {
        PsiElement parent2 = fragment.getParent();
        if (!(parent2 instanceof PsiTemplate)) {
            return -1;
        }
        PsiTemplate template = (PsiTemplate)parent2;
        Integer cache2 = template.getUserData(FRAGMENT_INDENT_KEY);
        if (cache2 != null) {
            return cache2;
        }
        StringBuilder sb = new StringBuilder();
        for (PsiFragment templateFragment : template.getFragments()) {
            sb.append(templateFragment.getText());
        }
        String[] lines = PsiLiteralUtil.getTextBlockLines(sb.toString());
        if (lines == null) {
            return -1;
        }
        int indent = PsiLiteralUtil.getTextBlockIndent(lines);
        fragment.putUserData(FRAGMENT_INDENT_KEY, indent);
        return indent;
    }

    @Override
    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    public boolean isTextBlock() {
        IElementType token = this.getElementType();
        return token == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN || token == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID || token == JavaTokenType.TEXT_BLOCK_TEMPLATE_END;
    }

    @Override
    public String toString() {
        return "PsiFragment:" + this.getElementType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiFragmentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiFragmentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTextBlockIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

