/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList;

final class MarkerPool
extends ObjectArrayList<PsiBuilderImpl.ProductionMarker> {
    private final PsiBuilderImpl myBuilder;
    private final IntArrayList myFreeStartMarkers = new IntArrayList();
    private final IntArrayList myFreeErrorItems = new IntArrayList();

    MarkerPool(PsiBuilderImpl builder) {
        this.myBuilder = builder;
        this.add(null);
    }

    PsiBuilderImpl.StartMarker allocateStartMarker() {
        if (this.myFreeStartMarkers.size() > 0) {
            return (PsiBuilderImpl.StartMarker)this.get(this.myFreeStartMarkers.popInt());
        }
        PsiBuilderImpl.StartMarker marker = new PsiBuilderImpl.StartMarker(this.size(), this.myBuilder);
        this.add(marker);
        return marker;
    }

    PsiBuilderImpl.ErrorItem allocateErrorItem() {
        if (this.myFreeErrorItems.size() > 0) {
            return (PsiBuilderImpl.ErrorItem)this.get(this.myFreeErrorItems.popInt());
        }
        PsiBuilderImpl.ErrorItem item = new PsiBuilderImpl.ErrorItem(this.size(), this.myBuilder);
        this.add(item);
        return item;
    }

    void freeMarker(PsiBuilderImpl.ProductionMarker marker) {
        marker.clean();
        (marker instanceof PsiBuilderImpl.StartMarker ? this.myFreeStartMarkers : this.myFreeErrorItems).push(marker.markerId);
    }
}

