RabbitMQ `3.9.23` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 24.2, and supports Erlang 25. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

Starting with this release, RabbitMQ requires Erlang 24.2 or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.

### Open File Handle Limit is Capped by Default on Linux, *BSD, macOS

Nodes now default to 65536 concurrent client connections instead of using the effective kernel open file handle limit.
Users who want to override this default, that is, have nodes that should support more concurrent connections and open files,
now have to perform an additional configuration step:

 * Pick a new limit value they would like to use, for instance, 100K
 * Set the maximum open file handle limit (for example, via `systemd` or similar tooling) for the OS user used by RabbitMQ to 100K
 * Set the [`ERL_MAX_PORTS` environment variable](https://www.rabbitmq.com/configure.html#customise-environment) to 100K

This change was introduced because of a change in several Linux distributions: they now use a default open file handle limit so high,
they cause a significant (say, 1.5 GiB) memory preallocated the Erlang runtime.

For example, [RHEL 9 and CentOS Stream 9](https://access.redhat.com/solutions/1479623) are examples of such distributions.
The new default [comes from modern systemd](https://github.com/systemd/systemd/commit/a8b627aaed409a15260c25988970c795bf963812).

See [rabbitmq/rabbitmq-server#5684](https://github.com/rabbitmq/rabbitmq-server/pull/5684) and [docker-library/rabbitmq#545](https://github.com/docker-library/rabbitmq/issues/545#issuecomment-1224977154)
for details.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).


### Core Server

#### Enhancements

 * Force GC after definition import to reduce peak memory load by mostly idle
   nodes that import a lot of definitions.

   GitHub issue: [#5550](https://github.com/rabbitmq/rabbitmq-server/pull/5550)

#### Bug Fixes

 * Reduced log noise from exceptions connections could run into when a client
   was closings it connection end concurrently with other activity.

   GitHub issue: [#5539](https://github.com/rabbitmq/rabbitmq-server/pull/5539)

 * `rabbitmq-env-conf.bat§ on Windows could fail to load when its path contained spaces.

   GitHub issue: [#5542](https://github.com/rabbitmq/rabbitmq-server/pull/5542)


### Stream Plugin

#### Bug Fixes

  * Stream declaration could run into an exception when stream parameters failed validation.

    GitHub issue: [#5487](https://github.com/rabbitmq/rabbitmq-server/pull/5487)


### Grafana Dashboards

#### Bug Fixes

 * Some counters on the Overview page have been moved to global counters introduced in RabbitMQ 3.9.

   GitHub issue: [#5463](https://github.com/rabbitmq/rabbitmq-server/pull/5463)


### MQTT Plugin

#### Enhancements

 * A way to configure an authentication timeout, much like in some other protocols RabbitMQ supports.

   Contributed by @gomoripeti.

   GitHub issue: [#5755](https://github.com/rabbitmq/rabbitmq-server/pull/5755)

#### Bug Fixes

  * Avoid an exception when MQTT client closes TCP connection before server could fully
    process a `CONNECT` frame sent earlier by the same client.

    GitHub issue: [#5658](https://github.com/rabbitmq/rabbitmq-server/pull/5658)


### STOMP Plugin

#### Enhancements

 * A way to configure an authentication timeout, much like in some other protocols RabbitMQ supports.

   Contributed by @gomoripeti.

   GitHub issue: [#5755](https://github.com/rabbitmq/rabbitmq-server/pull/5755)

### Windows installer

#### Enhancements

 * Service startup is now optional. More environment variables are respected by the installer.

   Contributed by @inikulshin.

   GitHub issues: [rabbitmq/rabbitmq-packaging#15](https://github.com/rabbitmq/rabbitmq-packaging/issues/15)


## Dependency Upgrades

 * `prometheus` upgraded to [`4.9.1`](https://github.com/deadtrickster/prometheus.erl/tags)
 * `eetcd` upgraded to [`0.3.6`](https://github.com/zhongwencool/eetcd/releases/)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.23.tar.xz`
instead of the source tarball produced by GitHub.
