/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;

public class CubridView
extends GenericView {
    private CubridUser owner;

    public CubridView(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName != null ? tableName.toLowerCase() : null, tableType, dbResult);
        String type;
        if (dbResult != null && (type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_system_class")) != null) {
            this.setSystem(type.equals("YES"));
        }
        this.owner = (CubridUser)container;
    }

    public void setName(String name) {
        super.setName(name != null ? name.toLowerCase() : null);
    }

    public void setSchema(@NotNull CubridUser owner) {
        this.owner = owner;
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return (CubridDataSource)super.getDataSource();
    }

    @NotNull
    public String getUniqueName() {
        if (this.getDataSource().getSupportMultiSchema()) {
            return String.valueOf(this.getContainer()) + "." + this.getName();
        }
        return this.getName();
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=OwnerListProvider.class, labelProvider=GenericSchema.SchemaNameTermProvider.class, order=2)
    @NotNull
    public GenericSchema getSchema() {
        return this.owner;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        if (this.isSystem()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    public static class OwnerListProvider
    implements IPropertyValueListProvider<CubridView> {
        @NotNull
        public boolean allowCustomValue() {
            return false;
        }

        @NotNull
        public Object[] getPossibleValues(@NotNull CubridView object) {
            return object.getDataSource().getSchemas().toArray();
        }
    }
}

