/* automatically generated by rust-bindgen 0.69.4 */

pub type std_string = [u32; 3usize];
pub const oboe_StreamState_Uninitialized: oboe_StreamState = 0;
pub const oboe_StreamState_Unknown: oboe_StreamState = 1;
pub const oboe_StreamState_Open: oboe_StreamState = 2;
pub const oboe_StreamState_Starting: oboe_StreamState = 3;
pub const oboe_StreamState_Started: oboe_StreamState = 4;
pub const oboe_StreamState_Pausing: oboe_StreamState = 5;
pub const oboe_StreamState_Paused: oboe_StreamState = 6;
pub const oboe_StreamState_Flushing: oboe_StreamState = 7;
pub const oboe_StreamState_Flushed: oboe_StreamState = 8;
pub const oboe_StreamState_Stopping: oboe_StreamState = 9;
pub const oboe_StreamState_Stopped: oboe_StreamState = 10;
pub const oboe_StreamState_Closing: oboe_StreamState = 11;
pub const oboe_StreamState_Closed: oboe_StreamState = 12;
pub const oboe_StreamState_Disconnected: oboe_StreamState = 13;
#[doc = " The state of the audio stream."]
pub type oboe_StreamState = i32;
#[doc = " Used for playback."]
pub const oboe_Direction_Output: oboe_Direction = 0;
#[doc = " Used for recording."]
pub const oboe_Direction_Input: oboe_Direction = 1;
#[doc = " The direction of the stream."]
pub type oboe_Direction = i32;
#[doc = " Invalid format."]
pub const oboe_AudioFormat_Invalid: oboe_AudioFormat = -1;
#[doc = " Unspecified format. Format will be decided by Oboe.\n When calling getHardwareFormat(), this will be returned if\n the API is not supported."]
pub const oboe_AudioFormat_Unspecified: oboe_AudioFormat = 0;
#[doc = " Signed 16-bit integers."]
pub const oboe_AudioFormat_I16: oboe_AudioFormat = 1;
#[doc = " Single precision floating point.\n\n This is the recommended format for most applications.\n But note that the use of Float may prevent the opening of\n a low-latency input path on OpenSL ES or Legacy AAudio streams."]
pub const oboe_AudioFormat_Float: oboe_AudioFormat = 2;
#[doc = " Signed 24-bit integers, packed into 3 bytes.\n\n Note that the use of this format does not guarantee that\n the full precision will be provided.  The underlying device may\n be using I16 format.\n\n Added in API 31 (S)."]
pub const oboe_AudioFormat_I24: oboe_AudioFormat = 3;
#[doc = " Signed 32-bit integers.\n\n Note that the use of this format does not guarantee that\n the full precision will be provided.  The underlying device may\n be using I16 format.\n\n Added in API 31 (S)."]
pub const oboe_AudioFormat_I32: oboe_AudioFormat = 4;
#[doc = " This format is used for compressed audio wrapped in IEC61937 for HDMI\n or S/PDIF passthrough.\n\n Unlike PCM playback, the Android framework is not able to do format\n conversion for IEC61937. In that case, when IEC61937 is requested, sampling\n rate and channel count or channel mask must be specified. Otherwise, it may\n fail when opening the stream. Apps are able to get the correct configuration\n for the playback by calling AudioManager#getDevices(int).\n\n Available since API 34 (U)."]
pub const oboe_AudioFormat_IEC61937: oboe_AudioFormat = 5;
#[doc = " The format of audio samples."]
pub type oboe_AudioFormat = i32;
pub const oboe_DataCallbackResult_Continue: oboe_DataCallbackResult = 0;
pub const oboe_DataCallbackResult_Stop: oboe_DataCallbackResult = 1;
#[doc = " The result of an audio callback."]
pub type oboe_DataCallbackResult = i32;
pub const oboe_Result_OK: oboe_Result = 0;
pub const oboe_Result_ErrorBase: oboe_Result = -900;
pub const oboe_Result_ErrorDisconnected: oboe_Result = -899;
pub const oboe_Result_ErrorIllegalArgument: oboe_Result = -898;
pub const oboe_Result_ErrorInternal: oboe_Result = -896;
pub const oboe_Result_ErrorInvalidState: oboe_Result = -895;
pub const oboe_Result_ErrorInvalidHandle: oboe_Result = -892;
pub const oboe_Result_ErrorUnimplemented: oboe_Result = -890;
pub const oboe_Result_ErrorUnavailable: oboe_Result = -889;
pub const oboe_Result_ErrorNoFreeHandles: oboe_Result = -888;
pub const oboe_Result_ErrorNoMemory: oboe_Result = -887;
pub const oboe_Result_ErrorNull: oboe_Result = -886;
pub const oboe_Result_ErrorTimeout: oboe_Result = -885;
pub const oboe_Result_ErrorWouldBlock: oboe_Result = -884;
pub const oboe_Result_ErrorInvalidFormat: oboe_Result = -883;
pub const oboe_Result_ErrorOutOfRange: oboe_Result = -882;
pub const oboe_Result_ErrorNoService: oboe_Result = -881;
pub const oboe_Result_ErrorInvalidRate: oboe_Result = -880;
pub const oboe_Result_Reserved1: oboe_Result = -879;
pub const oboe_Result_Reserved2: oboe_Result = -878;
pub const oboe_Result_Reserved3: oboe_Result = -877;
pub const oboe_Result_Reserved4: oboe_Result = -876;
pub const oboe_Result_Reserved5: oboe_Result = -875;
pub const oboe_Result_Reserved6: oboe_Result = -874;
pub const oboe_Result_Reserved7: oboe_Result = -873;
pub const oboe_Result_Reserved8: oboe_Result = -872;
pub const oboe_Result_Reserved9: oboe_Result = -871;
pub const oboe_Result_Reserved10: oboe_Result = -870;
pub const oboe_Result_ErrorClosed: oboe_Result = -869;
#[doc = " The result of an operation. All except the `OK` result indicates that an error occurred.\n The `Result` can be converted into a human readable string using `convertToText`."]
pub type oboe_Result = i32;
#[doc = " This will be the only stream using a particular source or sink.\n This mode will provide the lowest possible latency.\n You should close EXCLUSIVE streams immediately when you are not using them.\n\n If you do not need the lowest possible latency then we recommend using Shared,\n which is the default."]
pub const oboe_SharingMode_Exclusive: oboe_SharingMode = 0;
#[doc = " Multiple applications can share the same device.\n The data from output streams will be mixed by the audio service.\n The data for input streams will be distributed by the audio service.\n\n This will have higher latency than the EXCLUSIVE mode."]
pub const oboe_SharingMode_Shared: oboe_SharingMode = 1;
#[doc = " The sharing mode of the audio stream."]
pub type oboe_SharingMode = i32;
#[doc = " No particular performance needs. Default."]
pub const oboe_PerformanceMode_None: oboe_PerformanceMode = 10;
#[doc = " Extending battery life is most important."]
pub const oboe_PerformanceMode_PowerSaving: oboe_PerformanceMode = 11;
#[doc = " Reducing latency is most important."]
pub const oboe_PerformanceMode_LowLatency: oboe_PerformanceMode = 12;
#[doc = " The performance mode of the audio stream."]
pub type oboe_PerformanceMode = i32;
#[doc = " Try to use AAudio. If not available then use OpenSL ES."]
pub const oboe_AudioApi_Unspecified: oboe_AudioApi = 0;
#[doc = " Use OpenSL ES.\n Note that OpenSL ES is deprecated in Android 13, API 30 and above."]
pub const oboe_AudioApi_OpenSLES: oboe_AudioApi = 1;
#[doc = " Try to use AAudio. Fail if unavailable.\n AAudio was first supported in Android 8, API 26 and above.\n It is only recommended for API 27 and above."]
pub const oboe_AudioApi_AAudio: oboe_AudioApi = 2;
#[doc = " The underlying audio API used by the audio stream."]
pub type oboe_AudioApi = i32;
#[doc = " No conversion by Oboe. Underlying APIs may still do conversion."]
pub const oboe_SampleRateConversionQuality_None: oboe_SampleRateConversionQuality = 0;
#[doc = " Fastest conversion but may not sound great.\n This may be implemented using bilinear interpolation."]
pub const oboe_SampleRateConversionQuality_Fastest: oboe_SampleRateConversionQuality = 1;
#[doc = " Low quality conversion with 8 taps."]
pub const oboe_SampleRateConversionQuality_Low: oboe_SampleRateConversionQuality = 2;
#[doc = " Medium quality conversion with 16 taps."]
pub const oboe_SampleRateConversionQuality_Medium: oboe_SampleRateConversionQuality = 3;
#[doc = " High quality conversion with 32 taps."]
pub const oboe_SampleRateConversionQuality_High: oboe_SampleRateConversionQuality = 4;
#[doc = " Highest quality conversion, which may be expensive in terms of CPU."]
pub const oboe_SampleRateConversionQuality_Best: oboe_SampleRateConversionQuality = 5;
#[doc = " Specifies the quality of the sample rate conversion performed by Oboe.\n Higher quality will require more CPU load.\n Higher quality conversion will probably be implemented using a sinc based resampler."]
pub type oboe_SampleRateConversionQuality = i32;
#[doc = " Use this for streaming media, music performance, video, podcasts, etcetera."]
pub const oboe_Usage_Media: oboe_Usage = 1;
#[doc = " Use this for voice over IP, telephony, etcetera."]
pub const oboe_Usage_VoiceCommunication: oboe_Usage = 2;
#[doc = " Use this for sounds associated with telephony such as busy tones, DTMF, etcetera."]
pub const oboe_Usage_VoiceCommunicationSignalling: oboe_Usage = 3;
#[doc = " Use this to demand the users attention."]
pub const oboe_Usage_Alarm: oboe_Usage = 4;
#[doc = " Use this for notifying the user when a message has arrived or some\n other background event has occured."]
pub const oboe_Usage_Notification: oboe_Usage = 5;
#[doc = " Use this when the phone rings."]
pub const oboe_Usage_NotificationRingtone: oboe_Usage = 6;
#[doc = " Use this to attract the users attention when, for example, the battery is low."]
pub const oboe_Usage_NotificationEvent: oboe_Usage = 10;
#[doc = " Use this for screen readers, etcetera."]
pub const oboe_Usage_AssistanceAccessibility: oboe_Usage = 11;
#[doc = " Use this for driving or navigation directions."]
pub const oboe_Usage_AssistanceNavigationGuidance: oboe_Usage = 12;
#[doc = " Use this for user interface sounds, beeps, etcetera."]
pub const oboe_Usage_AssistanceSonification: oboe_Usage = 13;
#[doc = " Use this for game audio and sound effects."]
pub const oboe_Usage_Game: oboe_Usage = 14;
#[doc = " Use this for audio responses to user queries, audio instructions or help utterances."]
pub const oboe_Usage_Assistant: oboe_Usage = 16;
#[doc = " The Usage attribute expresses *why* you are playing a sound, what is this sound used for.\n This information is used by certain platforms or routing policies\n to make more refined volume or routing decisions.\n\n Note that these match the equivalent values in AudioAttributes in the Android Java API.\n\n This attribute only has an effect on Android API 28+."]
pub type oboe_Usage = i32;
#[doc = " Use this for spoken voice, audio books, etcetera."]
pub const oboe_ContentType_Speech: oboe_ContentType = 1;
#[doc = " Use this for pre-recorded or live music."]
pub const oboe_ContentType_Music: oboe_ContentType = 2;
#[doc = " Use this for a movie or video soundtrack."]
pub const oboe_ContentType_Movie: oboe_ContentType = 3;
#[doc = " Use this for sound is designed to accompany a user action,\n such as a click or beep sound made when the user presses a button."]
pub const oboe_ContentType_Sonification: oboe_ContentType = 4;
#[doc = " The ContentType attribute describes *what* you are playing.\n It expresses the general category of the content. This information is optional.\n But in case it is known (for instance {@link Movie} for a\n movie streaming service or {@link Speech} for\n an audio book application) this information might be used by the audio framework to\n enforce audio focus.\n\n Note that these match the equivalent values in AudioAttributes in the Android Java API.\n\n This attribute only has an effect on Android API 28+."]
pub type oboe_ContentType = i32;
#[doc = " Use this preset when other presets do not apply."]
pub const oboe_InputPreset_Generic: oboe_InputPreset = 1;
#[doc = " Use this preset when recording video."]
pub const oboe_InputPreset_Camcorder: oboe_InputPreset = 5;
#[doc = " Use this preset when doing speech recognition."]
pub const oboe_InputPreset_VoiceRecognition: oboe_InputPreset = 6;
#[doc = " Use this preset when doing telephony or voice messaging."]
pub const oboe_InputPreset_VoiceCommunication: oboe_InputPreset = 7;
#[doc = " Use this preset to obtain an input with no effects.\n Note that this input will not have automatic gain control\n so the recorded volume may be very low."]
pub const oboe_InputPreset_Unprocessed: oboe_InputPreset = 9;
#[doc = " Use this preset for capturing audio meant to be processed in real time\n and played back for live performance (e.g karaoke).\n The capture path will minimize latency and coupling with playback path."]
pub const oboe_InputPreset_VoicePerformance: oboe_InputPreset = 10;
#[doc = " Defines the audio source.\n An audio source defines both a default physical source of audio signal, and a recording\n configuration.\n\n Note that these match the equivalent values in MediaRecorder.AudioSource in the Android Java API.\n\n This attribute only has an effect on Android API 28+."]
pub type oboe_InputPreset = i32;
#[doc = " Do not allocate a session ID.\n Effects cannot be used with this stream.\n Default."]
pub const oboe_SessionId_None: oboe_SessionId = -1;
#[doc = " Allocate a session ID that can be used to attach and control\n effects using the Java AudioEffects API.\n Note that the use of this flag may result in higher latency.\n\n Note that this matches the value of AudioManager.AUDIO_SESSION_ID_GENERATE."]
pub const oboe_SessionId_Allocate: oboe_SessionId = 0;
#[doc = " This attribute can be used to allocate a session ID to the audio stream.\n\n This attribute only has an effect on Android API 28+."]
pub type oboe_SessionId = ::std::os::raw::c_int;
#[doc = " Audio channel count definition, use Mono or Stereo"]
pub const oboe_ChannelCount_Unspecified: oboe_ChannelCount = 0;
#[doc = " Use this for mono audio"]
pub const oboe_ChannelCount_Mono: oboe_ChannelCount = 1;
#[doc = " Use this for stereo audio."]
pub const oboe_ChannelCount_Stereo: oboe_ChannelCount = 2;
#[doc = " The channel count of the audio stream. The underlying type is `int32_t`.\n Use of this enum is convenient to avoid \"magic\"\n numbers when specifying the channel count.\n\n For example, you can write\n `builder.setChannelCount(ChannelCount::Stereo)`\n rather than `builder.setChannelCount(2)`\n"]
pub type oboe_ChannelCount = i32;
pub const oboe_ChannelMask_Unspecified: oboe_ChannelMask = 0;
pub const oboe_ChannelMask_FrontLeft: oboe_ChannelMask = 1;
pub const oboe_ChannelMask_FrontRight: oboe_ChannelMask = 2;
pub const oboe_ChannelMask_FrontCenter: oboe_ChannelMask = 4;
pub const oboe_ChannelMask_LowFrequency: oboe_ChannelMask = 8;
pub const oboe_ChannelMask_BackLeft: oboe_ChannelMask = 16;
pub const oboe_ChannelMask_BackRight: oboe_ChannelMask = 32;
pub const oboe_ChannelMask_FrontLeftOfCenter: oboe_ChannelMask = 64;
pub const oboe_ChannelMask_FrontRightOfCenter: oboe_ChannelMask = 128;
pub const oboe_ChannelMask_BackCenter: oboe_ChannelMask = 256;
pub const oboe_ChannelMask_SideLeft: oboe_ChannelMask = 512;
pub const oboe_ChannelMask_SideRight: oboe_ChannelMask = 1024;
pub const oboe_ChannelMask_TopCenter: oboe_ChannelMask = 2048;
pub const oboe_ChannelMask_TopFrontLeft: oboe_ChannelMask = 4096;
pub const oboe_ChannelMask_TopFrontCenter: oboe_ChannelMask = 8192;
pub const oboe_ChannelMask_TopFrontRight: oboe_ChannelMask = 16384;
pub const oboe_ChannelMask_TopBackLeft: oboe_ChannelMask = 32768;
pub const oboe_ChannelMask_TopBackCenter: oboe_ChannelMask = 65536;
pub const oboe_ChannelMask_TopBackRight: oboe_ChannelMask = 131072;
pub const oboe_ChannelMask_TopSideLeft: oboe_ChannelMask = 262144;
pub const oboe_ChannelMask_TopSideRight: oboe_ChannelMask = 524288;
pub const oboe_ChannelMask_BottomFrontLeft: oboe_ChannelMask = 1048576;
pub const oboe_ChannelMask_BottomFrontCenter: oboe_ChannelMask = 2097152;
pub const oboe_ChannelMask_BottomFrontRight: oboe_ChannelMask = 4194304;
pub const oboe_ChannelMask_LowFrequency2: oboe_ChannelMask = 8388608;
pub const oboe_ChannelMask_FrontWideLeft: oboe_ChannelMask = 16777216;
pub const oboe_ChannelMask_FrontWideRight: oboe_ChannelMask = 33554432;
#[doc = " Supported for Input and Output"]
pub const oboe_ChannelMask_Mono: oboe_ChannelMask = 1;
#[doc = " Supported for Input and Output"]
pub const oboe_ChannelMask_Stereo: oboe_ChannelMask = 3;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM2Point1: oboe_ChannelMask = 11;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_Tri: oboe_ChannelMask = 7;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_TriBack: oboe_ChannelMask = 259;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM3Point1: oboe_ChannelMask = 15;
#[doc = " Supported for Input and Output"]
pub const oboe_ChannelMask_CM2Point0Point2: oboe_ChannelMask = 786435;
#[doc = " Supported for Input and Output"]
pub const oboe_ChannelMask_CM2Point1Point2: oboe_ChannelMask = 786443;
#[doc = " Supported for Input and Output"]
pub const oboe_ChannelMask_CM3Point0Point2: oboe_ChannelMask = 786439;
#[doc = " Supported for Input and Output"]
pub const oboe_ChannelMask_CM3Point1Point2: oboe_ChannelMask = 786447;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_Quad: oboe_ChannelMask = 51;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_QuadSide: oboe_ChannelMask = 1539;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_Surround: oboe_ChannelMask = 263;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_Penta: oboe_ChannelMask = 55;
#[doc = " Supported for Input and Output. aka 5Point1Back"]
pub const oboe_ChannelMask_CM5Point1: oboe_ChannelMask = 63;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM5Point1Side: oboe_ChannelMask = 1551;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM6Point1: oboe_ChannelMask = 319;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM7Point1: oboe_ChannelMask = 1599;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM5Point1Point2: oboe_ChannelMask = 786495;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM5Point1Point4: oboe_ChannelMask = 184383;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM7Point1Point2: oboe_ChannelMask = 788031;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM7Point1Point4: oboe_ChannelMask = 185919;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM9Point1Point4: oboe_ChannelMask = 50517567;
#[doc = " Supported for only Output"]
pub const oboe_ChannelMask_CM9Point1Point6: oboe_ChannelMask = 51303999;
#[doc = " Supported for only Input"]
pub const oboe_ChannelMask_FrontBack: oboe_ChannelMask = 260;
#[doc = " The channel mask of the audio stream. The underlying type is `uint32_t`.\n Use of this enum is convenient.\n\n ChannelMask::Unspecified means this is not specified.\n The rest of the enums are channel position masks.\n Use the combinations of the channel position masks defined below instead of\n using those values directly.\n\n Channel masks are for input only, output only, or both input and output.\n These channel masks are different than those defined in AudioFormat.java.\n If an app gets a channel mask from Java API and wants to use it in Oboe,\n conversion should be done by the app."]
pub type oboe_ChannelMask = u32;
#[doc = " Constant indicating that the spatialization behavior is not specified."]
pub const oboe_SpatializationBehavior_Unspecified: oboe_SpatializationBehavior = 0;
#[doc = " Constant indicating the audio content associated with these attributes will follow the\n default platform behavior with regards to which content will be spatialized or not."]
pub const oboe_SpatializationBehavior_Auto: oboe_SpatializationBehavior = 1;
#[doc = " Constant indicating the audio content associated with these attributes should never\n be spatialized."]
pub const oboe_SpatializationBehavior_Never: oboe_SpatializationBehavior = 2;
#[doc = " The spatialization behavior of the audio stream."]
pub type oboe_SpatializationBehavior = i32;
#[doc = " When not explicitly requested, set privacy sensitive mode according to input preset:\n communication and camcorder captures are considered privacy sensitive by default."]
pub const oboe_PrivacySensitiveMode_Unspecified: oboe_PrivacySensitiveMode = 0;
#[doc = " Privacy sensitive mode disabled."]
pub const oboe_PrivacySensitiveMode_Disabled: oboe_PrivacySensitiveMode = 1;
#[doc = " Privacy sensitive mode enabled."]
pub const oboe_PrivacySensitiveMode_Enabled: oboe_PrivacySensitiveMode = 2;
#[doc = " The PrivacySensitiveMode attribute determines whether an input stream can be shared\n with another privileged app, for example the Assistant.\n\n This allows to override the default behavior tied to the audio source (e.g\n InputPreset::VoiceCommunication is private by default but InputPreset::Unprocessed is not)."]
pub type oboe_PrivacySensitiveMode = i32;
#[doc = " When not explicitly requested, set privacy sensitive mode according to the Usage.\n This should behave similarly to setting AllowedCapturePolicy::All."]
pub const oboe_AllowedCapturePolicy_Unspecified: oboe_AllowedCapturePolicy = 0;
#[doc = " Indicates that the audio may be captured by any app.\n\n For privacy, the following Usages can not be recorded: VoiceCommunication*,\n Notification*, Assistance* and Assistant.\n\n On Android Q, only Usage::Game and Usage::Media may be captured.\n\n See ALLOW_CAPTURE_BY_ALL in the AudioAttributes Java API."]
pub const oboe_AllowedCapturePolicy_All: oboe_AllowedCapturePolicy = 1;
#[doc = " Indicates that the audio may only be captured by system apps.\n\n System apps can capture for many purposes like accessibility, user guidance...\n but have strong restriction. See ALLOW_CAPTURE_BY_SYSTEM in the AudioAttributes Java API\n for what the system apps can do with the capture audio."]
pub const oboe_AllowedCapturePolicy_System: oboe_AllowedCapturePolicy = 2;
#[doc = " Indicates that the audio may not be recorded by any app, even if it is a system app.\n\n It is encouraged to use AllowedCapturePolicy::System instead of this value as system apps\n provide significant and useful features for the user (eg. accessibility).\n See ALLOW_CAPTURE_BY_NONE in the AudioAttributes Java API"]
pub const oboe_AllowedCapturePolicy_None: oboe_AllowedCapturePolicy = 3;
#[doc = " Specifies whether audio may or may not be captured by other apps or the system for an\n output stream.\n\n Note that these match the equivalent values in AudioAttributes in the Android Java API.\n\n Added in API level 29 for AAudio."]
pub type oboe_AllowedCapturePolicy = i32;
#[doc = " On API 16 to 26 OpenSL ES will be used. When using OpenSL ES the optimal values for sampleRate and\n framesPerBurst are not known by the native code.\n On API 17+ these values should be obtained from the AudioManager using this code:\n\n <pre><code>\n // Note that this technique only works for built-in speakers and headphones.\n AudioManager myAudioMgr = (AudioManager) getSystemService(Context.AUDIO_SERVICE);\n String sampleRateStr = myAudioMgr.getProperty(AudioManager.PROPERTY_OUTPUT_SAMPLE_RATE);\n int defaultSampleRate = Integer.parseInt(sampleRateStr);\n String framesPerBurstStr = myAudioMgr.getProperty(AudioManager.PROPERTY_OUTPUT_FRAMES_PER_BUFFER);\n int defaultFramesPerBurst = Integer.parseInt(framesPerBurstStr);\n </code></pre>\n\n It can then be passed down to Oboe through JNI.\n\n AAudio will get the optimal framesPerBurst from the HAL and will ignore this value."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct oboe_DefaultStreamValues {
    pub _address: u8,
}
extern "C" {
    #[doc = " The default sample rate to use when opening new audio streams"]
    #[link_name = "\u{1}_ZN4oboe19DefaultStreamValues10SampleRateE"]
    pub static mut oboe_DefaultStreamValues_SampleRate: i32;
}
extern "C" {
    #[doc = " The default frames per burst to use when opening new audio streams"]
    #[link_name = "\u{1}_ZN4oboe19DefaultStreamValues14FramesPerBurstE"]
    pub static mut oboe_DefaultStreamValues_FramesPerBurst: i32;
}
extern "C" {
    #[doc = " The default channel count to use when opening new audio streams"]
    #[link_name = "\u{1}_ZN4oboe19DefaultStreamValues12ChannelCountE"]
    pub static mut oboe_DefaultStreamValues_ChannelCount: i32;
}
#[test]
fn bindgen_test_layout_oboe_DefaultStreamValues() {
    assert_eq!(
        ::std::mem::size_of::<oboe_DefaultStreamValues>(),
        1usize,
        concat!("Size of: ", stringify!(oboe_DefaultStreamValues))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_DefaultStreamValues>(),
        1usize,
        concat!("Alignment of ", stringify!(oboe_DefaultStreamValues))
    );
}
#[doc = " The time at which the frame at `position` was presented"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct oboe_FrameTimestamp {
    pub position: i64,
    pub timestamp: i64,
}
#[test]
fn bindgen_test_layout_oboe_FrameTimestamp() {
    const UNINIT: ::std::mem::MaybeUninit<oboe_FrameTimestamp> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<oboe_FrameTimestamp>(),
        16usize,
        concat!("Size of: ", stringify!(oboe_FrameTimestamp))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_FrameTimestamp>(),
        8usize,
        concat!("Alignment of ", stringify!(oboe_FrameTimestamp))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).position) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_FrameTimestamp),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timestamp) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_FrameTimestamp),
            "::",
            stringify!(timestamp)
        )
    );
}
#[doc = " A ResultWithValue can store both the result of an operation (either OK or an error) and a value.\n\n It has been designed for cases where the caller needs to know whether an operation succeeded and,\n if it did, a value which was obtained during the operation.\n\n For example, when reading from a stream the caller needs to know the result of the read operation\n and, if it was successful, how many frames were read. Note that ResultWithValue can be evaluated\n as a boolean so it's simple to check whether the result is OK.\n\n <code>\n ResultWithValue<int32_t> resultOfRead = myStream.read(&buffer, numFrames, timeoutNanoseconds);\n\n if (resultOfRead) {\n     LOGD(\"Frames read: %d\", resultOfRead.value());\n } else {\n     LOGD(\"Error reading from stream: %s\", resultOfRead.error());\n }\n </code>"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct oboe_ResultWithValue<T> {
    pub mValue: T,
    pub mError: oboe_Result,
    pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
}
#[repr(C)]
pub struct oboe_AudioStreamDataCallback__bindgen_vtable(::std::os::raw::c_void);
#[doc = " AudioStreamDataCallback defines a callback interface for\n moving data to/from an audio stream using `onAudioReady`\n 2) being alerted when a stream has an error using `onError*` methods\n\n It is used with AudioStreamBuilder::setDataCallback()."]
#[repr(C)]
#[derive(Debug)]
pub struct oboe_AudioStreamDataCallback {
    pub vtable_: *const oboe_AudioStreamDataCallback__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_oboe_AudioStreamDataCallback() {
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStreamDataCallback>(),
        4usize,
        concat!("Size of: ", stringify!(oboe_AudioStreamDataCallback))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStreamDataCallback>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_AudioStreamDataCallback))
    );
}
#[repr(C)]
pub struct oboe_AudioStreamErrorCallback__bindgen_vtable(::std::os::raw::c_void);
#[doc = " AudioStreamErrorCallback defines a callback interface for\n being alerted when a stream has an error or is disconnected\n using `onError*` methods.\n\n Note: This callback is only fired when an AudioStreamCallback is set.\n If you use AudioStream::write() you have to evaluate the return codes of\n AudioStream::write() to notice errors in the stream.\n\n It is used with AudioStreamBuilder::setErrorCallback()."]
#[repr(C)]
#[derive(Debug)]
pub struct oboe_AudioStreamErrorCallback {
    pub vtable_: *const oboe_AudioStreamErrorCallback__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_oboe_AudioStreamErrorCallback() {
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStreamErrorCallback>(),
        4usize,
        concat!("Size of: ", stringify!(oboe_AudioStreamErrorCallback))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStreamErrorCallback>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_AudioStreamErrorCallback))
    );
}
#[doc = " AudioStreamCallback defines a callback interface for:\n\n 1) moving data to/from an audio stream using `onAudioReady`\n 2) being alerted when a stream has an error using `onError*` methods\n\n It is used with AudioStreamBuilder::setCallback().\n\n It combines the interfaces defined by AudioStreamDataCallback and AudioStreamErrorCallback.\n This was the original callback object. We now recommend using the individual interfaces\n and using setDataCallback() and setErrorCallback().\n\n @deprecated Use `AudioStreamDataCallback` and `AudioStreamErrorCallback` instead"]
#[repr(C)]
#[derive(Debug)]
pub struct oboe_AudioStreamCallback {
    pub _base: oboe_AudioStreamDataCallback,
    pub _base_1: oboe_AudioStreamErrorCallback,
}
#[test]
fn bindgen_test_layout_oboe_AudioStreamCallback() {
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStreamCallback>(),
        8usize,
        concat!("Size of: ", stringify!(oboe_AudioStreamCallback))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStreamCallback>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_AudioStreamCallback))
    );
}
#[repr(C)]
pub struct oboe_AudioStreamBase__bindgen_vtable(::std::os::raw::c_void);
#[doc = " Base class containing parameters for audio streams and builders."]
#[repr(C)]
pub struct oboe_AudioStreamBase {
    pub vtable_: *const oboe_AudioStreamBase__bindgen_vtable,
    #[doc = " The callback which will be fired when new data is ready to be read/written."]
    pub mDataCallback: *mut oboe_AudioStreamDataCallback,
    pub mSharedDataCallback: [u32; 2usize],
    #[doc = " The callback which will be fired when an error or a disconnect occurs."]
    pub mErrorCallback: *mut oboe_AudioStreamErrorCallback,
    pub mSharedErrorCallback: [u32; 2usize],
    #[doc = " Number of audio frames which will be requested in each callback"]
    pub mFramesPerCallback: i32,
    #[doc = " Stream channel count"]
    pub mChannelCount: i32,
    #[doc = " Stream sample rate"]
    pub mSampleRate: i32,
    #[doc = " Stream audio device ID"]
    pub mDeviceId: i32,
    #[doc = " Stream buffer capacity specified as a number of audio frames"]
    pub mBufferCapacityInFrames: i32,
    #[doc = " Stream buffer size specified as a number of audio frames"]
    pub mBufferSizeInFrames: i32,
    #[doc = " Stream channel mask. Only active on Android 32+"]
    pub mChannelMask: oboe_ChannelMask,
    #[doc = " Stream sharing mode"]
    pub mSharingMode: oboe_SharingMode,
    #[doc = " Format of audio frames"]
    pub mFormat: oboe_AudioFormat,
    #[doc = " Stream direction"]
    pub mDirection: oboe_Direction,
    #[doc = " Stream performance mode"]
    pub mPerformanceMode: oboe_PerformanceMode,
    #[doc = " Stream usage. Only active on Android 28+"]
    pub mUsage: oboe_Usage,
    #[doc = " Stream content type. Only active on Android 28+"]
    pub mContentType: oboe_ContentType,
    #[doc = " Stream input preset. Only active on Android 28+\n TODO InputPreset::Unspecified should be considered as a possible default alternative."]
    pub mInputPreset: oboe_InputPreset,
    #[doc = " Stream session ID allocation strategy. Only active on Android 28+"]
    pub mSessionId: oboe_SessionId,
    #[doc = " Allowed Capture Policy. Only active on Android 29+"]
    pub mAllowedCapturePolicy: oboe_AllowedCapturePolicy,
    #[doc = " Privacy Sensitive Mode. Only active on Android 30+"]
    pub mPrivacySensitiveMode: oboe_PrivacySensitiveMode,
    #[doc = " Control the name of the package creating the stream. Only active on Android 31+"]
    pub mPackageName: std_string,
    #[doc = " Control the attribution tag of the context creating the stream. Only active on Android 31+"]
    pub mAttributionTag: std_string,
    #[doc = " Whether the content is already spatialized. Only used on Android 32+"]
    pub mIsContentSpatialized: bool,
    #[doc = " Spatialization Behavior. Only active on Android 32+"]
    pub mSpatializationBehavior: oboe_SpatializationBehavior,
    #[doc = " Hardware channel count. Only specified on Android 34+ AAudio streams"]
    pub mHardwareChannelCount: i32,
    #[doc = " Hardware sample rate. Only specified on Android 34+ AAudio streams"]
    pub mHardwareSampleRate: i32,
    #[doc = " Hardware format. Only specified on Android 34+ AAudio streams"]
    pub mHardwareFormat: oboe_AudioFormat,
    pub mChannelConversionAllowed: bool,
    pub mFormatConversionAllowed: bool,
    pub mSampleRateConversionQuality: oboe_SampleRateConversionQuality,
}
#[test]
fn bindgen_test_layout_oboe_AudioStreamBase() {
    const UNINIT: ::std::mem::MaybeUninit<oboe_AudioStreamBase> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStreamBase>(),
        148usize,
        concat!("Size of: ", stringify!(oboe_AudioStreamBase))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStreamBase>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_AudioStreamBase))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mDataCallback) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mDataCallback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mSharedDataCallback) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSharedDataCallback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mErrorCallback) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mErrorCallback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mSharedErrorCallback) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSharedErrorCallback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mFramesPerCallback) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mFramesPerCallback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mChannelCount) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mChannelCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mSampleRate) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSampleRate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mDeviceId) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mDeviceId)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mBufferCapacityInFrames) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mBufferCapacityInFrames)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mBufferSizeInFrames) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mBufferSizeInFrames)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mChannelMask) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mChannelMask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mSharingMode) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSharingMode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mFormat) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mFormat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mDirection) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mDirection)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mPerformanceMode) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mPerformanceMode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mUsage) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mUsage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mContentType) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mContentType)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mInputPreset) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mInputPreset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mSessionId) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSessionId)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mAllowedCapturePolicy) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mAllowedCapturePolicy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mPrivacySensitiveMode) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mPrivacySensitiveMode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mPackageName) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mPackageName)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mAttributionTag) as usize - ptr as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mAttributionTag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mIsContentSpatialized) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mIsContentSpatialized)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mSpatializationBehavior) as usize - ptr as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSpatializationBehavior)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mHardwareChannelCount) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mHardwareChannelCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mHardwareSampleRate) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mHardwareSampleRate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mHardwareFormat) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mHardwareFormat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mChannelConversionAllowed) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mChannelConversionAllowed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mFormatConversionAllowed) as usize - ptr as usize },
        141usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mFormatConversionAllowed)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).mSampleRateConversionQuality) as usize - ptr as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamBase),
            "::",
            stringify!(mSampleRateConversionQuality)
        )
    );
}
extern "C" {
    #[doc = " Return the version of the SDK that is currently running.\n\n For example, on Android, this would return 27 for Oreo 8.1.\n If the version number cannot be determined then this will return -1.\n\n @return version number or -1"]
    #[link_name = "\u{1}_ZN4oboe13getSdkVersionEv"]
    pub fn oboe_getSdkVersion() -> ::std::os::raw::c_int;
}
#[doc = " Factory class for an audio Stream."]
#[repr(C)]
#[repr(align(4))]
pub struct oboe_AudioStreamBuilder {
    pub _bindgen_opaque_blob: [u32; 38usize],
}
#[test]
fn bindgen_test_layout_oboe_AudioStreamBuilder() {
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStreamBuilder>(),
        152usize,
        concat!("Size of: ", stringify!(oboe_AudioStreamBuilder))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStreamBuilder>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_AudioStreamBuilder))
    );
}
extern "C" {
    #[doc = " Is the AAudio API supported on this device?\n\n AAudio was introduced in the Oreo 8.0 release.\n\n @return true if supported"]
    #[link_name = "\u{1}_ZN4oboe18AudioStreamBuilder17isAAudioSupportedEv"]
    pub fn oboe_AudioStreamBuilder_isAAudioSupported() -> bool;
}
extern "C" {
    #[doc = " Is the AAudio API recommended this device?\n\n AAudio may be supported but not recommended because of version specific issues.\n AAudio is not recommended for Android 8.0 or earlier versions.\n\n @return true if recommended"]
    #[link_name = "\u{1}_ZN4oboe18AudioStreamBuilder19isAAudioRecommendedEv"]
    pub fn oboe_AudioStreamBuilder_isAAudioRecommended() -> bool;
}
impl oboe_AudioStreamBuilder {
    #[inline]
    pub unsafe fn isAAudioSupported() -> bool {
        oboe_AudioStreamBuilder_isAAudioSupported()
    }
    #[inline]
    pub unsafe fn isAAudioRecommended() -> bool {
        oboe_AudioStreamBuilder_isAAudioRecommended()
    }
}
#[doc = " Base class for Oboe C++ audio stream."]
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct oboe_AudioStream {
    pub _bindgen_opaque_blob: [u64; 25usize],
}
#[test]
fn bindgen_test_layout_oboe_AudioStream() {
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStream>(),
        200usize,
        concat!("Size of: ", stringify!(oboe_AudioStream))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStream>(),
        8usize,
        concat!("Alignment of ", stringify!(oboe_AudioStream))
    );
}
extern "C" {
    #[doc = " Get the number of bytes per sample. This is calculated using the sample format. For example,\n a stream using 16-bit integer samples will have 2 bytes per sample.\n\n @return the number of bytes per sample."]
    #[link_name = "\u{1}_ZNK4oboe11AudioStream17getBytesPerSampleEv"]
    pub fn oboe_AudioStream_getBytesPerSample(this: *const oboe_AudioStream) -> i32;
}
extern "C" {
    #[doc = " @return number of frames of data currently in the buffer"]
    #[link_name = "\u{1}_ZN4oboe11AudioStream18getAvailableFramesEv"]
    pub fn oboe_AudioStream_getAvailableFrames(
        this: *mut oboe_AudioStream,
    ) -> oboe_ResultWithValue<i32>;
}
extern "C" {
    #[doc = " Wait until the stream has a minimum amount of data available in its buffer.\n This can be used with an EXCLUSIVE MMAP input stream to avoid reading data too close to\n the DSP write position, which may cause glitches.\n\n Starting with Oboe 1.7.1, the numFrames will be clipped internally against the\n BufferCapacity minus BurstSize. This is to prevent trying to wait for more frames\n than could possibly be available. In this case, the return value may be less than numFrames.\n Note that there may still be glitching if numFrames is too high.\n\n @param numFrames requested minimum frames available\n @param timeoutNanoseconds\n @return number of frames available, ErrorTimeout"]
    #[link_name = "\u{1}_ZN4oboe11AudioStream22waitForAvailableFramesEix"]
    pub fn oboe_AudioStream_waitForAvailableFrames(
        this: *mut oboe_AudioStream,
        numFrames: i32,
        timeoutNanoseconds: i64,
    ) -> oboe_ResultWithValue<i32>;
}
extern "C" {
    #[doc = " Override this to provide your own behaviour for the audio callback\n\n @param audioData container array which audio frames will be written into or read from\n @param numFrames number of frames which were read/written\n @return the result of the callback: stop or continue\n"]
    #[link_name = "\u{1}_ZN4oboe11AudioStream16fireDataCallbackEPvi"]
    pub fn oboe_AudioStream_fireDataCallback(
        this: *mut oboe_AudioStream,
        audioData: *mut ::std::os::raw::c_void,
        numFrames: ::std::os::raw::c_int,
    ) -> oboe_DataCallbackResult;
}
extern "C" {
    #[doc = " This should only be called as a stream is being opened.\n Otherwise we might override setDelayBeforeCloseMillis()."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream38calculateDefaultDelayBeforeCloseMillisEv"]
    pub fn oboe_AudioStream_calculateDefaultDelayBeforeCloseMillis(this: *mut oboe_AudioStream);
}
extern "C" {
    #[doc = " Construct an `AudioStream` using the given `AudioStreamBuilder`\n\n @param builder containing all the stream's attributes"]
    #[link_name = "\u{1}_ZN4oboe11AudioStreamC2ERKNS_18AudioStreamBuilderE"]
    pub fn oboe_AudioStream_AudioStream(
        this: *mut oboe_AudioStream,
        builder: *const oboe_AudioStreamBuilder,
    );
}
impl oboe_AudioStream {
    #[inline]
    pub unsafe fn getBytesPerSample(&self) -> i32 {
        oboe_AudioStream_getBytesPerSample(self)
    }
    #[inline]
    pub unsafe fn getAvailableFrames(&mut self) -> oboe_ResultWithValue<i32> {
        oboe_AudioStream_getAvailableFrames(self)
    }
    #[inline]
    pub unsafe fn waitForAvailableFrames(
        &mut self,
        numFrames: i32,
        timeoutNanoseconds: i64,
    ) -> oboe_ResultWithValue<i32> {
        oboe_AudioStream_waitForAvailableFrames(self, numFrames, timeoutNanoseconds)
    }
    #[inline]
    pub unsafe fn fireDataCallback(
        &mut self,
        audioData: *mut ::std::os::raw::c_void,
        numFrames: ::std::os::raw::c_int,
    ) -> oboe_DataCallbackResult {
        oboe_AudioStream_fireDataCallback(self, audioData, numFrames)
    }
    #[inline]
    pub unsafe fn calculateDefaultDelayBeforeCloseMillis(&mut self) {
        oboe_AudioStream_calculateDefaultDelayBeforeCloseMillis(self)
    }
    #[inline]
    pub unsafe fn new(builder: *const oboe_AudioStreamBuilder) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        oboe_AudioStream_AudioStream(__bindgen_tmp.as_mut_ptr(), builder);
        __bindgen_tmp.assume_init()
    }
}
extern "C" {
    #[doc = " Close the stream and deallocate any resources from the open() call."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream5closeEv"]
    pub fn oboe_AudioStream_close(this: *mut ::std::os::raw::c_void) -> oboe_Result;
}
extern "C" {
    #[doc = " Start the stream. This will block until the stream has been started, an error occurs\n or `timeoutNanoseconds` has been reached."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream5startEx"]
    pub fn oboe_AudioStream_start(
        this: *mut ::std::os::raw::c_void,
        timeoutNanoseconds: i64,
    ) -> oboe_Result;
}
extern "C" {
    #[doc = " Pause the stream. This will block until the stream has been paused, an error occurs\n or `timeoutNanoseconds` has been reached."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream5pauseEx"]
    pub fn oboe_AudioStream_pause(
        this: *mut ::std::os::raw::c_void,
        timeoutNanoseconds: i64,
    ) -> oboe_Result;
}
extern "C" {
    #[doc = " Flush the stream. This will block until the stream has been flushed, an error occurs\n or `timeoutNanoseconds` has been reached."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream5flushEx"]
    pub fn oboe_AudioStream_flush(
        this: *mut ::std::os::raw::c_void,
        timeoutNanoseconds: i64,
    ) -> oboe_Result;
}
extern "C" {
    #[doc = " Stop the stream. This will block until the stream has been stopped, an error occurs\n or `timeoutNanoseconds` has been reached."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream4stopEx"]
    pub fn oboe_AudioStream_stop(
        this: *mut ::std::os::raw::c_void,
        timeoutNanoseconds: i64,
    ) -> oboe_Result;
}
extern "C" {
    #[doc = " The number of audio frames written into the stream.\n This monotonic counter will never get reset.\n\n @return the number of frames written so far"]
    #[link_name = "\u{1}_ZN4oboe11AudioStream16getFramesWrittenEv"]
    pub fn oboe_AudioStream_getFramesWritten(this: *mut ::std::os::raw::c_void) -> i64;
}
extern "C" {
    #[doc = " The number of audio frames read from the stream.\n This monotonic counter will never get reset.\n\n @return the number of frames read so far"]
    #[link_name = "\u{1}_ZN4oboe11AudioStream13getFramesReadEv"]
    pub fn oboe_AudioStream_getFramesRead(this: *mut ::std::os::raw::c_void) -> i64;
}
extern "C" {
    #[doc = " Get the estimated time that the frame at `framePosition` entered or left the audio processing\n pipeline.\n\n This can be used to coordinate events and interactions with the external environment, and to\n estimate the latency of an audio stream. An example of usage can be found in the hello-oboe\n sample (search for \"calculateCurrentOutputLatencyMillis\").\n\n The time is based on the implementation's best effort, using whatever knowledge is available\n to the system, but cannot account for any delay unknown to the implementation.\n\n Note that due to issues in Android before R, we recommend NOT calling\n this method from a data callback. See this tech note for more details.\n https://github.com/google/oboe/wiki/TechNote_ReleaseBuffer\n\n See\n @param clockId the type of clock to use e.g. CLOCK_MONOTONIC\n @return a FrameTimestamp containing the position and time at which a particular audio frame\n entered or left the audio processing pipeline, or an error if the operation failed."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream12getTimestampEi"]
    pub fn oboe_AudioStream_getTimestamp(
        this: *mut ::std::os::raw::c_void,
        arg1: clockid_t,
    ) -> oboe_ResultWithValue<oboe_FrameTimestamp>;
}
extern "C" {
    #[doc = " Wait for a transition from one state to another.\n @return OK if the endingState was observed, or ErrorUnexpectedState\n   if any state that was not the startingState or endingState was observed\n   or ErrorTimeout."]
    #[link_name = "\u{1}_ZN4oboe11AudioStream22waitForStateTransitionENS_11StreamStateES1_x"]
    pub fn oboe_AudioStream_waitForStateTransition(
        this: *mut ::std::os::raw::c_void,
        startingState: oboe_StreamState,
        endingState: oboe_StreamState,
        timeoutNanoseconds: i64,
    ) -> oboe_Result;
}
pub const oboe_AudioStream_kMinDelayBeforeCloseMillis: ::std::os::raw::c_int = 10;
#[doc = " This struct is a stateless functor which closes an AudioStream prior to its deletion.\n This means it can be used to safely delete a smart pointer referring to an open stream."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct oboe_StreamDeleterFunctor {
    pub _address: u8,
}
#[test]
fn bindgen_test_layout_oboe_StreamDeleterFunctor() {
    assert_eq!(
        ::std::mem::size_of::<oboe_StreamDeleterFunctor>(),
        1usize,
        concat!("Size of: ", stringify!(oboe_StreamDeleterFunctor))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_StreamDeleterFunctor>(),
        1usize,
        concat!("Alignment of ", stringify!(oboe_StreamDeleterFunctor))
    );
}
#[doc = " LatencyTuner can be used to dynamically tune the latency of an output stream.\n It adjusts the stream's bufferSize by monitoring the number of underruns.\n\n This only affects the latency associated with the first level of buffering that is closest\n to the application. It does not affect low latency in the HAL, or touch latency in the UI.\n\n Call tune() right before returning from your data callback function if using callbacks.\n Call tune() right before calling write() if using blocking writes.\n\n If you want to see the ongoing results of this tuning process then call\n stream->getBufferSize() periodically.\n"]
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct oboe_LatencyTuner {
    pub _bindgen_opaque_blob: [u32; 9usize],
}
pub const oboe_LatencyTuner_State_Idle: oboe_LatencyTuner_State = 0;
pub const oboe_LatencyTuner_State_Active: oboe_LatencyTuner_State = 1;
pub const oboe_LatencyTuner_State_AtMax: oboe_LatencyTuner_State = 2;
pub const oboe_LatencyTuner_State_Unsupported: oboe_LatencyTuner_State = 3;
pub type oboe_LatencyTuner_State = ::std::os::raw::c_int;
#[test]
fn bindgen_test_layout_oboe_LatencyTuner() {
    assert_eq!(
        ::std::mem::size_of::<oboe_LatencyTuner>(),
        36usize,
        concat!("Size of: ", stringify!(oboe_LatencyTuner))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_LatencyTuner>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_LatencyTuner))
    );
}
extern "C" {
    #[doc = " Adjust the bufferSizeInFrames to optimize latency.\n It will start with a low latency and then raise it if an underrun occurs.\n\n Latency tuning is only supported for AAudio.\n\n @return OK or negative error, ErrorUnimplemented for OpenSL ES"]
    #[link_name = "\u{1}_ZN4oboe12LatencyTuner4tuneEv"]
    pub fn oboe_LatencyTuner_tune(this: *mut oboe_LatencyTuner) -> oboe_Result;
}
extern "C" {
    #[doc = " This may be called from another thread. Then tune() will call reset(),\n which will lower the latency to the minimum and then allow it to rise back up\n if there are glitches.\n\n This is typically called in response to a user decision to minimize latency. In other words,\n call this from a button handler."]
    #[link_name = "\u{1}_ZN4oboe12LatencyTuner12requestResetEv"]
    pub fn oboe_LatencyTuner_requestReset(this: *mut oboe_LatencyTuner);
}
extern "C" {
    #[doc = " @return true if the audio stream's buffer size is at the maximum value. If no maximum value\n was specified when constructing the LatencyTuner then the value of\n stream->getBufferCapacityInFrames is used"]
    #[link_name = "\u{1}_ZN4oboe12LatencyTuner21isAtMaximumBufferSizeEv"]
    pub fn oboe_LatencyTuner_isAtMaximumBufferSize(this: *mut oboe_LatencyTuner) -> bool;
}
extern "C" {
    #[doc = " Construct a new LatencyTuner object which will act on the given audio stream\n\n @param stream the stream who's latency will be tuned"]
    #[link_name = "\u{1}_ZN4oboe12LatencyTunerC1ERNS_11AudioStreamE"]
    pub fn oboe_LatencyTuner_LatencyTuner(
        this: *mut oboe_LatencyTuner,
        stream: *mut oboe_AudioStream,
    );
}
extern "C" {
    #[doc = " Construct a new LatencyTuner object which will act on the given audio stream.\n\n @param stream the stream who's latency will be tuned\n @param the maximum buffer size which the tune() operation will set the buffer size to"]
    #[link_name = "\u{1}_ZN4oboe12LatencyTunerC1ERNS_11AudioStreamEi"]
    pub fn oboe_LatencyTuner_LatencyTuner1(
        this: *mut oboe_LatencyTuner,
        stream: *mut oboe_AudioStream,
        maximumBufferSize: i32,
    );
}
impl oboe_LatencyTuner {
    #[inline]
    pub unsafe fn tune(&mut self) -> oboe_Result {
        oboe_LatencyTuner_tune(self)
    }
    #[inline]
    pub unsafe fn requestReset(&mut self) {
        oboe_LatencyTuner_requestReset(self)
    }
    #[inline]
    pub unsafe fn isAtMaximumBufferSize(&mut self) -> bool {
        oboe_LatencyTuner_isAtMaximumBufferSize(self)
    }
    #[inline]
    pub unsafe fn new(stream: *mut oboe_AudioStream) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        oboe_LatencyTuner_LatencyTuner(__bindgen_tmp.as_mut_ptr(), stream);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(stream: *mut oboe_AudioStream, maximumBufferSize: i32) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        oboe_LatencyTuner_LatencyTuner1(__bindgen_tmp.as_mut_ptr(), stream, maximumBufferSize);
        __bindgen_tmp.assume_init()
    }
}
pub const oboe_LatencyTuner_kIdleCount: i32 = 8;
pub const oboe_LatencyTuner_kDefaultNumBursts: i32 = 2;
#[doc = " Oboe versioning object"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct oboe_Version {
    pub _address: u8,
}
#[doc = " This is incremented when we make breaking API changes. Based loosely on https://semver.org/."]
pub const oboe_Version_Major: u8 = 1;
#[doc = " This is incremented when we add backwards compatible functionality. Or set to zero when MAJOR is\n incremented."]
pub const oboe_Version_Minor: u8 = 8;
#[doc = " This is incremented when we make backwards compatible bug fixes. Or set to zero when MINOR is\n incremented."]
pub const oboe_Version_Patch: u16 = 1;
#[doc = " Version string in the form MAJOR.MINOR.PATCH."]
pub const oboe_Version_Text: &[u8; 6] = b"1.8.1\0";
#[doc = " Integer representation of the current Oboe library version. This will always increase when the\n version number changes so can be compared using integer comparison."]
pub const oboe_Version_Number: u32 = 17301505;
#[test]
fn bindgen_test_layout_oboe_Version() {
    assert_eq!(
        ::std::mem::size_of::<oboe_Version>(),
        1usize,
        concat!("Size of: ", stringify!(oboe_Version))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_Version>(),
        1usize,
        concat!("Alignment of ", stringify!(oboe_Version))
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct oboe_StabilizedCallback {
    pub _base: oboe_AudioStreamCallback,
    pub mCallback: *mut oboe_AudioStreamCallback,
    pub mFrameCount: i64,
    pub mEpochTimeNanos: i64,
    pub mOpsPerNano: f64,
}
#[test]
fn bindgen_test_layout_oboe_StabilizedCallback() {
    const UNINIT: ::std::mem::MaybeUninit<oboe_StabilizedCallback> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<oboe_StabilizedCallback>(),
        40usize,
        concat!("Size of: ", stringify!(oboe_StabilizedCallback))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_StabilizedCallback>(),
        8usize,
        concat!("Alignment of ", stringify!(oboe_StabilizedCallback))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mCallback) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_StabilizedCallback),
            "::",
            stringify!(mCallback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mFrameCount) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_StabilizedCallback),
            "::",
            stringify!(mFrameCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mEpochTimeNanos) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_StabilizedCallback),
            "::",
            stringify!(mEpochTimeNanos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mOpsPerNano) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_StabilizedCallback),
            "::",
            stringify!(mOpsPerNano)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe18StabilizedCallbackC1EPNS_19AudioStreamCallbackE"]
    pub fn oboe_StabilizedCallback_StabilizedCallback(
        this: *mut oboe_StabilizedCallback,
        callback: *mut oboe_AudioStreamCallback,
    );
}
impl oboe_StabilizedCallback {
    #[inline]
    pub unsafe fn new(callback: *mut oboe_AudioStreamCallback) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        oboe_StabilizedCallback_StabilizedCallback(__bindgen_tmp.as_mut_ptr(), callback);
        __bindgen_tmp.assume_init()
    }
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe18StabilizedCallback12onAudioReadyEPNS_11AudioStreamEPvi"]
    pub fn oboe_StabilizedCallback_onAudioReady(
        this: *mut ::std::os::raw::c_void,
        oboeStream: *mut oboe_AudioStream,
        audioData: *mut ::std::os::raw::c_void,
        numFrames: i32,
    ) -> oboe_DataCallbackResult;
}
pub type oboe_AudioStreamShared = [u32; 2usize];
pub type oboe_DropContextHandler =
    ::std::option::Option<unsafe extern "C" fn(context: *mut ::std::os::raw::c_void)>;
pub type oboe_AudioReadyHandler = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut ::std::os::raw::c_void,
        oboeStream: *mut oboe_AudioStream,
        audioData: *mut ::std::os::raw::c_void,
        numFrames: i32,
    ) -> oboe_DataCallbackResult,
>;
pub type oboe_ErrorCloseHandler = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut ::std::os::raw::c_void,
        oboeStream: *mut oboe_AudioStream,
        error: oboe_Result,
    ),
>;
#[repr(C)]
#[derive(Debug)]
pub struct oboe_AudioStreamCallbackWrapper {
    pub _base: oboe_AudioStreamDataCallback,
    pub _base_1: oboe_AudioStreamErrorCallback,
    pub _context: *mut ::std::os::raw::c_void,
    pub _drop_context: oboe_DropContextHandler,
    pub _audio_ready: oboe_AudioReadyHandler,
    pub _before_close: oboe_ErrorCloseHandler,
    pub _after_close: oboe_ErrorCloseHandler,
}
#[test]
fn bindgen_test_layout_oboe_AudioStreamCallbackWrapper() {
    const UNINIT: ::std::mem::MaybeUninit<oboe_AudioStreamCallbackWrapper> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<oboe_AudioStreamCallbackWrapper>(),
        28usize,
        concat!("Size of: ", stringify!(oboe_AudioStreamCallbackWrapper))
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_AudioStreamCallbackWrapper>(),
        4usize,
        concat!("Alignment of ", stringify!(oboe_AudioStreamCallbackWrapper))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._context) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamCallbackWrapper),
            "::",
            stringify!(_context)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._drop_context) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamCallbackWrapper),
            "::",
            stringify!(_drop_context)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._audio_ready) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamCallbackWrapper),
            "::",
            stringify!(_audio_ready)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._before_close) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamCallbackWrapper),
            "::",
            stringify!(_before_close)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._after_close) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(oboe_AudioStreamCallbackWrapper),
            "::",
            stringify!(_after_close)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe26AudioStreamCallbackWrapperC1EPvPFvS1_EPFNS_18DataCallbackResultES1_PNS_11AudioStreamES1_iEPFvS1_S6_NS_6ResultEESB_"]
    pub fn oboe_AudioStreamCallbackWrapper_AudioStreamCallbackWrapper(
        this: *mut oboe_AudioStreamCallbackWrapper,
        context: *mut ::std::os::raw::c_void,
        drop_context: oboe_DropContextHandler,
        audio_ready: oboe_AudioReadyHandler,
        before_close: oboe_ErrorCloseHandler,
        after_close: oboe_ErrorCloseHandler,
    );
}
impl oboe_AudioStreamCallbackWrapper {
    #[inline]
    pub unsafe fn new(
        context: *mut ::std::os::raw::c_void,
        drop_context: oboe_DropContextHandler,
        audio_ready: oboe_AudioReadyHandler,
        before_close: oboe_ErrorCloseHandler,
        after_close: oboe_ErrorCloseHandler,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        oboe_AudioStreamCallbackWrapper_AudioStreamCallbackWrapper(
            __bindgen_tmp.as_mut_ptr(),
            context,
            drop_context,
            audio_ready,
            before_close,
            after_close,
        );
        __bindgen_tmp.assume_init()
    }
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe26AudioStreamCallbackWrapperD1Ev"]
    pub fn oboe_AudioStreamCallbackWrapper_AudioStreamCallbackWrapper_destructor(
        this: *mut oboe_AudioStreamCallbackWrapper,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe26AudioStreamCallbackWrapper12onAudioReadyEPNS_11AudioStreamEPvi"]
    pub fn oboe_AudioStreamCallbackWrapper_onAudioReady(
        this: *mut ::std::os::raw::c_void,
        oboeStream: *mut oboe_AudioStream,
        audioData: *mut ::std::os::raw::c_void,
        numFrames: i32,
    ) -> oboe_DataCallbackResult;
}
extern "C" {
    #[link_name = "\u{1}_ZThn4_N4oboe26AudioStreamCallbackWrapper18onErrorBeforeCloseEPNS_11AudioStreamENS_6ResultE"]
    pub fn oboe_AudioStreamCallbackWrapper_onErrorBeforeClose(
        this: *mut ::std::os::raw::c_void,
        oboeStream: *mut oboe_AudioStream,
        error: oboe_Result,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZThn4_N4oboe26AudioStreamCallbackWrapper17onErrorAfterCloseEPNS_11AudioStreamENS_6ResultE"]
    pub fn oboe_AudioStreamCallbackWrapper_onErrorAfterClose(
        this: *mut ::std::os::raw::c_void,
        oboeStream: *mut oboe_AudioStream,
        error: oboe_Result,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe25AudioStreamBuilder_createEPNS_18AudioStreamBuilderE"]
    pub fn oboe_AudioStreamBuilder_create(builder: *mut oboe_AudioStreamBuilder);
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe25AudioStreamBuilder_deleteEPNS_18AudioStreamBuilderE"]
    pub fn oboe_AudioStreamBuilder_delete(builder: *mut oboe_AudioStreamBuilder);
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe30AudioStreamBuilder_setCallbackEPNS_18AudioStreamBuilderEPvPFvS2_EPFNS_18DataCallbackResultES2_PNS_11AudioStreamES2_iEPFvS2_S7_NS_6ResultEESC_"]
    pub fn oboe_AudioStreamBuilder_setCallback(
        builder: *mut oboe_AudioStreamBuilder,
        context: *mut ::std::os::raw::c_void,
        drop_context: oboe_DropContextHandler,
        audio_ready: oboe_AudioReadyHandler,
        before_close: oboe_ErrorCloseHandler,
        after_close: oboe_ErrorCloseHandler,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe30AudioStreamBuilder_getAudioApiEPKNS_18AudioStreamBuilderE"]
    pub fn oboe_AudioStreamBuilder_getAudioApi(
        builder: *const oboe_AudioStreamBuilder,
    ) -> oboe_AudioApi;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe30AudioStreamBuilder_setAudioApiEPNS_18AudioStreamBuilderENS_8AudioApiE"]
    pub fn oboe_AudioStreamBuilder_setAudioApi(
        builder: *mut oboe_AudioStreamBuilder,
        api: oboe_AudioApi,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe26AudioStreamBuilder_getBaseEPNS_18AudioStreamBuilderE"]
    pub fn oboe_AudioStreamBuilder_getBase(
        builder: *mut oboe_AudioStreamBuilder,
    ) -> *mut oboe_AudioStreamBase;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe35AudioStreamBuilder_openStreamSharedEPNS_18AudioStreamBuilderEPNSt6__ndk110shared_ptrINS_11AudioStreamEEE"]
    pub fn oboe_AudioStreamBuilder_openStreamShared(
        builder: *mut oboe_AudioStreamBuilder,
        sharedStream: *mut oboe_AudioStreamShared,
    ) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe23AudioStreamShared_cloneEPKNSt6__ndk110shared_ptrINS_11AudioStreamEEEPS3_"]
    pub fn oboe_AudioStreamShared_clone(
        sharedStream: *const oboe_AudioStreamShared,
        newSharedStream: *mut oboe_AudioStreamShared,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe24AudioStreamShared_deleteEPNSt6__ndk110shared_ptrINS_11AudioStreamEEE"]
    pub fn oboe_AudioStreamShared_delete(sharedStream: *mut oboe_AudioStreamShared);
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe23AudioStreamShared_derefEPNSt6__ndk110shared_ptrINS_11AudioStreamEEE"]
    pub fn oboe_AudioStreamShared_deref(
        sharedStream: *mut oboe_AudioStreamShared,
    ) -> *mut oboe_AudioStream;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe16AudioStream_openEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_open(oboeStream: *mut oboe_AudioStream) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe17AudioStream_closeEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_close1(oboeStream: *mut oboe_AudioStream) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe24AudioStream_requestStartEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_requestStart(oboeStream: *mut oboe_AudioStream) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe24AudioStream_requestPauseEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_requestPause(oboeStream: *mut oboe_AudioStream) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe24AudioStream_requestFlushEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_requestFlush(oboeStream: *mut oboe_AudioStream) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe23AudioStream_requestStopEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_requestStop(oboeStream: *mut oboe_AudioStream) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe20AudioStream_getStateEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_getState(oboeStream: *mut oboe_AudioStream) -> oboe_StreamState;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe30AudioStream_waitForStateChangeEPNS_11AudioStreamENS_11StreamStateEPS2_x"]
    pub fn oboe_AudioStream_waitForStateChange(
        oboeStream: *mut oboe_AudioStream,
        inputState: oboe_StreamState,
        nextState: *mut oboe_StreamState,
        timeoutNanoseconds: i64,
    ) -> oboe_Result;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe33AudioStream_setBufferSizeInFramesEPNS_11AudioStreamEi"]
    pub fn oboe_AudioStream_setBufferSizeInFrames(
        oboeStream: *mut oboe_AudioStream,
        requestedFrames: i32,
    ) -> oboe_ResultWithValue<i32>;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe24AudioStream_getXRunCountEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_getXRunCount(
        oboeStream: *mut oboe_AudioStream,
    ) -> oboe_ResultWithValue<i32>;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe32AudioStream_isXRunCountSupportedEPKNS_11AudioStreamE"]
    pub fn oboe_AudioStream_isXRunCountSupported(oboeStream: *const oboe_AudioStream) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe29AudioStream_getFramesPerBurstEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_getFramesPerBurst(oboeStream: *mut oboe_AudioStream) -> i32;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe34AudioStream_calculateLatencyMillisEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_calculateLatencyMillis(
        oboeStream: *mut oboe_AudioStream,
    ) -> oboe_ResultWithValue<f64>;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe23AudioStream_getAudioApiEPKNS_11AudioStreamE"]
    pub fn oboe_AudioStream_getAudioApi(oboeStream: *const oboe_AudioStream) -> oboe_AudioApi;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe16AudioStream_readEPNS_11AudioStreamEPvix"]
    pub fn oboe_AudioStream_read(
        oboeStream: *mut oboe_AudioStream,
        buffer: *mut ::std::os::raw::c_void,
        numFrames: i32,
        timeoutNanoseconds: i64,
    ) -> oboe_ResultWithValue<i32>;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe17AudioStream_writeEPNS_11AudioStreamEPKvix"]
    pub fn oboe_AudioStream_write(
        oboeStream: *mut oboe_AudioStream,
        buffer: *const ::std::os::raw::c_void,
        numFrames: i32,
        timeoutNanoseconds: i64,
    ) -> oboe_ResultWithValue<i32>;
}
extern "C" {
    #[link_name = "\u{1}_ZN4oboe19AudioStream_getBaseEPNS_11AudioStreamE"]
    pub fn oboe_AudioStream_getBase(oboeStream: *mut oboe_AudioStream)
        -> *mut oboe_AudioStreamBase;
}
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __clockid_t = __kernel_clockid_t;
pub type clockid_t = __clockid_t;
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_int32_t_close0_instantiation() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<i32>>(),
        8usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<i32>>(),
        4usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
}
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_int32_t_close0_instantiation_1() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<i32>>(),
        8usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<i32>>(),
        4usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
}
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_int32_t_close0_instantiation_2() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<i32>>(),
        8usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<i32>>(),
        4usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
}
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_int32_t_close0_instantiation_3() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<i32>>(),
        8usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<i32>>(),
        4usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
}
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_double_close0_instantiation() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<f64>>(),
        16usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<f64>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<f64>>(),
        8usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<f64>)
        )
    );
}
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_int32_t_close0_instantiation_4() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<i32>>(),
        8usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<i32>>(),
        4usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
}
#[test]
fn __bindgen_test_layout_oboe_ResultWithValue_open0_int32_t_close0_instantiation_5() {
    assert_eq!(
        ::std::mem::size_of::<oboe_ResultWithValue<i32>>(),
        8usize,
        concat!(
            "Size of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<oboe_ResultWithValue<i32>>(),
        4usize,
        concat!(
            "Alignment of template specialization: ",
            stringify!(oboe_ResultWithValue<i32>)
        )
    );
}
