/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.registry.AbstractReplaceableDescriptor;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractReplaceableRegistry<T, D extends AbstractReplaceableDescriptor<T>> {
    private final Map<String, D> descriptors = new LinkedHashMap<String, D>();
    private final Map<String, String> replaces = new LinkedHashMap<String, String>();

    protected AbstractReplaceableRegistry(IExtensionRegistry registry, String extensionPoint, String elementName) {
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(extensionPoint);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (elementName.equals(el.getName())) {
                D descriptor = this.createDescriptor(el);
                this.descriptors.put(((AbstractReplaceableDescriptor)((Object)descriptor)).getId(), descriptor);
                String rep = ((AbstractReplaceableDescriptor)((Object)descriptor)).getReplaces();
                if (!CommonUtils.isEmpty((String)rep)) {
                    String[] stringArray = rep.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id = stringArray[n4];
                        this.replaces.put(id.trim(), ((AbstractReplaceableDescriptor)((Object)descriptor)).getId());
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    protected abstract D createDescriptor(IConfigurationElement var1);

    public T get(String id) throws DBException {
        while (this.replaces.containsKey(id)) {
            id = this.replaces.get(id);
        }
        AbstractReplaceableDescriptor descriptor = (AbstractReplaceableDescriptor)((Object)this.descriptors.get(id));
        if (descriptor == null) {
            throw new DBException("Registry element '" + id + "' not found in " + this.getClass().getSimpleName());
        }
        return descriptor.createInstance();
    }
}

