/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIDdlGenerationOptions;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.registry.AISchemaGeneratorRegistry;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;

public class AIDatabaseSnapshotService {
    private static final Log LOG = Log.getLog(AIDatabaseSnapshotService.class);
    @NotNull
    private final AISchemaGeneratorRegistry generatorRegistry;

    public AIDatabaseSnapshotService(@NotNull AISchemaGeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @NotNull
    public String createDbSnapshot(@NotNull DBRProgressMonitor monitor, @Nullable AIDatabaseContext aiDatabaseContext, @NotNull AIDdlGenerationOptions options) throws DBException {
        if (aiDatabaseContext == null) {
            return "";
        }
        Objects.requireNonNull(aiDatabaseContext.getScopeObject(), "Scope object is null");
        Objects.requireNonNull(aiDatabaseContext.getExecutionContext(), "Execution context is null");
        TokenBoundedStringBuilder prompt = new TokenBoundedStringBuilder(options.maxRequestTokens());
        if (this.appendContext(monitor, aiDatabaseContext, options, prompt, true)) {
            return prompt.toString();
        }
        AIDdlGenerationOptions fallback = AIDatabaseSnapshotService.buildFallbackOptions(options);
        if (options.equals(fallback)) {
            return prompt.toString();
        }
        LOG.warn((Object)"Context description is too long, generating partial description");
        TokenBoundedStringBuilder partialPrompt = new TokenBoundedStringBuilder(options.maxRequestTokens());
        this.appendContext(monitor, aiDatabaseContext, fallback, partialPrompt, false);
        return partialPrompt.toString();
    }

    private boolean appendContext(@NotNull DBRProgressMonitor monitor, @NotNull AIDatabaseContext ctx, @NotNull AIDdlGenerationOptions options, @NotNull TokenBoundedStringBuilder out, boolean refreshCache) throws DBException {
        if (ctx.getScope() == AIDatabaseScope.CUSTOM) {
            List<DBSObject> entities = AIDatabaseSnapshotService.normalizeCustomEntities(ctx.getCustomEntities());
            if (refreshCache) {
                AIDatabaseSnapshotService.cacheStructuresIfNeeded(monitor, entities);
            }
            for (DBSObject entity : entities) {
                if (this.appendObjectDescription(monitor, out, entity, ctx.getExecutionContext(), options, AIDatabaseSnapshotService.requiresFqn(entity, ctx.getExecutionContext()), refreshCache)) continue;
                return false;
            }
            return true;
        }
        return this.appendObjectDescription(monitor, out, (DBSObject)ctx.getScopeObject(), ctx.getExecutionContext(), options, false, refreshCache);
    }

    private boolean appendObjectDescription(@NotNull DBRProgressMonitor monitor, @NotNull TokenBoundedStringBuilder out, @NotNull DBSObject obj, @Nullable DBCExecutionContext execCtx, @NotNull AIDdlGenerationOptions options, boolean useFqn, boolean refreshCache) throws DBException {
        if (AIDatabaseSnapshotService.shouldSkipObject(monitor, obj)) {
            return true;
        }
        if (obj instanceof DBSEntity) {
            DBSEntity entity = (DBSEntity)obj;
            String ddl = this.generatorRegistry.getDdlGenerator().generateSchema(monitor, entity, execCtx, options, useFqn) + "\n";
            return out.append(ddl);
        }
        if (obj instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)obj;
            return this.appendContainerDDL(monitor, out, container, execCtx, options, refreshCache);
        }
        return true;
    }

    private boolean appendContainerDDL(@NotNull DBRProgressMonitor monitor, @NotNull TokenBoundedStringBuilder out, @NotNull DBSObjectContainer container, @Nullable DBCExecutionContext execCtx, @NotNull AIDdlGenerationOptions options, boolean refreshCache) throws DBException {
        if (refreshCache) {
            container.cacheStructure(monitor, 3);
        }
        for (DBSObject child : container.getChildren(monitor)) {
            if (AIDatabaseSnapshotService.shouldSkipObject(monitor, child) || this.appendObjectDescription(monitor, out, child, execCtx, options, AIDatabaseSnapshotService.requiresFqn(child, execCtx), refreshCache)) continue;
            LOG.warn((Object)("Object description is too long, truncated at: " + child.getName()));
            return false;
        }
        return true;
    }

    private static boolean shouldSkipObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject obj) {
        return DBUtils.isSystemObject((Object)obj) || DBUtils.isHiddenObject((Object)obj) || obj instanceof DBSTablePartition || DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)obj, (boolean)false) == null;
    }

    private static boolean requiresFqn(@NotNull DBSObject obj, @Nullable DBCExecutionContext ctx) {
        if (ctx == null || ctx.getContextDefaults() == null) {
            return false;
        }
        DBSObject parent = obj.getParentObject();
        DBCExecutionContextDefaults def = ctx.getContextDefaults();
        return parent != null && !parent.equals(def.getDefaultCatalog()) && !parent.equals(def.getDefaultSchema());
    }

    private static AIDdlGenerationOptions buildFallbackOptions(AIDdlGenerationOptions original) {
        return original.toBuilder().withSendObjectComment(false).withSendColumnTypes(false).withSendForeignKeys(false).withSendConstraints(false).withSendSampleData(false).build();
    }

    @NotNull
    private static List<DBSObject> normalizeCustomEntities(@NotNull List<DBSObject> entities) {
        HashSet<DBSObject> unique = new HashSet<DBSObject>(entities);
        return unique.stream().filter(o -> Stream.iterate(o.getParentObject(), Objects::nonNull, DBSObject::getParentObject).noneMatch(unique::contains)).sorted(Comparator.comparing(DBPNamedObject::getName, String.CASE_INSENSITIVE_ORDER)).toList();
    }

    private static void cacheStructuresIfNeeded(@NotNull DBRProgressMonitor monitor, @NotNull List<DBSObject> entities) {
        entities.stream().filter(DBSEntity.class::isInstance).map(o -> (DBSObjectContainer)o.getParentObject()).collect(Collectors.groupingBy(c -> c, Collectors.counting())).forEach((container, count) -> {
            if (count > 1L) {
                try {
                    container.cacheStructure(monitor, 3);
                }
                catch (DBException e) {
                    LOG.error((Object)("Failed to cache structure for " + container.getName()), (Throwable)e);
                }
            }
        });
    }

    private static final class TokenBoundedStringBuilder {
        private static final int SAFE_MARGIN_TOKENS = 20;
        private final StringBuilder sb = new StringBuilder();
        private final int maxChars;

        TokenBoundedStringBuilder(int maxTokens) {
            this.maxChars = (maxTokens - 20) * 2;
        }

        boolean append(@NotNull CharSequence chunk) {
            if (this.sb.length() + chunk.length() > this.maxChars) {
                return false;
            }
            this.sb.append(chunk);
            return true;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

