/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.commands;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.ai.AIBaseFeatures;
import org.jkiss.dbeaver.model.ai.AICommandRequest;
import org.jkiss.dbeaver.model.ai.AICommandResult;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SQLCommandAI
implements SQLControlCommandHandler {
    private static final DBCOutputSeverity AI_OUTPUT_SEVERITY = new DBCOutputSeverity(){

        @NotNull
        public String getName() {
            return "AI";
        }

        public boolean isForced() {
            return true;
        }
    };

    @NotNull
    public SQLControlResult handleCommand(@NotNull DBRProgressMonitor monitor, @NotNull SQLControlCommand command, @NotNull SQLScriptContext scriptContext) throws DBException {
        DBPDataSource dataSource = command.getDataSource();
        if (dataSource == null) {
            throw new DBException("Not connected to database");
        }
        String prompt = command.getParameter();
        if (CommonUtils.isEmptyTrimmed((String)prompt)) {
            throw new DBException("Empty AI prompt");
        }
        AIBaseFeatures.SQL_AI_COMMAND.use();
        DBSLogicalDataSource lDataSource = new DBSLogicalDataSource(command.getDataSourceContainer(), "AI logical wrapper", null);
        DBPDataSourceContainer dataSourceContainer = lDataSource.getDataSourceContainer();
        AICompletionSettings completionSettings = new AICompletionSettings(dataSourceContainer);
        if (!DBWorkbench.getPlatform().getApplication().isHeadlessMode() && !completionSettings.isMetaTransferConfirmed()) {
            if (DBWorkbench.getPlatformUI().confirmAction("Do you confirm AI usage", "Do you confirm AI usage for '" + dataSourceContainer.getName() + "'?")) {
                completionSettings.setMetaTransferConfirmed(true);
                completionSettings.saveSettings();
            } else {
                throw new DBException("AI services restricted for '" + dataSourceContainer.getName() + "'");
            }
        }
        AIDatabaseScope scope = completionSettings.getScope();
        AIDatabaseContext.Builder contextBuilder = new AIDatabaseContext.Builder(lDataSource).setScope(scope);
        DBCExecutionContext executionContext = scriptContext.getExecutionContext();
        if (executionContext != null) {
            contextBuilder.setExecutionContext(executionContext);
        }
        if (scope == AIDatabaseScope.CUSTOM) {
            contextBuilder.setCustomEntities(AITextUtils.loadCustomEntities(monitor, dataSource, Arrays.stream(completionSettings.getCustomObjectIds()).collect(Collectors.toSet())));
        }
        AIDatabaseContext aiContext = contextBuilder.build();
        AICommandResult result = AIAssistantRegistry.getInstance().createAssistant(dataSourceContainer.getProject().getWorkspace()).command(monitor, new AICommandRequest(prompt, aiContext));
        if (result.sql() == null) {
            if (!CommonUtils.isEmpty((String)result.message())) {
                throw new DBException(result.message());
            }
            throw new DBException("Empty AI response for '" + prompt + "'");
        }
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)dataSource);
        if (!result.sql().contains("\n") && SQLUtils.isCommentLine((SQLDialect)dialect, (String)result.sql())) {
            throw new DBException(result.sql());
        }
        scriptContext.getOutputWriter().println(AI_OUTPUT_SEVERITY, prompt + " ==> " + result.sql() + "\n");
        return SQLControlResult.transform((SQLScriptElement)new SQLQuery(dataSource, result.sql()));
    }
}

