/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryExpressionMapper;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTupleRefEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;

public class SQLQueryRowsProjectionModel
extends SQLQueryRowsSourceModel {
    private static final Log log = Log.getLog(SQLQueryRowsProjectionModel.class);
    @NotNull
    private final SQLQueryLexicalScope selectListScope;
    @NotNull
    private final SQLQueryRowsSourceModel fromSource;
    @NotNull
    private final SQLQuerySelectionResultModel result;
    @NotNull
    private final FiltersData<SQLQueryValueExpression> filterExprs;
    @NotNull
    private final FiltersData<SQLQueryLexicalScope> filterScopes;
    @Nullable
    private final SQLQueryLexicalScope fromScope;
    @Nullable
    private final SQLQueryLexicalScope tailScope;

    public SQLQueryRowsProjectionModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryLexicalScope selectListScope, @NotNull SQLQueryRowsSourceModel fromSource, @Nullable SQLQueryLexicalScope fromScope, @NotNull FiltersData<SQLQueryValueExpression> filterExprs, @NotNull FiltersData<SQLQueryLexicalScope> filterScopes, @NotNull SQLQuerySelectionResultModel result, @Nullable SQLQueryLexicalScope tailScope) {
        super(syntaxNode, fromSource, result, (SQLQueryNodeModel)filterExprs.whereClause, (SQLQueryNodeModel)filterExprs.havingClause, (SQLQueryNodeModel)filterExprs.groupByClause, (SQLQueryNodeModel)filterExprs.orderByClause);
        this.result = result;
        this.selectListScope = selectListScope;
        this.fromSource = fromSource;
        this.filterExprs = filterExprs;
        this.filterScopes = filterScopes;
        this.registerLexicalScope(selectListScope);
        if (fromScope != null) {
            this.registerLexicalScope(fromScope);
        }
        Stream.of((SQLQueryLexicalScope)filterScopes.whereClause, (SQLQueryLexicalScope)filterScopes.havingClause, (SQLQueryLexicalScope)filterScopes.groupByClause, (SQLQueryLexicalScope)filterScopes.orderByClause).filter(Objects::nonNull).forEach(this::registerLexicalScope);
        this.fromScope = fromScope;
        this.tailScope = tailScope;
    }

    @NotNull
    public SQLQueryRowsSourceModel getFromSource() {
        return this.fromSource;
    }

    @NotNull
    public SQLQuerySelectionResultModel getResult() {
        return this.result;
    }

    @Nullable
    public SQLQueryValueExpression getWhereClause() {
        return (SQLQueryValueExpression)this.filterExprs.whereClause;
    }

    @Nullable
    public SQLQueryValueExpression getHavingClause() {
        return (SQLQueryValueExpression)this.filterExprs.havingClause;
    }

    @Nullable
    public SQLQueryValueExpression getGroupByClause() {
        return (SQLQueryValueExpression)this.filterExprs.groupByClause;
    }

    @Nullable
    public SQLQueryValueExpression getOrderByClause() {
        return (SQLQueryValueExpression)this.filterExprs.orderByClause;
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.fromScope != null) {
            this.fromScope.setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsSourceRef(context));
        }
        SQLQueryRowsSourceContext resolvedContext = this.fromSource.resolveRowSources(context, statistics).setCteSourcesFrom(context);
        if (this.filterExprs.whereClause != null) {
            ((SQLQueryValueExpression)this.filterExprs.whereClause).resolveRowSources(resolvedContext, statistics);
        }
        if (this.filterExprs.havingClause != null) {
            ((SQLQueryValueExpression)this.filterExprs.havingClause).resolveRowSources(resolvedContext, statistics);
        }
        if (this.filterExprs.groupByClause != null) {
            ((SQLQueryValueExpression)this.filterExprs.groupByClause).resolveRowSources(resolvedContext, statistics);
        }
        if (this.filterExprs.orderByClause != null) {
            ((SQLQueryValueExpression)this.filterExprs.orderByClause).resolveRowSources(resolvedContext, statistics);
        }
        return resolvedContext.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsDataContext clauseCtx;
        SQLQueryRowsDataContext unresolvedResult = context.combine(this.fromSource.getRowsDataContext());
        this.selectListScope.setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsDataRef(unresolvedResult));
        EnumSet aliasVisibilities = this.getRowsSources().getDialect().getProjectionAliasVisibilityScope();
        List<SQLQueryResultColumn> resultColumns = this.result.expandColumns(unresolvedResult, this, statistics);
        List<SQLQueryResultPseudoColumn> resultPseudoColumns = unresolvedResult.getPseudoColumnsList().stream().filter(s -> s.propagationPolicy.projected).toList();
        SQLQueryRowsDataContext resolvedResult = this.getRowsSources().makeTuple(this, resultColumns, resultPseudoColumns);
        SQLQueryRowsDataContext filtersContext = unresolvedResult.combine(resolvedResult);
        if (this.filterExprs.whereClause != null) {
            clauseCtx = aliasVisibilities.contains(SQLDialect.ProjectionAliasVisibilityScope.WHERE) ? filtersContext : unresolvedResult;
            ((SQLQueryValueExpression)this.filterExprs.whereClause).resolveValueRelations(clauseCtx, statistics);
            ((SQLQueryLexicalScope)this.filterScopes.whereClause).setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsDataRef(clauseCtx));
        }
        if (this.filterExprs.havingClause != null) {
            clauseCtx = aliasVisibilities.contains(SQLDialect.ProjectionAliasVisibilityScope.HAVING) ? filtersContext : unresolvedResult;
            ((SQLQueryValueExpression)this.filterExprs.havingClause).resolveValueRelations(clauseCtx, statistics);
            ((SQLQueryLexicalScope)this.filterScopes.havingClause).setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsDataRef(clauseCtx));
        }
        if (this.filterExprs.groupByClause != null) {
            clauseCtx = aliasVisibilities.contains(SQLDialect.ProjectionAliasVisibilityScope.GROUP_BY) ? filtersContext : unresolvedResult;
            ((SQLQueryValueExpression)this.filterExprs.groupByClause).resolveValueRelations(clauseCtx, statistics);
            ((SQLQueryLexicalScope)this.filterScopes.groupByClause).setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsDataRef(clauseCtx));
        }
        if (this.filterExprs.orderByClause != null) {
            clauseCtx = aliasVisibilities.contains(SQLDialect.ProjectionAliasVisibilityScope.ORDER_BY) ? filtersContext : unresolvedResult;
            ((SQLQueryValueExpression)this.filterExprs.orderByClause).resolveValueRelations(clauseCtx, statistics);
            ((SQLQueryLexicalScope)this.filterScopes.orderByClause).setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsDataRef(clauseCtx));
        }
        if (this.tailScope != null) {
            this.setTailOrigin(this.tailScope.getSymbolsOrigin());
        }
        return resolvedResult;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsProjection(this, arg);
    }

    public static SQLQueryRowsSourceModel recognize(@NotNull STMTreeNode n, @NotNull List<SQLQueryRowsSourceModel> sourceModels, @NotNull SQLQueryModelRecognizer recognizer) {
        return SQLQueryRowsProjectionModel.recognize(n, sourceModels, recognizer, SQLQueryRowsProjectionModel::new);
    }

    @NotNull
    public static SQLQueryRowsSourceModel recognize(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQueryRowsSourceModel> sourceModels, @NotNull SQLQueryModelRecognizer recognizer, @NotNull ProjectionModelCtor ctor) {
        SQLQueryRowsSourceModel projectionModel;
        STMTreeNode selectKeywordNode;
        SQLQueryLexicalScope selectListScope;
        STMTreeNode selectListNode = syntaxNode.findFirstChildOfName(STMKnownRuleNames.selectList);
        if (selectListNode == null) {
            log.debug((Object)"Invalid querySpecification: missing selectList");
            return SQLQueryExpressionMapper.makeEmptyRowsModel(syntaxNode);
        }
        List selectSublists = selectListNode.findChildrenOfName(STMKnownRuleNames.selectSublist);
        SQLQuerySelectionResultModel resultModel = new SQLQuerySelectionResultModel(selectListNode, selectSublists.size());
        Throwable throwable = null;
        Object var10_9 = null;
        try (SQLQueryModelRecognizer.LexicalScopeHolder selectListScopeHolder = recognizer.openScope();){
            selectListScope = selectListScopeHolder.lexicalScope;
            selectKeywordNode = syntaxNode.findFirstChildOfName(STMKnownRuleNames.SELECT_TERM);
            if (selectKeywordNode == null) {
                log.debug((Object)"SELECT keyword is missing in projection model");
                return SQLQueryExpressionMapper.makeEmptyRowsModel(syntaxNode);
            }
            block15: for (STMTreeNode selectSublist : selectSublists) {
                STMTreeNode sublistNode = selectSublist.findFirstNonErrorChild();
                if (sublistNode == null) continue;
                switch (sublistNode.getNodeKindId()) {
                    case 113: {
                        SQLQueryValueExpression expr;
                        STMTreeNode exprNode = sublistNode.findFirstChildOfName(STMKnownRuleNames.valueExpression);
                        SQLQueryValueExpression sQLQueryValueExpression = expr = exprNode == null ? null : recognizer.collectValueExpression(exprNode, selectListScope);
                        if (expr instanceof SQLQueryValueTupleReferenceExpression) {
                            SQLQueryValueTupleReferenceExpression tupleRef = (SQLQueryValueTupleReferenceExpression)expr;
                            if (tupleRef.getTupleRefEntry() != null) {
                                recognizer.registerScopeItem(tupleRef.getTupleRefEntry());
                            }
                            resultModel.addTupleSpec(sublistNode, tupleRef);
                            break;
                        }
                        STMTreeNode asClauseNode = sublistNode.findLastChildOfName(STMKnownRuleNames.asClause);
                        if (asClauseNode != null) {
                            STMTreeNode columnNameNode = asClauseNode.findLastChildOfName(STMKnownRuleNames.columnName);
                            SQLQuerySymbolEntry asColumnName = columnNameNode == null ? null : recognizer.collectIdentifier(columnNameNode, null);
                            resultModel.addColumnSpec(sublistNode, expr, asColumnName);
                            break;
                        }
                        resultModel.addColumnSpec(sublistNode, expr);
                        break;
                    }
                    case 286: {
                        break;
                    }
                    default: {
                        if (!STMKnownRuleNames.ASTERISK_TERM.equals(sublistNode.getNodeName())) continue block15;
                        SQLQueryTupleRefEntry tupleRefEntry = new SQLQueryTupleRefEntry(sublistNode);
                        recognizer.registerScopeItem(tupleRefEntry);
                        resultModel.addCompleteTupleSpec(sublistNode, tupleRefEntry);
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        STMTreeNode setQuantifierNode = syntaxNode.findFirstChildOfName(STMKnownRuleNames.setQuantifier);
        int selectListScopeStart = (setQuantifierNode != null ? setQuantifierNode : selectKeywordNode).getRealInterval().b + 2;
        SQLQueryRowsSourceModel source = sourceModels.isEmpty() ? SQLQueryExpressionMapper.makeEmptyRowsModel(syntaxNode) : sourceModels.get(0);
        STMTreeNode tableExpr = syntaxNode.findFirstChildOfName(STMKnownRuleNames.tableExpression);
        if (tableExpr != null) {
            selectListScope.setInterval(Interval.of((int)selectListScopeStart, (int)(tableExpr.getRealInterval().a - 1)));
            SQLQueryLexicalScope fromScope = new SQLQueryLexicalScope();
            STMTreeNode[] filterNodes = new STMTreeNode[]{tableExpr.findFirstChildOfName(STMKnownRuleNames.whereClause), tableExpr.findFirstChildOfName(STMKnownRuleNames.groupByClause), tableExpr.findFirstChildOfName(STMKnownRuleNames.havingClause), tableExpr.findFirstChildOfName(STMKnownRuleNames.orderByClause)};
            SQLQueryValueExpression[] filterExprs = new SQLQueryValueExpression[filterNodes.length];
            SQLQueryLexicalScope[] scopes = new SQLQueryLexicalScope[filterNodes.length + 1];
            SQLQueryLexicalScope[] prevScopes = new SQLQueryLexicalScope[filterNodes.length + 1];
            STMTreeNode[] nextScopeNodes = new STMTreeNode[filterNodes.length + 1];
            scopes[0] = fromScope;
            prevScopes[0] = selectListScope;
            int prevScopeIndex = 0;
            int i = 0;
            while (i < filterNodes.length) {
                STMTreeNode filterNode = filterNodes[i];
                int scopeIndex = i + 1;
                if (filterNode != null) {
                    Throwable throwable3 = null;
                    Object var25_33 = null;
                    try (SQLQueryModelRecognizer.LexicalScopeHolder exprScope = recognizer.openScope();){
                        filterExprs[i] = recognizer.collectValueExpression(filterNode, exprScope.lexicalScope);
                        nextScopeNodes[prevScopeIndex] = filterNode;
                        scopes[scopeIndex] = exprScope.lexicalScope;
                        prevScopes[scopeIndex] = scopes[prevScopeIndex];
                        prevScopeIndex = scopeIndex;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                ++i;
            }
            SQLQueryLexicalScope tailScope = null;
            i = 0;
            while (i < scopes.length) {
                SQLQueryLexicalScope scope = scopes[i];
                if (scope != null) {
                    tailScope = scope;
                    Interval leadingKeywordInterval = null;
                    STMTreeNode leadingNode = i == 0 ? tableExpr.findFirstNonErrorChild() : filterNodes[i - 1];
                    if (leadingNode != null) {
                        leadingKeywordInterval = SQLQueryRowsProjectionModel.findLeadingKeywordsInterval(leadingNode);
                    }
                    int from = leadingKeywordInterval != null ? leadingKeywordInterval.b + 2 : prevScopes[i].getInterval().b;
                    int to = nextScopeNodes[i] != null ? nextScopeNodes[i].getRealInterval().a : Integer.MAX_VALUE;
                    scope.setInterval(Interval.of((int)from, (int)to));
                }
                ++i;
            }
            STMTreeNode limitNode = tableExpr.findFirstChildOfName(STMKnownRuleNames.limitClause);
            if (limitNode != null) {
                tailScope = null;
            }
            projectionModel = ctor.apply(syntaxNode, selectListScope, source, fromScope, FiltersData.of(filterExprs[0], filterExprs[1], filterExprs[2], filterExprs[3]), FiltersData.of(scopes[1], scopes[2], scopes[3], scopes[4]), resultModel, tailScope);
        } else {
            selectListScope.setInterval(Interval.of((int)selectListScopeStart, (int)syntaxNode.getRealInterval().b));
            projectionModel = ctor.apply(syntaxNode, selectListScope, source, null, FiltersData.empty(), FiltersData.empty(), resultModel, selectListScope);
        }
        return projectionModel;
    }

    @Nullable
    private static Interval findLeadingKeywordsInterval(@NotNull STMTreeNode node) {
        STMTreeNode sTMTreeNode;
        Iterator it = node.getChildren().iterator();
        if (it.hasNext() && (sTMTreeNode = (STMTreeNode)it.next()) instanceof STMTreeTermNode) {
            STMTreeNode sTMTreeNode2;
            STMTreeTermNode t1 = (STMTreeTermNode)sTMTreeNode;
            Interval i = t1.getRealInterval();
            int from = i.a;
            int to = i.b;
            while (it.hasNext() && (sTMTreeNode2 = (STMTreeNode)it.next()) instanceof STMTreeTermNode) {
                STMTreeTermNode t = (STMTreeTermNode)sTMTreeNode2;
                to = t.getRealInterval().b;
            }
            return Interval.of((int)from, (int)to);
        }
        return null;
    }

    public static class FiltersData<T> {
        private static final FiltersData<?> EMPTY = new FiltersData<Object>(null, null, null, null);
        public final T whereClause;
        public final T groupByClause;
        public final T havingClause;
        public final T orderByClause;

        public static <T> FiltersData<T> empty() {
            return EMPTY;
        }

        @NotNull
        public static <T> FiltersData<T> of(T where, T groupBy, T having, T orderBy) {
            return new FiltersData<T>(where, groupBy, having, orderBy);
        }

        private FiltersData(T where, T groupBy, T having, T orderBy) {
            this.whereClause = where;
            this.groupByClause = groupBy;
            this.havingClause = having;
            this.orderByClause = orderBy;
        }
    }

    @FunctionalInterface
    public static interface ProjectionModelCtor {
        public SQLQueryRowsSourceModel apply(@NotNull STMTreeNode var1, @NotNull SQLQueryLexicalScope var2, @NotNull SQLQueryRowsSourceModel var3, @Nullable SQLQueryLexicalScope var4, @NotNull FiltersData<SQLQueryValueExpression> var5, @NotNull FiltersData<SQLQueryLexicalScope> var6, @NotNull SQLQuerySelectionResultModel var7, @Nullable SQLQueryLexicalScope var8);
    }
}

