/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreFeatures;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarHandler;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.NodeEditorInput;

public class WorkbenchContextListener
implements IWindowListener,
IPageListener,
IPartListener {
    public static final String PERSPECTIVE_CONTEXT_ID = "org.jkiss.dbeaver.ui.perspective";
    private final Set<IWorkbenchWindow> registeredWindows = new HashSet<IWorkbenchWindow>();
    private final DBPProjectListener projectListener;

    public WorkbenchContextListener() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.listenWindowEvents(window);
            ++n2;
        }
        workbench.addWindowListener((IWindowListener)this);
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService != null) {
            CommandExecutionListener commandExecutionListener = new CommandExecutionListener();
            commandService.addExecutionListener((IExecutionListener)commandExecutionListener);
        }
        workbench.addWindowListener((IWindowListener)this);
        workbench.addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
                DesktopPlatform.setClosing(true);
            }
        });
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            this.windowActivated(activeWindow);
            IWorkbenchPage activePage = activeWindow.getActivePage();
            if (activePage != null) {
                this.pageActivated(activePage);
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart != null) {
                    this.partActivated(activePart);
                }
            }
        }
        this.projectListener = new DBPProjectListener(){

            public void handleProjectRemove(@NotNull DBPProject project) {
                UIUtils.asyncExec(() -> WorkbenchContextListener.this.closeRemovedProjectsEditors(project));
            }
        };
        DBPPlatformDesktop.getInstance().getWorkspace().addProjectListener(this.projectListener);
    }

    private void closeRemovedProjectsEditors(DBPProject project) {
        Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Arrays.stream(window.getPages())).forEach(page -> this.closePageProjectEditors((IWorkbenchPage)page, project));
    }

    private void closePageProjectEditors(IWorkbenchPage page, DBPProject project) {
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeEditorInput nodeEditorInput;
            DBPProject editorProject;
            IEditorInput input;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                input = editorReference.getEditorInput();
            }
            catch (PartInitException partInitException) {
                return;
            }
            if (input instanceof NodeEditorInput && Objects.equals(project, editorProject = (nodeEditorInput = (NodeEditorInput)input).getNavigatorNode().getOwnerProject())) {
                IEditorPart editor = editorReference.getEditor(false);
                page.closeEditor(editor, false);
                editor.dispose();
            }
            ++n2;
        }
    }

    private void listenWindowEvents(IWorkbenchWindow window) {
        if (!this.registeredWindows.contains(window)) {
            DataSourceToolbarHandler toolbarHandler = new DataSourceToolbarHandler(window);
            window.getShell().addDisposeListener(e -> toolbarHandler.dispose());
            this.registeredWindows.add(window);
        }
        IPerspectiveListener perspectiveListener = new IPerspectiveListener(){
            private IContextActivation perspectiveActivation;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
                if (contextService == null) {
                    return;
                }
                if (perspective.getId().equals("org.jkiss.dbeaver.core.perspective")) {
                    this.perspectiveActivation = contextService.activateContext(WorkbenchContextListener.PERSPECTIVE_CONTEXT_ID);
                } else if (this.perspectiveActivation != null) {
                    contextService.deactivateContext(this.perspectiveActivation);
                    this.perspectiveActivation = null;
                }
                CoreFeatures.GENERAL_SHOW_PERSPECTIVE.use(Map.of("perspective", perspective.getId()));
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        window.addPerspectiveListener(perspectiveListener);
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            perspectiveListener.perspectiveActivated(activePage, activePage.getPerspective());
        }
        window.addPageListener((IPageListener)this);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n3 = iViewReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference vr = iViewReferenceArray[n4];
                if (vr.getView(false) != null) {
                    CoreFeatures.GENERAL_VIEW_OPEN.use(Map.of("view", vr.getId()));
                }
                ++n4;
            }
            page.addPartListener((IPartListener)this);
            ++n2;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.listenWindowEvents(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        EditorUtils.activatePartContexts((IWorkbenchPart)part);
    }

    public void partDeactivated(IWorkbenchPart part) {
        EditorUtils.deactivatePartContexts((IWorkbenchPart)part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            CoreFeatures.GENERAL_VIEW_CLOSE.use(Map.of("view", ((IViewPart)part).getViewSite().getId()));
        }
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            CoreFeatures.GENERAL_VIEW_OPEN.use(Map.of("view", ((IViewPart)part).getViewSite().getId()));
        }
    }

    public void dispose() {
        DBPPlatformDesktop.getInstance().getWorkspace().removeProjectListener(this.projectListener);
    }

    static WorkbenchContextListener registerInWorkbench() {
        return new WorkbenchContextListener();
    }

    private static class CommandExecutionListener
    implements IExecutionListener {
        private CommandExecutionListener() {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
            DBRFeature commandFeature = DBRFeatureRegistry.getInstance().findCommandFeature(commandId);
            if (commandFeature != null) {
                commandFeature.use(event.getParameters());
            }
        }
    }
}

