/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlConnection;
import com.dbeaver.jdbc.driver.libsql.LibSqlUtils;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import com.dbeaver.jdbc.model.AbstractJdbcDatabaseMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class LibSqlDatabaseMetaData
extends AbstractJdbcDatabaseMetaData<LibSqlConnection> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\w+)\\s+([0-9.]+)\\s+(.+)");
    private String serverVersion;
    private static final Map<String, Integer> RULE_MAP = new HashMap<String, Integer>();

    static {
        RULE_MAP.put("NO ACTION", 3);
        RULE_MAP.put("CASCADE", 0);
        RULE_MAP.put("RESTRICT", 1);
        RULE_MAP.put("SET NULL", 2);
        RULE_MAP.put("SET DEFAULT", 4);
    }

    public LibSqlDatabaseMetaData(@NotNull LibSqlConnection connection) {
        super((AbstractJdbcConnection)connection, connection.getUrl());
    }

    private void readServerVersion() throws SQLException {
        if (this.serverVersion != null) {
            return;
        }
        try {
            HttpURLConnection con = ((LibSqlConnection)this.connection).getClient().openSimpleConnection("version");
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = con.getInputStream();){
                this.serverVersion = IOUtils.readLine((InputStream)is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public String getDatabaseProductName() throws SQLException {
        this.readServerVersion();
        return this.serverVersion;
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.readServerVersion();
        Matcher matcher = VERSION_PATTERN.matcher(this.serverVersion);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return this.serverVersion;
    }

    public String getDriverName() {
        return ((LibSqlConnection)this.connection).getDriver().getDriverName();
    }

    public String getDriverVersion() {
        return ((LibSqlConnection)this.connection).getDriver().getFullVersion();
    }

    public int getDriverMajorVersion() {
        return ((LibSqlConnection)this.connection).getDriver().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return ((LibSqlConnection)this.connection).getDriver().getMinorVersion();
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        LibSqlDatabaseMetaData.verifySchemaParameters(catalog, schemaPattern);
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement dbStat = ((LibSqlConnection)this.connection).prepareStatement("SELECT NULL as TABLE_CAT, NULL AS TABLE_SCHEM,name AS TABLE_NAME,type as TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME FROM sqlite_master WHERE type='table'");){
            return dbStat.executeQuery();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableName, String columnNamePattern) throws SQLException {
        LibSqlDatabaseMetaData.verifySchemaParameters(catalog, schemaPattern);
        if (CommonUtils.isEmpty((String)tableName) || "%".equals(tableName)) {
            tableName = null;
        }
        return this.executeQuery("WITH all_tables AS (SELECT name AS tn FROM sqlite_master WHERE type = 'table'" + (String)(tableName == null ? "" : " and name=" + LibSqlUtils.quote(tableName)) + ") \nSELECT NULL as TABLE_CAT, NULL AS TABLE_SCHEM, at.tn as TABLE_NAME,\npti.name as COLUMN_NAME,12 AS DATA_TYPE,pti.type AS TYPE_NAME,0 AS COLUMN_SIZE,0 as COLUMN_SIZE,0 as BUFFER_LENGTH,0 as DECIMAL_DIGITS,\n1 as NULLABLE,NULL as REMARKS,NULL as COLUMN_DEF,0 as SQL_DATA_TYPE,0 as SQL_DATETIME_SUB,0 as CHAR_OCTET_LENGTH,pti.cid as ORDINAL_POSITION,'' as IS_NULLABLE,NULL as SCOPE_CATALOG,NULL as SCOPE_SCHEMA,NULL as SCOPE_TABLE,NULL as SOURCE_DATA_TYPE,'' as IS_AUTOINCREMENT,'' as IS_GENERATEDCOLUMN\nFROM all_tables at INNER JOIN pragma_table_info(at.tn) pti\nORDER BY TABLE_NAME");
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String tableName) throws SQLException {
        String table = tableName;
        PrimaryKeyFinder pkFinder = new PrimaryKeyFinder((Connection)this.connection, table);
        String[] columns = pkFinder.getColumns();
        StringBuilder sql = new StringBuilder();
        sql.append("select null as TABLE_CAT, null as TABLE_SCHEM, '").append(LibSqlUtils.escape(table)).append("' as TABLE_NAME, cn as COLUMN_NAME, ks as KEY_SEQ, pk as PK_NAME from (");
        if (columns == null) {
            sql.append("select null as cn, null as pk, 0 as ks) limit 0;");
            return this.executeQuery(sql.toString());
        }
        Object pkName = pkFinder.getName();
        if (pkName != null) {
            pkName = "'" + (String)pkName + "'";
        }
        int i = 0;
        while (i < columns.length) {
            if (i > 0) {
                sql.append(" union ");
            }
            sql.append("select ").append((String)pkName).append(" as pk, '").append(LibSqlUtils.escape(LibSqlUtils.unquote(columns[i]))).append("' as cn, ").append(i + 1).append(" as ks");
            ++i;
        }
        sql.append(") order by cn;");
        return this.executeQuery(sql.toString());
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select null as TABLE_CAT, null as TABLE_SCHEM, '").append(LibSqlUtils.escape(table)).append("' as TABLE_NAME, un as NON_UNIQUE, null as INDEX_QUALIFIER, n as INDEX_NAME, ").append(Integer.toString(3)).append(" as TYPE, op as ORDINAL_POSITION, ").append("cn as COLUMN_NAME, null as ASC_OR_DESC, 0 as CARDINALITY, 0 as PAGES, null as FILTER_CONDITION from (");
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>();
        Throwable throwable = null;
        Object var9_10 = null;
        try (ResultSet rs = this.executeQuery("pragma index_list('" + LibSqlUtils.escape(table) + "')");){
            while (rs.next()) {
                IndexInfo indexInfo = new IndexInfo(rs.getString(2), rs.getInt(3));
                indexList.add(indexInfo);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (indexList.isEmpty()) {
            sql.append("select null as un, null as n, null as op, null as cn) limit 0;");
            return this.executeQuery(sql.toString());
        }
        ArrayList<String> unionAll = new ArrayList<String>();
        for (IndexInfo currentIndex : indexList) {
            String indexName = currentIndex.indexName;
            Throwable throwable3 = null;
            Object var13_16 = null;
            try (ResultSet rs = this.executeQuery("pragma index_info('" + LibSqlUtils.escape(indexName) + "')");){
                while (rs.next()) {
                    StringBuilder sqlRow = new StringBuilder();
                    String colName = rs.getString(3);
                    sqlRow.append("select ").append(1 - currentIndex.indexId).append(" as un,'").append(LibSqlUtils.escape(indexName)).append("' as n,").append(rs.getInt(1) + 1).append(" as op,");
                    if (colName == null) {
                        sqlRow.append("null");
                    } else {
                        sqlRow.append("'").append(LibSqlUtils.escape(colName)).append("'");
                    }
                    sqlRow.append(" as cn");
                    unionAll.add(sqlRow.toString());
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
        String sqlBlock = String.join((CharSequence)" union all ", unionAll);
        sql.append(sqlBlock).append(");");
        return this.executeQuery(sql.toString());
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(LibSqlUtils.quote(catalog)).append(" as PKTABLE_CAT, ").append(LibSqlUtils.quote(schema)).append(" as PKTABLE_SCHEM, ").append("ptn as PKTABLE_NAME, pcn as PKCOLUMN_NAME, ").append(LibSqlUtils.quote(catalog)).append(" as FKTABLE_CAT, ").append(LibSqlUtils.quote(schema)).append(" as FKTABLE_SCHEM, ").append(LibSqlUtils.quote(table)).append(" as FKTABLE_NAME, ").append("fcn as FKCOLUMN_NAME, ks as KEY_SEQ, ur as UPDATE_RULE, dr as DELETE_RULE, fkn as FK_NAME, pkn as PK_NAME, ").append(5).append(" as DEFERRABILITY from (");
        Throwable throwable = null;
        Object var6_7 = null;
        try (ResultSet rs = this.executeQuery("pragma foreign_key_list('" + LibSqlUtils.escape(table) + "')");){
            ImportedKeyFinder impFkFinder = new ImportedKeyFinder((Connection)this.connection, table);
            List<ImportedKeyFinder.ForeignKey> fkNames = impFkFinder.getFkList();
            int i = 0;
            while (rs.next()) {
                int keySeq = rs.getInt(2) + 1;
                int keyId = rs.getInt(1);
                String PKTabName = rs.getString(3);
                String FKColName = rs.getString(4);
                String PKColName = rs.getString(5);
                String pkName = null;
                try {
                    PrimaryKeyFinder pkFinder = new PrimaryKeyFinder((Connection)this.connection, PKTabName);
                    pkName = pkFinder.getName();
                    if (PKColName == null) {
                        PKColName = pkFinder.getColumns()[0];
                    }
                }
                catch (SQLException sQLException) {}
                String updateRule = rs.getString(6);
                String deleteRule = rs.getString(7);
                if (i > 0) {
                    sql.append(" union all ");
                }
                String fkName = null;
                if (fkNames.size() > keyId) {
                    fkName = fkNames.get(keyId).getFkName();
                }
                sql.append("select ").append(keySeq).append(" as ks,").append("'").append(LibSqlUtils.escape(PKTabName)).append("' as ptn, '").append(LibSqlUtils.escape(FKColName)).append("' as fcn, '").append(LibSqlUtils.escape(PKColName)).append("' as pcn,").append("case '").append(LibSqlUtils.escape(updateRule)).append("'").append(" when 'NO ACTION' then ").append(3).append(" when 'CASCADE' then ").append(0).append(" when 'RESTRICT' then ").append(1).append(" when 'SET NULL' then ").append(2).append(" when 'SET DEFAULT' then ").append(4).append(" end as ur, ").append("case '").append(LibSqlUtils.escape(deleteRule)).append("'").append(" when 'NO ACTION' then ").append(3).append(" when 'CASCADE' then ").append(0).append(" when 'RESTRICT' then ").append(1).append(" when 'SET NULL' then ").append(2).append(" when 'SET DEFAULT' then ").append(4).append(" end as dr, ").append(fkName == null ? "''" : LibSqlUtils.quote(fkName)).append(" as fkn, ").append(pkName == null ? "''" : LibSqlUtils.quote(pkName)).append(" as pkn");
                ++i;
            }
            if (i == 0) {
                sql.append("select -1 as ks, '' as ptn, '' as fcn, '' as pcn, ").append(3).append(" as ur, ").append(3).append(" as dr, ").append(" '' as fkn, ").append(" '' as pkn ").append(") limit 0;");
            } else {
                sql.append(") ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.executeQuery(sql.toString());
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        PrimaryKeyFinder pkFinder = new PrimaryKeyFinder((Connection)this.connection, table);
        String[] pkColumns = pkFinder.getColumns();
        catalog = catalog != null ? LibSqlUtils.quote(catalog) : null;
        schema = schema != null ? LibSqlUtils.quote(schema) : null;
        StringBuilder exportedKeysQuery = new StringBuilder();
        String target = null;
        int count = 0;
        if (pkColumns != null) {
            ArrayList<String> tableList;
            Throwable throwable = null;
            Iterator iterator = null;
            try (ResultSet rs = this.executeQuery("select name from sqlite_schema where type = 'table'");){
                tableList = new ArrayList<String>();
                while (rs.next()) {
                    String tblname = rs.getString(1);
                    tableList.add(tblname);
                    if (!tblname.equalsIgnoreCase(table)) continue;
                    target = tblname;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            for (String tbl : tableList) {
                ImportedKeyFinder impFkFinder = new ImportedKeyFinder((Connection)this.connection, tbl);
                List<ImportedKeyFinder.ForeignKey> fkNames = impFkFinder.getFkList();
                for (ImportedKeyFinder.ForeignKey foreignKey : fkNames) {
                    String PKTabName = foreignKey.pkTableName;
                    if (PKTabName == null || !PKTabName.equalsIgnoreCase(target)) continue;
                    int j = 0;
                    while (j < foreignKey.fkColNames.size()) {
                        int keySeq = j + 1;
                        String pkColName = foreignKey.pkColNames.get(j);
                        pkColName = pkColName == null ? "" : pkColName;
                        String fkColName = foreignKey.fkColNames.get(j);
                        fkColName = fkColName == null ? "" : fkColName;
                        boolean usePkName = false;
                        String[] stringArray = pkColumns;
                        int n = pkColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pkColumn = stringArray[n2];
                            if (pkColumn != null && pkColumn.equalsIgnoreCase(pkColName)) {
                                usePkName = true;
                                break;
                            }
                            ++n2;
                        }
                        String pkName = usePkName && pkFinder.getName() != null ? pkFinder.getName() : "";
                        exportedKeysQuery.append(count > 0 ? " union all select " : "select ").append(keySeq).append(" as ks, '").append(LibSqlUtils.escape(tbl)).append("' as fkt, '").append(LibSqlUtils.escape(fkColName)).append("' as fcn, '").append(LibSqlUtils.escape(pkColName)).append("' as pcn, '").append(LibSqlUtils.escape(pkName)).append("' as pkn, ").append(RULE_MAP.get(foreignKey.onUpdate)).append(" as ur, ").append(RULE_MAP.get(foreignKey.onDelete)).append(" as dr, ");
                        String fkName = foreignKey.getFkName();
                        if (fkName != null) {
                            exportedKeysQuery.append("'").append(LibSqlUtils.escape(fkName)).append("' as fkn");
                        } else {
                            exportedKeysQuery.append("'' as fkn");
                        }
                        ++count;
                        ++j;
                    }
                }
            }
        }
        boolean hasImportedKey = count > 0;
        StringBuilder sql = new StringBuilder(512);
        sql.append("select ").append(catalog).append(" as PKTABLE_CAT, ").append(schema).append(" as PKTABLE_SCHEM, ").append(LibSqlUtils.quote(target)).append(" as PKTABLE_NAME, ").append(hasImportedKey ? "pcn" : "''").append(" as PKCOLUMN_NAME, ").append(catalog).append(" as FKTABLE_CAT, ").append(schema).append(" as FKTABLE_SCHEM, ").append(hasImportedKey ? "fkt" : "''").append(" as FKTABLE_NAME, ").append(hasImportedKey ? "fcn" : "''").append(" as FKCOLUMN_NAME, ").append(hasImportedKey ? "ks" : "-1").append(" as KEY_SEQ, ").append(hasImportedKey ? "ur" : "3").append(" as UPDATE_RULE, ").append(hasImportedKey ? "dr" : "3").append(" as DELETE_RULE, ").append(hasImportedKey ? "fkn" : "''").append(" as FK_NAME, ").append(hasImportedKey ? "pkn" : "''").append(" as PK_NAME, ").append(5).append(" as DEFERRABILITY ");
        if (hasImportedKey) {
            sql.append("from (").append((CharSequence)exportedKeysQuery).append(") ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        } else {
            sql.append("limit 0");
        }
        return this.executeQuery(sql.toString());
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (parentTable == null) {
            return this.getExportedKeys(parentCatalog, parentSchema, parentTable);
        }
        if (foreignTable == null) {
            return this.getImportedKeys(parentCatalog, parentSchema, parentTable);
        }
        String query = "select " + LibSqlUtils.quote(parentCatalog) + " as PKTABLE_CAT, " + LibSqlUtils.quote(parentSchema) + " as PKTABLE_SCHEM, " + LibSqlUtils.quote(parentTable) + " as PKTABLE_NAME, '' as PKCOLUMN_NAME, " + LibSqlUtils.quote(foreignCatalog) + " as FKTABLE_CAT, " + LibSqlUtils.quote(foreignSchema) + " as FKTABLE_SCHEM, " + LibSqlUtils.quote(foreignTable) + " as FKTABLE_NAME, '' as FKCOLUMN_NAME, -1 as KEY_SEQ, 3 as UPDATE_RULE, 3 as DELETE_RULE, '' as FK_NAME, '' as PK_NAME, 5 as DEFERRABILITY limit 0 ";
        return this.executeQuery(query);
    }

    private static void verifySchemaParameters(String catalog, String schemaPattern) throws SQLException {
        if (!CommonUtils.isEmpty((String)catalog)) {
            throw new SQLException("Catalogs are not supported");
        }
        if (!CommonUtils.isEmpty((String)schemaPattern)) {
            throw new SQLException("Schemas are not supported");
        }
    }

    private ResultSet executeQuery(String query) throws SQLException {
        return LibSqlUtils.executeQuery((Connection)this.connection, query);
    }

    static class ImportedKeyFinder {
        private static final Pattern FK_NAMED_PATTERN = Pattern.compile("CONSTRAINT\\s*\"?([A-Za-z_][A-Za-z\\d_]*)?\"?\\s*FOREIGN\\s+KEY\\s*\\((.*?)\\)", 34);
        private final Connection conn;
        private final List<ForeignKey> fkList = new ArrayList<ForeignKey>();

        public ImportedKeyFinder(Connection connection, String table) throws SQLException {
            this.conn = connection;
            if (table == null || table.trim().isEmpty()) {
                throw new SQLException("Invalid table name: '" + table + "'");
            }
            List<String> fkNames = this.getForeignKeyNames(table);
            Throwable throwable = null;
            Object var5_6 = null;
            try (ResultSet rs = LibSqlUtils.executeQuery(connection, "pragma foreign_key_list('" + LibSqlUtils.escape(table.toLowerCase()) + "')");){
                int prevFkId = -1;
                int count = 0;
                ForeignKey fk = null;
                while (rs.next()) {
                    int fkId = rs.getInt(1);
                    String pkTableName = rs.getString(3);
                    String fkColName = rs.getString(4);
                    String pkColName = rs.getString(5);
                    String onUpdate = rs.getString(6);
                    String onDelete = rs.getString(7);
                    String match = rs.getString(8);
                    String fkName = null;
                    if (fkNames.size() > count) {
                        fkName = fkNames.get(count);
                    }
                    if (fkId != prevFkId) {
                        fk = new ForeignKey(fkName, pkTableName, table, onUpdate, onDelete, match);
                        this.fkList.add(fk);
                        prevFkId = fkId;
                        ++count;
                    }
                    if (fk == null) continue;
                    fk.addColumnMapping(fkColName, pkColName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private List<String> getForeignKeyNames(String tbl) throws SQLException {
            ArrayList<String> fkNames = new ArrayList<String>();
            if (tbl == null) {
                return fkNames;
            }
            Throwable throwable = null;
            Object var4_5 = null;
            try (ResultSet rs = LibSqlUtils.executeQuery(this.conn, "select sql from sqlite_schema where lower(name) = lower('" + LibSqlUtils.escape(tbl) + "')");){
                if (rs.next()) {
                    Matcher matcher = FK_NAMED_PATTERN.matcher(rs.getString(1));
                    while (matcher.find()) {
                        fkNames.add(matcher.group(1));
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Collections.reverse(fkNames);
            return fkNames;
        }

        public List<ForeignKey> getFkList() {
            return this.fkList;
        }

        static class ForeignKey {
            private final String fkName;
            private final String pkTableName;
            private final String fkTableName;
            private final List<String> fkColNames = new ArrayList<String>();
            private final List<String> pkColNames = new ArrayList<String>();
            private final String onUpdate;
            private final String onDelete;
            private final String match;

            ForeignKey(String fkName, String pkTableName, String fkTableName, String onUpdate, String onDelete, String match) {
                this.fkName = fkName;
                this.pkTableName = pkTableName;
                this.fkTableName = fkTableName;
                this.onUpdate = onUpdate;
                this.onDelete = onDelete;
                this.match = match;
            }

            public String getFkName() {
                return this.fkName;
            }

            void addColumnMapping(String fkColName, String pkColName) {
                this.fkColNames.add(fkColName);
                this.pkColNames.add(pkColName);
            }

            public String toString() {
                return "ForeignKey [fkName=" + this.fkName + ", pkTableName=" + this.pkTableName + ", fkTableName=" + this.fkTableName + ", pkColNames=" + String.valueOf(this.pkColNames) + ", fkColNames=" + String.valueOf(this.fkColNames) + "]";
            }
        }
    }

    private static class IndexInfo {
        String indexName;
        int indexId;

        public IndexInfo(String indexName, int indexId) {
            this.indexName = indexName;
            this.indexId = indexId;
        }
    }

    static class PrimaryKeyFinder {
        protected static final Pattern PK_UNNAMED_PATTERN = Pattern.compile(".*PRIMARY\\s+KEY\\s*\\((.*?)\\).*", 34);
        protected static final Pattern PK_NAMED_PATTERN = Pattern.compile(".*CONSTRAINT\\s*(.*?)\\s*PRIMARY\\s+KEY\\s*\\((.*?)\\).*", 34);
        String table;
        String pkName = null;
        String[] pkColumns = null;

        public PrimaryKeyFinder(Connection connection, String table) throws SQLException {
            this.table = table;
            if ("sqlite_schema".equals(table) || "sqlite_master".equals(table)) {
                return;
            }
            if (table == null || table.trim().isEmpty()) {
                throw new SQLException("Invalid table name: '" + this.table + "'");
            }
            Throwable throwable = null;
            Object var4_5 = null;
            try (ResultSet rs = LibSqlUtils.executeQuery(connection, "select sql from sqlite_schema where lower(name) = lower('" + LibSqlUtils.escape(table) + "') and type in ('table', 'view')");){
                if (!rs.next()) {
                    throw new SQLException("Table not found: '" + table + "'");
                }
                Matcher matcher = PK_NAMED_PATTERN.matcher(rs.getString(1));
                if (matcher.find()) {
                    this.pkName = LibSqlUtils.unquote(LibSqlUtils.escape(matcher.group(1)));
                    this.pkColumns = matcher.group(2).split(",");
                } else {
                    matcher = PK_UNNAMED_PATTERN.matcher(rs.getString(1));
                    if (matcher.find()) {
                        this.pkColumns = matcher.group(1).split(",");
                    }
                }
                if (this.pkColumns == null) {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (ResultSet rs2 = LibSqlUtils.executeQuery(connection, "pragma table_info('" + LibSqlUtils.escape(table) + "')");){
                        while (rs2.next()) {
                            if (!rs2.getBoolean(6)) continue;
                            this.pkColumns = new String[]{rs2.getString(2)};
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (this.pkColumns != null) {
                    int i = 0;
                    while (i < this.pkColumns.length) {
                        this.pkColumns[i] = LibSqlUtils.unquote(this.pkColumns[i]);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }

        public String getName() {
            return this.pkName;
        }

        public String[] getColumns() {
            return this.pkColumns;
        }
    }
}

