/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateSectigo targetCreateSectigo is a command that creates a new Sectigo target
type TargetCreateSectigo struct {
	// Certificate Profile ID in Sectigo account
	CertificateProfileId int64 `json:"certificate-profile-id"`
	// Customer Uri of the Sectigo account
	CustomerUri string `json:"customer-uri"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// External Requester - a comma separated list of emails
	ExternalRequester string `json:"external-requester"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Organization ID in Sectigo account
	OrganizationId int64 `json:"organization-id"`
	// Password of the Sectigo account user
	Password string `json:"password"`
	// Timeout waiting for certificate validation in Duration format (1h - 1 Hour, 20m - 20 Minutes, 33m3s - 33 Minutes and 3 Seconds), maximum 1h.
	Timeout *string `json:"timeout,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Username of the Sectigo account
	Username string `json:"username"`
}

// NewTargetCreateSectigo instantiates a new TargetCreateSectigo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateSectigo(certificateProfileId int64, customerUri string, externalRequester string, name string, organizationId int64, password string, username string, ) *TargetCreateSectigo {
	this := TargetCreateSectigo{}
	this.CertificateProfileId = certificateProfileId
	this.CustomerUri = customerUri
	this.ExternalRequester = externalRequester
	var json bool = false
	this.Json = &json
	this.Name = name
	this.OrganizationId = organizationId
	this.Password = password
	var timeout string = "5m"
	this.Timeout = &timeout
	this.Username = username
	return &this
}

// NewTargetCreateSectigoWithDefaults instantiates a new TargetCreateSectigo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateSectigoWithDefaults() *TargetCreateSectigo {
	this := TargetCreateSectigo{}
	var json bool = false
	this.Json = &json
	var timeout string = "5m"
	this.Timeout = &timeout
	return &this
}

// GetCertificateProfileId returns the CertificateProfileId field value
func (o *TargetCreateSectigo) GetCertificateProfileId() int64 {
	if o == nil  {
		var ret int64
		return ret
	}

	return o.CertificateProfileId
}

// GetCertificateProfileIdOk returns a tuple with the CertificateProfileId field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetCertificateProfileIdOk() (*int64, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CertificateProfileId, true
}

// SetCertificateProfileId sets field value
func (o *TargetCreateSectigo) SetCertificateProfileId(v int64) {
	o.CertificateProfileId = v
}

// GetCustomerUri returns the CustomerUri field value
func (o *TargetCreateSectigo) GetCustomerUri() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CustomerUri
}

// GetCustomerUriOk returns a tuple with the CustomerUri field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetCustomerUriOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CustomerUri, true
}

// SetCustomerUri sets field value
func (o *TargetCreateSectigo) SetCustomerUri(v string) {
	o.CustomerUri = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateSectigo) SetDescription(v string) {
	o.Description = &v
}

// GetExternalRequester returns the ExternalRequester field value
func (o *TargetCreateSectigo) GetExternalRequester() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ExternalRequester
}

// GetExternalRequesterOk returns a tuple with the ExternalRequester field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetExternalRequesterOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ExternalRequester, true
}

// SetExternalRequester sets field value
func (o *TargetCreateSectigo) SetExternalRequester(v string) {
	o.ExternalRequester = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateSectigo) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateSectigo) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateSectigo) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateSectigo) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateSectigo) SetName(v string) {
	o.Name = v
}

// GetOrganizationId returns the OrganizationId field value
func (o *TargetCreateSectigo) GetOrganizationId() int64 {
	if o == nil  {
		var ret int64
		return ret
	}

	return o.OrganizationId
}

// GetOrganizationIdOk returns a tuple with the OrganizationId field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetOrganizationIdOk() (*int64, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.OrganizationId, true
}

// SetOrganizationId sets field value
func (o *TargetCreateSectigo) SetOrganizationId(v int64) {
	o.OrganizationId = v
}

// GetPassword returns the Password field value
func (o *TargetCreateSectigo) GetPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Password
}

// GetPasswordOk returns a tuple with the Password field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Password, true
}

// SetPassword sets field value
func (o *TargetCreateSectigo) SetPassword(v string) {
	o.Password = v
}

// GetTimeout returns the Timeout field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetTimeout() string {
	if o == nil || o.Timeout == nil {
		var ret string
		return ret
	}
	return *o.Timeout
}

// GetTimeoutOk returns a tuple with the Timeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetTimeoutOk() (*string, bool) {
	if o == nil || o.Timeout == nil {
		return nil, false
	}
	return o.Timeout, true
}

// HasTimeout returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasTimeout() bool {
	if o != nil && o.Timeout != nil {
		return true
	}

	return false
}

// SetTimeout gets a reference to the given string and assigns it to the Timeout field.
func (o *TargetCreateSectigo) SetTimeout(v string) {
	o.Timeout = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateSectigo) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateSectigo) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateSectigo) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateSectigo) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUsername returns the Username field value
func (o *TargetCreateSectigo) GetUsername() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Username
}

// GetUsernameOk returns a tuple with the Username field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSectigo) GetUsernameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Username, true
}

// SetUsername sets field value
func (o *TargetCreateSectigo) SetUsername(v string) {
	o.Username = v
}

func (o TargetCreateSectigo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["certificate-profile-id"] = o.CertificateProfileId
	}
	if true {
		toSerialize["customer-uri"] = o.CustomerUri
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["external-requester"] = o.ExternalRequester
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if true {
		toSerialize["organization-id"] = o.OrganizationId
	}
	if true {
		toSerialize["password"] = o.Password
	}
	if o.Timeout != nil {
		toSerialize["timeout"] = o.Timeout
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["username"] = o.Username
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateSectigo struct {
	value *TargetCreateSectigo
	isSet bool
}

func (v NullableTargetCreateSectigo) Get() *TargetCreateSectigo {
	return v.value
}

func (v *NullableTargetCreateSectigo) Set(val *TargetCreateSectigo) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateSectigo) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateSectigo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateSectigo(val *TargetCreateSectigo) *NullableTargetCreateSectigo {
	return &NullableTargetCreateSectigo{value: val, isSet: true}
}

func (v NullableTargetCreateSectigo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateSectigo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


