/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// ProvisionCertificateOutput struct for ProvisionCertificateOutput
type ProvisionCertificateOutput struct {
	FailMessage *string `json:"FailMessage,omitempty"`
	SuccessMessage *string `json:"SuccessMessage,omitempty"`
	HostNames *[]string `json:"host_names,omitempty"`
	ProvisionedAt *time.Time `json:"provisioned_at,omitempty"`
}

// NewProvisionCertificateOutput instantiates a new ProvisionCertificateOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewProvisionCertificateOutput() *ProvisionCertificateOutput {
	this := ProvisionCertificateOutput{}
	return &this
}

// NewProvisionCertificateOutputWithDefaults instantiates a new ProvisionCertificateOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewProvisionCertificateOutputWithDefaults() *ProvisionCertificateOutput {
	this := ProvisionCertificateOutput{}
	return &this
}

// GetFailMessage returns the FailMessage field value if set, zero value otherwise.
func (o *ProvisionCertificateOutput) GetFailMessage() string {
	if o == nil || o.FailMessage == nil {
		var ret string
		return ret
	}
	return *o.FailMessage
}

// GetFailMessageOk returns a tuple with the FailMessage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProvisionCertificateOutput) GetFailMessageOk() (*string, bool) {
	if o == nil || o.FailMessage == nil {
		return nil, false
	}
	return o.FailMessage, true
}

// HasFailMessage returns a boolean if a field has been set.
func (o *ProvisionCertificateOutput) HasFailMessage() bool {
	if o != nil && o.FailMessage != nil {
		return true
	}

	return false
}

// SetFailMessage gets a reference to the given string and assigns it to the FailMessage field.
func (o *ProvisionCertificateOutput) SetFailMessage(v string) {
	o.FailMessage = &v
}

// GetSuccessMessage returns the SuccessMessage field value if set, zero value otherwise.
func (o *ProvisionCertificateOutput) GetSuccessMessage() string {
	if o == nil || o.SuccessMessage == nil {
		var ret string
		return ret
	}
	return *o.SuccessMessage
}

// GetSuccessMessageOk returns a tuple with the SuccessMessage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProvisionCertificateOutput) GetSuccessMessageOk() (*string, bool) {
	if o == nil || o.SuccessMessage == nil {
		return nil, false
	}
	return o.SuccessMessage, true
}

// HasSuccessMessage returns a boolean if a field has been set.
func (o *ProvisionCertificateOutput) HasSuccessMessage() bool {
	if o != nil && o.SuccessMessage != nil {
		return true
	}

	return false
}

// SetSuccessMessage gets a reference to the given string and assigns it to the SuccessMessage field.
func (o *ProvisionCertificateOutput) SetSuccessMessage(v string) {
	o.SuccessMessage = &v
}

// GetHostNames returns the HostNames field value if set, zero value otherwise.
func (o *ProvisionCertificateOutput) GetHostNames() []string {
	if o == nil || o.HostNames == nil {
		var ret []string
		return ret
	}
	return *o.HostNames
}

// GetHostNamesOk returns a tuple with the HostNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProvisionCertificateOutput) GetHostNamesOk() (*[]string, bool) {
	if o == nil || o.HostNames == nil {
		return nil, false
	}
	return o.HostNames, true
}

// HasHostNames returns a boolean if a field has been set.
func (o *ProvisionCertificateOutput) HasHostNames() bool {
	if o != nil && o.HostNames != nil {
		return true
	}

	return false
}

// SetHostNames gets a reference to the given []string and assigns it to the HostNames field.
func (o *ProvisionCertificateOutput) SetHostNames(v []string) {
	o.HostNames = &v
}

// GetProvisionedAt returns the ProvisionedAt field value if set, zero value otherwise.
func (o *ProvisionCertificateOutput) GetProvisionedAt() time.Time {
	if o == nil || o.ProvisionedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.ProvisionedAt
}

// GetProvisionedAtOk returns a tuple with the ProvisionedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProvisionCertificateOutput) GetProvisionedAtOk() (*time.Time, bool) {
	if o == nil || o.ProvisionedAt == nil {
		return nil, false
	}
	return o.ProvisionedAt, true
}

// HasProvisionedAt returns a boolean if a field has been set.
func (o *ProvisionCertificateOutput) HasProvisionedAt() bool {
	if o != nil && o.ProvisionedAt != nil {
		return true
	}

	return false
}

// SetProvisionedAt gets a reference to the given time.Time and assigns it to the ProvisionedAt field.
func (o *ProvisionCertificateOutput) SetProvisionedAt(v time.Time) {
	o.ProvisionedAt = &v
}

func (o ProvisionCertificateOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.FailMessage != nil {
		toSerialize["FailMessage"] = o.FailMessage
	}
	if o.SuccessMessage != nil {
		toSerialize["SuccessMessage"] = o.SuccessMessage
	}
	if o.HostNames != nil {
		toSerialize["host_names"] = o.HostNames
	}
	if o.ProvisionedAt != nil {
		toSerialize["provisioned_at"] = o.ProvisionedAt
	}
	return json.Marshal(toSerialize)
}

type NullableProvisionCertificateOutput struct {
	value *ProvisionCertificateOutput
	isSet bool
}

func (v NullableProvisionCertificateOutput) Get() *ProvisionCertificateOutput {
	return v.value
}

func (v *NullableProvisionCertificateOutput) Set(val *ProvisionCertificateOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableProvisionCertificateOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableProvisionCertificateOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableProvisionCertificateOutput(val *ProvisionCertificateOutput) *NullableProvisionCertificateOutput {
	return &NullableProvisionCertificateOutput{value: val, isSet: true}
}

func (v NullableProvisionCertificateOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableProvisionCertificateOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


