/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayDeleteSubAdmins gatewayDeleteSubAdmins is a command that deletes sub-admins
type GatewayDeleteSubAdmins struct {
	// Gateway url
	GatewayUrl *string `json:"gateway-url,omitempty"`
	// Required only when the authentication process requires a username and password
	Password *string `json:"password,omitempty"`
	// SubAdminID to be removed
	SubAdminId string `json:"sub-admin-id"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Required only when the authentication process requires a username and password
	Username *string `json:"username,omitempty"`
}

// NewGatewayDeleteSubAdmins instantiates a new GatewayDeleteSubAdmins object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayDeleteSubAdmins(subAdminId string, ) *GatewayDeleteSubAdmins {
	this := GatewayDeleteSubAdmins{}
	var gatewayUrl string = "http://localhost:8000"
	this.GatewayUrl = &gatewayUrl
	this.SubAdminId = subAdminId
	return &this
}

// NewGatewayDeleteSubAdminsWithDefaults instantiates a new GatewayDeleteSubAdmins object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayDeleteSubAdminsWithDefaults() *GatewayDeleteSubAdmins {
	this := GatewayDeleteSubAdmins{}
	var gatewayUrl string = "http://localhost:8000"
	this.GatewayUrl = &gatewayUrl
	return &this
}

// GetGatewayUrl returns the GatewayUrl field value if set, zero value otherwise.
func (o *GatewayDeleteSubAdmins) GetGatewayUrl() string {
	if o == nil || o.GatewayUrl == nil {
		var ret string
		return ret
	}
	return *o.GatewayUrl
}

// GetGatewayUrlOk returns a tuple with the GatewayUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayDeleteSubAdmins) GetGatewayUrlOk() (*string, bool) {
	if o == nil || o.GatewayUrl == nil {
		return nil, false
	}
	return o.GatewayUrl, true
}

// HasGatewayUrl returns a boolean if a field has been set.
func (o *GatewayDeleteSubAdmins) HasGatewayUrl() bool {
	if o != nil && o.GatewayUrl != nil {
		return true
	}

	return false
}

// SetGatewayUrl gets a reference to the given string and assigns it to the GatewayUrl field.
func (o *GatewayDeleteSubAdmins) SetGatewayUrl(v string) {
	o.GatewayUrl = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *GatewayDeleteSubAdmins) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayDeleteSubAdmins) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *GatewayDeleteSubAdmins) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *GatewayDeleteSubAdmins) SetPassword(v string) {
	o.Password = &v
}

// GetSubAdminId returns the SubAdminId field value
func (o *GatewayDeleteSubAdmins) GetSubAdminId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SubAdminId
}

// GetSubAdminIdOk returns a tuple with the SubAdminId field value
// and a boolean to check if the value has been set.
func (o *GatewayDeleteSubAdmins) GetSubAdminIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SubAdminId, true
}

// SetSubAdminId sets field value
func (o *GatewayDeleteSubAdmins) SetSubAdminId(v string) {
	o.SubAdminId = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayDeleteSubAdmins) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayDeleteSubAdmins) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayDeleteSubAdmins) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayDeleteSubAdmins) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayDeleteSubAdmins) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayDeleteSubAdmins) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayDeleteSubAdmins) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayDeleteSubAdmins) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *GatewayDeleteSubAdmins) GetUsername() string {
	if o == nil || o.Username == nil {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayDeleteSubAdmins) GetUsernameOk() (*string, bool) {
	if o == nil || o.Username == nil {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *GatewayDeleteSubAdmins) HasUsername() bool {
	if o != nil && o.Username != nil {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *GatewayDeleteSubAdmins) SetUsername(v string) {
	o.Username = &v
}

func (o GatewayDeleteSubAdmins) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.GatewayUrl != nil {
		toSerialize["gateway-url"] = o.GatewayUrl
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if true {
		toSerialize["sub-admin-id"] = o.SubAdminId
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Username != nil {
		toSerialize["username"] = o.Username
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayDeleteSubAdmins struct {
	value *GatewayDeleteSubAdmins
	isSet bool
}

func (v NullableGatewayDeleteSubAdmins) Get() *GatewayDeleteSubAdmins {
	return v.value
}

func (v *NullableGatewayDeleteSubAdmins) Set(val *GatewayDeleteSubAdmins) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayDeleteSubAdmins) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayDeleteSubAdmins) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayDeleteSubAdmins(val *GatewayDeleteSubAdmins) *NullableGatewayDeleteSubAdmins {
	return &NullableGatewayDeleteSubAdmins{value: val, isSet: true}
}

func (v NullableGatewayDeleteSubAdmins) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayDeleteSubAdmins) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


