/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.eg;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.hibernate.eg.Edge;

public class Vertex {
    private Set incoming = new HashSet();
    private Set outgoing = new HashSet();
    private String name;
    private long key;
    private int version;
    private Date creationDate = new Date();

    protected Set getIncoming() {
        return this.incoming;
    }

    protected void setIncoming(Set incoming) {
        this.incoming = incoming;
    }

    protected Set getOutgoing() {
        return this.outgoing;
    }

    protected void setOutgoing(Set outgoing) {
        this.outgoing = outgoing;
    }

    public void addIncoming(Edge e) {
        this.incoming.add(e);
        e.setSink(this);
    }

    public void addOutgoing(Edge e) {
        this.outgoing.add(e);
        e.setSource(this);
    }

    public void removeIncoming(Edge e) {
        this.incoming.remove(e);
        e.setSink(null);
    }

    public void removeOutgoing(Edge e) {
        this.outgoing.remove(e);
        e.setSource(null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getExcessCapacity() {
        float excess = 0.0f;
        Iterator i = this.incoming.iterator();
        while (i.hasNext()) {
            excess -= ((Edge)i.next()).getCapacity();
        }
        Iterator i2 = this.outgoing.iterator();
        while (i2.hasNext()) {
            excess += ((Edge)i2.next()).getCapacity();
        }
        return excess;
    }

    public long getKey() {
        return this.key;
    }

    private void setKey(long key) {
        this.key = key;
    }

    public int getVersion() {
        return this.version;
    }

    private void setVersion(int version) {
        this.version = version;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }
}

