/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.Options;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.tools.JavaFileObject;

public abstract class Dependencies {
    protected static final Context.Key<Dependencies> dependenciesKey = new Context.Key();

    public static Dependencies instance(Context context) {
        Dependencies dependencies = context.get(dependenciesKey);
        if (dependencies == null) {
            dependencies = new DummyDependencies(context);
        }
        return dependencies;
    }

    protected Dependencies(Context context) {
        context.put(dependenciesKey, this);
    }

    public abstract void push(Symbol.ClassSymbol var1, CompletionCause var2);

    public abstract void pop();

    private static class DummyDependencies
    extends Dependencies {
        private DummyDependencies(Context context) {
            super(context);
        }

        @Override
        public void push(Symbol.ClassSymbol classSymbol, CompletionCause completionCause) {
        }

        @Override
        public void pop() {
        }
    }

    public static class GraphDependencies
    extends Dependencies
    implements Closeable,
    Symbol.Completer {
        private EnumSet<DependenciesMode> dependenciesModes;
        private String dependenciesFile;
        Stack<Node> nodeStack = new Stack();
        Map<Symbol.ClassSymbol, Node> dependencyNodeMap = new LinkedHashMap<Symbol.ClassSymbol, Node>();

        public static void preRegister(Context context) {
            context.put(dependenciesKey, GraphDependencies::new);
        }

        GraphDependencies(Context context) {
            super(context);
            String[] stringArray;
            Options options = Options.instance(context);
            for (String string : stringArray = options.get("debug.completionDeps").split(",")) {
                if (!string.startsWith("file=")) continue;
                this.dependenciesFile = string.substring(5);
            }
            this.dependenciesModes = DependenciesMode.getDependenciesModes(stringArray);
            JavaCompiler javaCompiler = JavaCompiler.instance(context);
            javaCompiler.closeables = javaCompiler.closeables.prepend(this);
        }

        @Override
        public void push(Symbol.ClassSymbol classSymbol, CompletionCause completionCause) {
            CompletionNode completionNode = new CompletionNode(classSymbol);
            if (completionNode == this.push(completionNode, completionCause)) {
                classSymbol.completer = this;
            }
        }

        protected Node push(Node node, CompletionCause completionCause) {
            Node node2 = this.dependencyNodeMap.get(node.data);
            if (node2 == null) {
                this.dependencyNodeMap.put((Symbol.ClassSymbol)node.data, node);
            } else {
                node = node2;
            }
            if (!this.nodeStack.isEmpty()) {
                Node node3 = this.nodeStack.peek();
                node3.addDependency(completionCause, node);
            }
            this.nodeStack.push(node);
            return node;
        }

        @Override
        public void pop() {
            this.nodeStack.pop();
        }

        @Override
        public void close() throws IOException {
            if (!this.dependenciesModes.contains((Object)DependenciesMode.REDUNDANT)) {
                new PruneVisitor().visit(this.dependencyNodeMap.values(), null);
            }
            if (!this.dependenciesModes.contains((Object)DependenciesMode.CLASS)) {
                new FilterVisitor(CompletionNode.Kind.SOURCE).visit(this.dependencyNodeMap.values(), null);
            }
            if (!this.dependenciesModes.contains((Object)DependenciesMode.SOURCE)) {
                new FilterVisitor(CompletionNode.Kind.CLASS).visit(this.dependencyNodeMap.values(), null);
            }
            if (this.dependenciesFile != null) {
                try (FileWriter fileWriter = new FileWriter(this.dependenciesFile);){
                    fileWriter.append(GraphUtils.toDot(this.dependencyNodeMap.values(), "CompletionDeps", ""));
                }
            }
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            this.push((Symbol.ClassSymbol)symbol, CompletionCause.OTHER);
            this.pop();
            symbol.completer = this;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        public Collection<Node> getNodes() {
            return this.dependencyNodeMap.values();
        }

        private class FilterVisitor
        extends GraphUtils.NodeVisitor<Symbol.ClassSymbol, Node, Void> {
            CompletionNode.Kind ck;

            private FilterVisitor(CompletionNode.Kind kind) {
                this.ck = kind;
            }

            @Override
            public void visitNode(Node node, Void void_) {
                if (node instanceof CompletionNode && ((CompletionNode)node).ck != this.ck) {
                    GraphDependencies.this.dependencyNodeMap.remove(node.data);
                }
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dependencyKind, Node node, Node node2, Void void_) {
                if (node2 instanceof CompletionNode && ((CompletionNode)node2).ck != this.ck) {
                    node.depsByKind.get(dependencyKind).remove(node2);
                }
            }
        }

        private static class PruneVisitor
        extends GraphUtils.NodeVisitor<Symbol.ClassSymbol, Node, Void> {
            private PruneVisitor() {
            }

            @Override
            public void visitNode(Node node, Void void_) {
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dependencyKind, Node node, Node node2, Void void_) {
                if (node.equals(node2)) {
                    node2.depsByKind.get(dependencyKind).remove(node);
                }
            }
        }

        public static class CompletionNode
        extends Node {
            final Kind ck;

            CompletionNode(Symbol.ClassSymbol classSymbol) {
                super(classSymbol);
                boolean bl = classSymbol.classfile == null && classSymbol.sourcefile == null || classSymbol.classfile != null && classSymbol.classfile.getKind() == JavaFileObject.Kind.CLASS;
                this.ck = bl ? Kind.CLASS : Kind.SOURCE;
            }

            @Override
            public Properties nodeAttributes() {
                Properties properties = super.nodeAttributes();
                properties.put("style", this.ck.dotStyle);
                properties.put("shape", "ellipse");
                return properties;
            }

            public Symbol.ClassSymbol getClassSymbol() {
                return (Symbol.ClassSymbol)this.data;
            }

            static enum Kind {
                SOURCE("solid"),
                CLASS("dotted");

                final String dotStyle;

                private Kind(String string2) {
                    this.dotStyle = string2;
                }
            }
        }

        public static abstract class Node
        extends GraphUtils.AbstractNode<Symbol.ClassSymbol, Node>
        implements GraphUtils.DottableNode<Symbol.ClassSymbol, Node> {
            EnumMap<CompletionCause, List<Node>> depsByKind = new EnumMap(CompletionCause.class);

            Node(Symbol.ClassSymbol classSymbol) {
                super(classSymbol);
                for (CompletionCause completionCause : CompletionCause.values()) {
                    this.depsByKind.put(completionCause, new ArrayList());
                }
            }

            void addDependency(GraphUtils.DependencyKind dependencyKind, Node node) {
                List<Node> list = this.depsByKind.get(dependencyKind);
                if (!list.contains(node)) {
                    list.add(node);
                }
            }

            public boolean equals(Object object) {
                return object instanceof Node && ((Symbol.ClassSymbol)this.data).equals(((Node)object).data);
            }

            public int hashCode() {
                return ((Symbol.ClassSymbol)this.data).hashCode();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return CompletionCause.values();
            }

            @Override
            public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dependencyKind) {
                return this.depsByKind.get(dependencyKind);
            }

            @Override
            public Properties nodeAttributes() {
                Properties properties = new Properties();
                properties.put("label", GraphUtils.DotVisitor.wrap(this.toString()));
                return properties;
            }

            @Override
            public Properties dependencyAttributes(Node node, GraphUtils.DependencyKind dependencyKind) {
                Properties properties = new Properties();
                properties.put("label", dependencyKind);
                return properties;
            }

            @Override
            public String toString() {
                return ((Symbol.ClassSymbol)this.data).getQualifiedName().toString();
            }
        }

        static enum DependenciesMode {
            SOURCE("source"),
            CLASS("class"),
            REDUNDANT("redundant");

            final String opt;

            private DependenciesMode(String string2) {
                this.opt = string2;
            }

            static EnumSet<DependenciesMode> getDependenciesModes(String[] stringArray) {
                EnumSet<DependenciesMode> enumSet = EnumSet.noneOf(DependenciesMode.class);
                List<String> list = Arrays.asList(stringArray);
                if (list.contains("all")) {
                    enumSet = EnumSet.allOf(DependenciesMode.class);
                }
                for (DependenciesMode dependenciesMode : DependenciesMode.values()) {
                    if (list.contains(dependenciesMode.opt)) {
                        enumSet.add(dependenciesMode);
                        continue;
                    }
                    if (!list.contains("-" + dependenciesMode.opt)) continue;
                    enumSet.remove((Object)dependenciesMode);
                }
                return enumSet;
            }
        }
    }

    public static enum CompletionCause implements GraphUtils.DependencyKind
    {
        CLASS_READER,
        HEADER_PHASE,
        HIERARCHY_PHASE,
        IMPORTS_PHASE,
        MEMBER_ENTER,
        MEMBERS_PHASE,
        OTHER;

    }
}

