/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery v2.53.3. DO NOT EDIT.

package driver

import (
	context "context"

	csi "github.com/container-storage-interface/spec/lib/go/csi"
	mock "github.com/stretchr/testify/mock"
)

// MockControllerServer is an autogenerated mock type for the ControllerServer type
type MockControllerServer struct {
	mock.Mock
}

type MockControllerServer_Expecter struct {
	mock *mock.Mock
}

func (_m *MockControllerServer) EXPECT() *MockControllerServer_Expecter {
	return &MockControllerServer_Expecter{mock: &_m.Mock}
}

// ControllerExpandVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ControllerExpandVolume(_a0 context.Context, _a1 *csi.ControllerExpandVolumeRequest) (*csi.ControllerExpandVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ControllerExpandVolume")
	}

	var r0 *csi.ControllerExpandVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerExpandVolumeRequest) (*csi.ControllerExpandVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerExpandVolumeRequest) *csi.ControllerExpandVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerExpandVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ControllerExpandVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ControllerExpandVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerExpandVolume'
type MockControllerServer_ControllerExpandVolume_Call struct {
	*mock.Call
}

// ControllerExpandVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ControllerExpandVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerExpandVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_ControllerExpandVolume_Call {
	return &MockControllerServer_ControllerExpandVolume_Call{Call: _e.mock.On("ControllerExpandVolume", _a0, _a1)}
}

func (_c *MockControllerServer_ControllerExpandVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.ControllerExpandVolumeRequest)) *MockControllerServer_ControllerExpandVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ControllerExpandVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_ControllerExpandVolume_Call) Return(_a0 *csi.ControllerExpandVolumeResponse, _a1 error) *MockControllerServer_ControllerExpandVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ControllerExpandVolume_Call) RunAndReturn(run func(context.Context, *csi.ControllerExpandVolumeRequest) (*csi.ControllerExpandVolumeResponse, error)) *MockControllerServer_ControllerExpandVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerGetCapabilities provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ControllerGetCapabilities(_a0 context.Context, _a1 *csi.ControllerGetCapabilitiesRequest) (*csi.ControllerGetCapabilitiesResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ControllerGetCapabilities")
	}

	var r0 *csi.ControllerGetCapabilitiesResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetCapabilitiesRequest) (*csi.ControllerGetCapabilitiesResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetCapabilitiesRequest) *csi.ControllerGetCapabilitiesResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerGetCapabilitiesResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ControllerGetCapabilitiesRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ControllerGetCapabilities_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerGetCapabilities'
type MockControllerServer_ControllerGetCapabilities_Call struct {
	*mock.Call
}

// ControllerGetCapabilities is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ControllerGetCapabilitiesRequest
func (_e *MockControllerServer_Expecter) ControllerGetCapabilities(_a0 interface{}, _a1 interface{}) *MockControllerServer_ControllerGetCapabilities_Call {
	return &MockControllerServer_ControllerGetCapabilities_Call{Call: _e.mock.On("ControllerGetCapabilities", _a0, _a1)}
}

func (_c *MockControllerServer_ControllerGetCapabilities_Call) Run(run func(_a0 context.Context, _a1 *csi.ControllerGetCapabilitiesRequest)) *MockControllerServer_ControllerGetCapabilities_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ControllerGetCapabilitiesRequest))
	})
	return _c
}

func (_c *MockControllerServer_ControllerGetCapabilities_Call) Return(_a0 *csi.ControllerGetCapabilitiesResponse, _a1 error) *MockControllerServer_ControllerGetCapabilities_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ControllerGetCapabilities_Call) RunAndReturn(run func(context.Context, *csi.ControllerGetCapabilitiesRequest) (*csi.ControllerGetCapabilitiesResponse, error)) *MockControllerServer_ControllerGetCapabilities_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerGetVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ControllerGetVolume(_a0 context.Context, _a1 *csi.ControllerGetVolumeRequest) (*csi.ControllerGetVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ControllerGetVolume")
	}

	var r0 *csi.ControllerGetVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetVolumeRequest) (*csi.ControllerGetVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetVolumeRequest) *csi.ControllerGetVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerGetVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ControllerGetVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ControllerGetVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerGetVolume'
type MockControllerServer_ControllerGetVolume_Call struct {
	*mock.Call
}

// ControllerGetVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ControllerGetVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerGetVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_ControllerGetVolume_Call {
	return &MockControllerServer_ControllerGetVolume_Call{Call: _e.mock.On("ControllerGetVolume", _a0, _a1)}
}

func (_c *MockControllerServer_ControllerGetVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.ControllerGetVolumeRequest)) *MockControllerServer_ControllerGetVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ControllerGetVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_ControllerGetVolume_Call) Return(_a0 *csi.ControllerGetVolumeResponse, _a1 error) *MockControllerServer_ControllerGetVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ControllerGetVolume_Call) RunAndReturn(run func(context.Context, *csi.ControllerGetVolumeRequest) (*csi.ControllerGetVolumeResponse, error)) *MockControllerServer_ControllerGetVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerModifyVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ControllerModifyVolume(_a0 context.Context, _a1 *csi.ControllerModifyVolumeRequest) (*csi.ControllerModifyVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ControllerModifyVolume")
	}

	var r0 *csi.ControllerModifyVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerModifyVolumeRequest) (*csi.ControllerModifyVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerModifyVolumeRequest) *csi.ControllerModifyVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerModifyVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ControllerModifyVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ControllerModifyVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerModifyVolume'
type MockControllerServer_ControllerModifyVolume_Call struct {
	*mock.Call
}

// ControllerModifyVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ControllerModifyVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerModifyVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_ControllerModifyVolume_Call {
	return &MockControllerServer_ControllerModifyVolume_Call{Call: _e.mock.On("ControllerModifyVolume", _a0, _a1)}
}

func (_c *MockControllerServer_ControllerModifyVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.ControllerModifyVolumeRequest)) *MockControllerServer_ControllerModifyVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ControllerModifyVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_ControllerModifyVolume_Call) Return(_a0 *csi.ControllerModifyVolumeResponse, _a1 error) *MockControllerServer_ControllerModifyVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ControllerModifyVolume_Call) RunAndReturn(run func(context.Context, *csi.ControllerModifyVolumeRequest) (*csi.ControllerModifyVolumeResponse, error)) *MockControllerServer_ControllerModifyVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerPublishVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ControllerPublishVolume(_a0 context.Context, _a1 *csi.ControllerPublishVolumeRequest) (*csi.ControllerPublishVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ControllerPublishVolume")
	}

	var r0 *csi.ControllerPublishVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerPublishVolumeRequest) (*csi.ControllerPublishVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerPublishVolumeRequest) *csi.ControllerPublishVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerPublishVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ControllerPublishVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ControllerPublishVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerPublishVolume'
type MockControllerServer_ControllerPublishVolume_Call struct {
	*mock.Call
}

// ControllerPublishVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ControllerPublishVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerPublishVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_ControllerPublishVolume_Call {
	return &MockControllerServer_ControllerPublishVolume_Call{Call: _e.mock.On("ControllerPublishVolume", _a0, _a1)}
}

func (_c *MockControllerServer_ControllerPublishVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.ControllerPublishVolumeRequest)) *MockControllerServer_ControllerPublishVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ControllerPublishVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_ControllerPublishVolume_Call) Return(_a0 *csi.ControllerPublishVolumeResponse, _a1 error) *MockControllerServer_ControllerPublishVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ControllerPublishVolume_Call) RunAndReturn(run func(context.Context, *csi.ControllerPublishVolumeRequest) (*csi.ControllerPublishVolumeResponse, error)) *MockControllerServer_ControllerPublishVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerUnpublishVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ControllerUnpublishVolume(_a0 context.Context, _a1 *csi.ControllerUnpublishVolumeRequest) (*csi.ControllerUnpublishVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ControllerUnpublishVolume")
	}

	var r0 *csi.ControllerUnpublishVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerUnpublishVolumeRequest) (*csi.ControllerUnpublishVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ControllerUnpublishVolumeRequest) *csi.ControllerUnpublishVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerUnpublishVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ControllerUnpublishVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ControllerUnpublishVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerUnpublishVolume'
type MockControllerServer_ControllerUnpublishVolume_Call struct {
	*mock.Call
}

// ControllerUnpublishVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ControllerUnpublishVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerUnpublishVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_ControllerUnpublishVolume_Call {
	return &MockControllerServer_ControllerUnpublishVolume_Call{Call: _e.mock.On("ControllerUnpublishVolume", _a0, _a1)}
}

func (_c *MockControllerServer_ControllerUnpublishVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.ControllerUnpublishVolumeRequest)) *MockControllerServer_ControllerUnpublishVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ControllerUnpublishVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_ControllerUnpublishVolume_Call) Return(_a0 *csi.ControllerUnpublishVolumeResponse, _a1 error) *MockControllerServer_ControllerUnpublishVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ControllerUnpublishVolume_Call) RunAndReturn(run func(context.Context, *csi.ControllerUnpublishVolumeRequest) (*csi.ControllerUnpublishVolumeResponse, error)) *MockControllerServer_ControllerUnpublishVolume_Call {
	_c.Call.Return(run)
	return _c
}

// CreateSnapshot provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) CreateSnapshot(_a0 context.Context, _a1 *csi.CreateSnapshotRequest) (*csi.CreateSnapshotResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for CreateSnapshot")
	}

	var r0 *csi.CreateSnapshotResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.CreateSnapshotRequest) (*csi.CreateSnapshotResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.CreateSnapshotRequest) *csi.CreateSnapshotResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.CreateSnapshotResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.CreateSnapshotRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_CreateSnapshot_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateSnapshot'
type MockControllerServer_CreateSnapshot_Call struct {
	*mock.Call
}

// CreateSnapshot is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.CreateSnapshotRequest
func (_e *MockControllerServer_Expecter) CreateSnapshot(_a0 interface{}, _a1 interface{}) *MockControllerServer_CreateSnapshot_Call {
	return &MockControllerServer_CreateSnapshot_Call{Call: _e.mock.On("CreateSnapshot", _a0, _a1)}
}

func (_c *MockControllerServer_CreateSnapshot_Call) Run(run func(_a0 context.Context, _a1 *csi.CreateSnapshotRequest)) *MockControllerServer_CreateSnapshot_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.CreateSnapshotRequest))
	})
	return _c
}

func (_c *MockControllerServer_CreateSnapshot_Call) Return(_a0 *csi.CreateSnapshotResponse, _a1 error) *MockControllerServer_CreateSnapshot_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_CreateSnapshot_Call) RunAndReturn(run func(context.Context, *csi.CreateSnapshotRequest) (*csi.CreateSnapshotResponse, error)) *MockControllerServer_CreateSnapshot_Call {
	_c.Call.Return(run)
	return _c
}

// CreateVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) CreateVolume(_a0 context.Context, _a1 *csi.CreateVolumeRequest) (*csi.CreateVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for CreateVolume")
	}

	var r0 *csi.CreateVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.CreateVolumeRequest) (*csi.CreateVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.CreateVolumeRequest) *csi.CreateVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.CreateVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.CreateVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_CreateVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateVolume'
type MockControllerServer_CreateVolume_Call struct {
	*mock.Call
}

// CreateVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.CreateVolumeRequest
func (_e *MockControllerServer_Expecter) CreateVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_CreateVolume_Call {
	return &MockControllerServer_CreateVolume_Call{Call: _e.mock.On("CreateVolume", _a0, _a1)}
}

func (_c *MockControllerServer_CreateVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.CreateVolumeRequest)) *MockControllerServer_CreateVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.CreateVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_CreateVolume_Call) Return(_a0 *csi.CreateVolumeResponse, _a1 error) *MockControllerServer_CreateVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_CreateVolume_Call) RunAndReturn(run func(context.Context, *csi.CreateVolumeRequest) (*csi.CreateVolumeResponse, error)) *MockControllerServer_CreateVolume_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteSnapshot provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) DeleteSnapshot(_a0 context.Context, _a1 *csi.DeleteSnapshotRequest) (*csi.DeleteSnapshotResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for DeleteSnapshot")
	}

	var r0 *csi.DeleteSnapshotResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.DeleteSnapshotRequest) (*csi.DeleteSnapshotResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.DeleteSnapshotRequest) *csi.DeleteSnapshotResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.DeleteSnapshotResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.DeleteSnapshotRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_DeleteSnapshot_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteSnapshot'
type MockControllerServer_DeleteSnapshot_Call struct {
	*mock.Call
}

// DeleteSnapshot is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.DeleteSnapshotRequest
func (_e *MockControllerServer_Expecter) DeleteSnapshot(_a0 interface{}, _a1 interface{}) *MockControllerServer_DeleteSnapshot_Call {
	return &MockControllerServer_DeleteSnapshot_Call{Call: _e.mock.On("DeleteSnapshot", _a0, _a1)}
}

func (_c *MockControllerServer_DeleteSnapshot_Call) Run(run func(_a0 context.Context, _a1 *csi.DeleteSnapshotRequest)) *MockControllerServer_DeleteSnapshot_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.DeleteSnapshotRequest))
	})
	return _c
}

func (_c *MockControllerServer_DeleteSnapshot_Call) Return(_a0 *csi.DeleteSnapshotResponse, _a1 error) *MockControllerServer_DeleteSnapshot_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_DeleteSnapshot_Call) RunAndReturn(run func(context.Context, *csi.DeleteSnapshotRequest) (*csi.DeleteSnapshotResponse, error)) *MockControllerServer_DeleteSnapshot_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteVolume provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) DeleteVolume(_a0 context.Context, _a1 *csi.DeleteVolumeRequest) (*csi.DeleteVolumeResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for DeleteVolume")
	}

	var r0 *csi.DeleteVolumeResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.DeleteVolumeRequest) (*csi.DeleteVolumeResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.DeleteVolumeRequest) *csi.DeleteVolumeResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.DeleteVolumeResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.DeleteVolumeRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_DeleteVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteVolume'
type MockControllerServer_DeleteVolume_Call struct {
	*mock.Call
}

// DeleteVolume is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.DeleteVolumeRequest
func (_e *MockControllerServer_Expecter) DeleteVolume(_a0 interface{}, _a1 interface{}) *MockControllerServer_DeleteVolume_Call {
	return &MockControllerServer_DeleteVolume_Call{Call: _e.mock.On("DeleteVolume", _a0, _a1)}
}

func (_c *MockControllerServer_DeleteVolume_Call) Run(run func(_a0 context.Context, _a1 *csi.DeleteVolumeRequest)) *MockControllerServer_DeleteVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.DeleteVolumeRequest))
	})
	return _c
}

func (_c *MockControllerServer_DeleteVolume_Call) Return(_a0 *csi.DeleteVolumeResponse, _a1 error) *MockControllerServer_DeleteVolume_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_DeleteVolume_Call) RunAndReturn(run func(context.Context, *csi.DeleteVolumeRequest) (*csi.DeleteVolumeResponse, error)) *MockControllerServer_DeleteVolume_Call {
	_c.Call.Return(run)
	return _c
}

// GetCapacity provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) GetCapacity(_a0 context.Context, _a1 *csi.GetCapacityRequest) (*csi.GetCapacityResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for GetCapacity")
	}

	var r0 *csi.GetCapacityResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.GetCapacityRequest) (*csi.GetCapacityResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.GetCapacityRequest) *csi.GetCapacityResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.GetCapacityResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.GetCapacityRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_GetCapacity_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetCapacity'
type MockControllerServer_GetCapacity_Call struct {
	*mock.Call
}

// GetCapacity is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.GetCapacityRequest
func (_e *MockControllerServer_Expecter) GetCapacity(_a0 interface{}, _a1 interface{}) *MockControllerServer_GetCapacity_Call {
	return &MockControllerServer_GetCapacity_Call{Call: _e.mock.On("GetCapacity", _a0, _a1)}
}

func (_c *MockControllerServer_GetCapacity_Call) Run(run func(_a0 context.Context, _a1 *csi.GetCapacityRequest)) *MockControllerServer_GetCapacity_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.GetCapacityRequest))
	})
	return _c
}

func (_c *MockControllerServer_GetCapacity_Call) Return(_a0 *csi.GetCapacityResponse, _a1 error) *MockControllerServer_GetCapacity_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_GetCapacity_Call) RunAndReturn(run func(context.Context, *csi.GetCapacityRequest) (*csi.GetCapacityResponse, error)) *MockControllerServer_GetCapacity_Call {
	_c.Call.Return(run)
	return _c
}

// ListSnapshots provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ListSnapshots(_a0 context.Context, _a1 *csi.ListSnapshotsRequest) (*csi.ListSnapshotsResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ListSnapshots")
	}

	var r0 *csi.ListSnapshotsResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ListSnapshotsRequest) (*csi.ListSnapshotsResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ListSnapshotsRequest) *csi.ListSnapshotsResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ListSnapshotsResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ListSnapshotsRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ListSnapshots_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListSnapshots'
type MockControllerServer_ListSnapshots_Call struct {
	*mock.Call
}

// ListSnapshots is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ListSnapshotsRequest
func (_e *MockControllerServer_Expecter) ListSnapshots(_a0 interface{}, _a1 interface{}) *MockControllerServer_ListSnapshots_Call {
	return &MockControllerServer_ListSnapshots_Call{Call: _e.mock.On("ListSnapshots", _a0, _a1)}
}

func (_c *MockControllerServer_ListSnapshots_Call) Run(run func(_a0 context.Context, _a1 *csi.ListSnapshotsRequest)) *MockControllerServer_ListSnapshots_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ListSnapshotsRequest))
	})
	return _c
}

func (_c *MockControllerServer_ListSnapshots_Call) Return(_a0 *csi.ListSnapshotsResponse, _a1 error) *MockControllerServer_ListSnapshots_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ListSnapshots_Call) RunAndReturn(run func(context.Context, *csi.ListSnapshotsRequest) (*csi.ListSnapshotsResponse, error)) *MockControllerServer_ListSnapshots_Call {
	_c.Call.Return(run)
	return _c
}

// ListVolumes provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ListVolumes(_a0 context.Context, _a1 *csi.ListVolumesRequest) (*csi.ListVolumesResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ListVolumes")
	}

	var r0 *csi.ListVolumesResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ListVolumesRequest) (*csi.ListVolumesResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ListVolumesRequest) *csi.ListVolumesResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ListVolumesResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ListVolumesRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ListVolumes_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListVolumes'
type MockControllerServer_ListVolumes_Call struct {
	*mock.Call
}

// ListVolumes is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ListVolumesRequest
func (_e *MockControllerServer_Expecter) ListVolumes(_a0 interface{}, _a1 interface{}) *MockControllerServer_ListVolumes_Call {
	return &MockControllerServer_ListVolumes_Call{Call: _e.mock.On("ListVolumes", _a0, _a1)}
}

func (_c *MockControllerServer_ListVolumes_Call) Run(run func(_a0 context.Context, _a1 *csi.ListVolumesRequest)) *MockControllerServer_ListVolumes_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ListVolumesRequest))
	})
	return _c
}

func (_c *MockControllerServer_ListVolumes_Call) Return(_a0 *csi.ListVolumesResponse, _a1 error) *MockControllerServer_ListVolumes_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ListVolumes_Call) RunAndReturn(run func(context.Context, *csi.ListVolumesRequest) (*csi.ListVolumesResponse, error)) *MockControllerServer_ListVolumes_Call {
	_c.Call.Return(run)
	return _c
}

// ValidateVolumeCapabilities provides a mock function with given fields: _a0, _a1
func (_m *MockControllerServer) ValidateVolumeCapabilities(_a0 context.Context, _a1 *csi.ValidateVolumeCapabilitiesRequest) (*csi.ValidateVolumeCapabilitiesResponse, error) {
	ret := _m.Called(_a0, _a1)

	if len(ret) == 0 {
		panic("no return value specified for ValidateVolumeCapabilities")
	}

	var r0 *csi.ValidateVolumeCapabilitiesResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) (*csi.ValidateVolumeCapabilitiesResponse, error)); ok {
		return rf(_a0, _a1)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) *csi.ValidateVolumeCapabilitiesResponse); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ValidateVolumeCapabilitiesResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockControllerServer_ValidateVolumeCapabilities_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ValidateVolumeCapabilities'
type MockControllerServer_ValidateVolumeCapabilities_Call struct {
	*mock.Call
}

// ValidateVolumeCapabilities is a helper method to define mock.On call
//   - _a0 context.Context
//   - _a1 *csi.ValidateVolumeCapabilitiesRequest
func (_e *MockControllerServer_Expecter) ValidateVolumeCapabilities(_a0 interface{}, _a1 interface{}) *MockControllerServer_ValidateVolumeCapabilities_Call {
	return &MockControllerServer_ValidateVolumeCapabilities_Call{Call: _e.mock.On("ValidateVolumeCapabilities", _a0, _a1)}
}

func (_c *MockControllerServer_ValidateVolumeCapabilities_Call) Run(run func(_a0 context.Context, _a1 *csi.ValidateVolumeCapabilitiesRequest)) *MockControllerServer_ValidateVolumeCapabilities_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*csi.ValidateVolumeCapabilitiesRequest))
	})
	return _c
}

func (_c *MockControllerServer_ValidateVolumeCapabilities_Call) Return(_a0 *csi.ValidateVolumeCapabilitiesResponse, _a1 error) *MockControllerServer_ValidateVolumeCapabilities_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockControllerServer_ValidateVolumeCapabilities_Call) RunAndReturn(run func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) (*csi.ValidateVolumeCapabilitiesResponse, error)) *MockControllerServer_ValidateVolumeCapabilities_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockControllerServer creates a new instance of MockControllerServer. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockControllerServer(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockControllerServer {
	mock := &MockControllerServer{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
