/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaInstance;
import sun.jvm.hotspot.utilities.soql.JSList;

public class JSJavaThread
extends JSJavaInstance {
    private JavaThread jthread;
    private JSList framesCache;
    private JSList monitorsCache;

    public JSJavaThread(Instance threadOop, JSJavaFactory fac) {
        super(threadOop, fac);
        this.jthread = OopUtilities.threadOopGetJavaThread(threadOop);
    }

    public JSJavaThread(JavaThread jt, JSJavaFactory fac) {
        super((Instance)jt.getThreadObj(), fac);
        this.jthread = jt;
    }

    @Override
    public String toString() {
        String name = this.getName();
        StringBuffer buf = new StringBuffer();
        buf.append("Thread (address=");
        buf.append(this.getOop().getHandle());
        buf.append(", name=");
        if (name != null) {
            buf.append(name);
        } else {
            buf.append("<unnamed>");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    protected Object getFieldValue(String name) {
        if (name.equals("name")) {
            return this.getName();
        }
        if (name.equals("frames")) {
            return this.getFrames();
        }
        if (name.equals("monitors")) {
            return this.getOwnedMonitors();
        }
        return super.getFieldValue(name);
    }

    @Override
    protected String[] getFieldNames() {
        String[] flds = super.getFieldNames();
        String[] res = new String[flds.length + 2];
        System.arraycopy(flds, 0, res, 0, flds.length);
        res[flds.length] = "frames";
        res[flds.length + 1] = "monitors";
        return res;
    }

    @Override
    protected boolean hasField(String name) {
        if (name.equals("frames") || name.equals("monitors")) {
            return true;
        }
        return super.hasField(name);
    }

    private String getName() {
        return OopUtilities.threadOopGetName(this.getOop());
    }

    private synchronized JSList getFrames() {
        if (this.framesCache == null) {
            ArrayList<JavaVFrame> list = new ArrayList<JavaVFrame>(0);
            if (this.jthread != null) {
                for (JavaVFrame jvf = this.jthread.getLastJavaVFrameDbg(); jvf != null; jvf = jvf.javaSender()) {
                    list.add(jvf);
                }
            }
            this.framesCache = this.factory.newJSList(list);
        }
        return this.framesCache;
    }

    private synchronized JSList getOwnedMonitors() {
        if (this.monitorsCache == null) {
            ArrayList<Oop> ownedMonitors = new ArrayList<Oop>(0);
            if (this.jthread != null) {
                ArrayList<OopHandle> lockedObjects = new ArrayList<OopHandle>();
                ObjectMonitor waitingMonitor = this.jthread.getCurrentWaitingMonitor();
                OopHandle waitingObj = null;
                if (waitingMonitor != null) {
                    waitingObj = waitingMonitor.object();
                }
                ObjectMonitor pendingMonitor = this.jthread.getCurrentPendingMonitor();
                OopHandle pendingObj = null;
                if (pendingMonitor != null) {
                    pendingObj = pendingMonitor.object();
                }
                for (JavaVFrame frame = this.jthread.getLastJavaVFrameDbg(); frame != null; frame = frame.javaSender()) {
                    List frameMonitors = frame.getMonitors();
                    for (MonitorInfo mi : frameMonitors) {
                        OopHandle obj;
                        if (mi.eliminated() && frame.isCompiledFrame() || (obj = mi.owner()) == null || obj.equals(waitingObj) || obj.equals(pendingObj)) continue;
                        boolean found = false;
                        Iterator loItr = lockedObjects.iterator();
                        while (loItr.hasNext()) {
                            if (!obj.equals(loItr.next())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        lockedObjects.add(obj);
                    }
                }
                ObjectHeap heap = VM.getVM().getObjectHeap();
                Iterator loItr = lockedObjects.iterator();
                while (loItr.hasNext()) {
                    ownedMonitors.add(heap.newOop((OopHandle)loItr.next()));
                }
            }
            this.monitorsCache = this.factory.newJSList(ownedMonitors);
        }
        return this.monitorsCache;
    }
}

