/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ScrollPanePeer;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.PlatformComponent;

final class LWScrollPanePeer
extends LWContainerPeer<ScrollPane, JScrollPane>
implements ScrollPanePeer,
ChangeListener {
    LWScrollPanePeer(ScrollPane scrollPane, PlatformComponent platformComponent) {
        super(scrollPane, platformComponent);
    }

    @Override
    JScrollPane createDelegate() {
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setVisible(false);
        jScrollPane.getViewport().setView(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().addChangeListener(this);
        return jScrollPane;
    }

    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            if (((ScrollPane)this.getTarget()).isWheelScrollingEnabled() && mouseWheelEvent.isConsumed()) {
                this.sendEventToDelegate(mouseWheelEvent);
            }
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LWComponentPeer<?, ?> lWComponentPeer = LWScrollPanePeer.this.getViewPeer();
                if (lWComponentPeer != null) {
                    Rectangle rectangle;
                    Object object = LWScrollPanePeer.this.getDelegateLock();
                    synchronized (object) {
                        rectangle = ((JScrollPane)LWScrollPanePeer.this.getDelegate()).getViewport().getView().getBounds();
                    }
                    lWComponentPeer.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 3, true, true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        int n = ((ScrollPane)this.getTarget()).getScrollbarDisplayPolicy();
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((JScrollPane)this.getDelegate()).getViewport().setScrollMode(0);
            ((JScrollPane)this.getDelegate()).setVerticalScrollBarPolicy(LWScrollPanePeer.convertVPolicy(n));
            ((JScrollPane)this.getDelegate()).setHorizontalScrollBarPolicy(LWScrollPanePeer.convertHPolicy(n));
        }
    }

    LWComponentPeer<?, ?> getViewPeer() {
        List<LWComponentPeer<?, ?>> list = this.getChildren();
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    Rectangle getContentSize() {
        Rectangle rectangle = ((JScrollPane)this.getDelegate()).getViewport().getViewRect();
        return new Rectangle(rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout() {
        super.layout();
        Object object = this.getDelegateLock();
        synchronized (object) {
            LWComponentPeer<?, ?> lWComponentPeer = this.getViewPeer();
            if (lWComponentPeer != null) {
                Component component = ((JScrollPane)this.getDelegate()).getViewport().getView();
                component.setBounds(lWComponentPeer.getBounds());
                component.setPreferredSize(lWComponentPeer.getPreferredSize());
                component.setMinimumSize(lWComponentPeer.getMinimumSize());
                ((JScrollPane)this.getDelegate()).invalidate();
                ((JScrollPane)this.getDelegate()).validate();
                lWComponentPeer.setBounds(component.getBounds());
            }
        }
    }

    @Override
    public void setScrollPosition(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHScrollbarHeight() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((JScrollPane)this.getDelegate()).getHorizontalScrollBar().getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVScrollbarWidth() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((JScrollPane)this.getDelegate()).getVerticalScrollBar().getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void childResized(int n, int n2) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((JScrollPane)this.getDelegate()).invalidate();
            ((JScrollPane)this.getDelegate()).validate();
        }
    }

    @Override
    public void setUnitIncrement(Adjustable adjustable, int n) {
    }

    @Override
    public void setValue(Adjustable adjustable, int n) {
    }

    private static int convertHPolicy(int n) {
        switch (n) {
            case 2: {
                return 31;
            }
            case 1: {
                return 32;
            }
        }
        return 30;
    }

    private static int convertVPolicy(int n) {
        switch (n) {
            case 2: {
                return 21;
            }
            case 1: {
                return 22;
            }
        }
        return 20;
    }
}

