/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;

public class AquaIcon {
    static UIResource getIconFor(final JRSUIControlSpec jRSUIControlSpec, int n, int n2) {
        return new ScalingJRSUIIcon(n, n2){

            @Override
            public void initIconPainter(AquaPainter<JRSUIState> aquaPainter) {
                jRSUIControlSpec.initIconPainter(aquaPainter);
            }
        };
    }

    public static Image getImageForIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    static class SystemIcon
    extends CachingScalingIcon {
        private static final SystemIconUIResourceSingleton folderIcon = new SystemIconUIResourceSingleton("fldr");
        private static final SystemIconUIResourceSingleton openFolderIcon = new SystemIconUIResourceSingleton("ofld");
        private static final SystemIconUIResourceSingleton desktopIcon = new SystemIconUIResourceSingleton("desk");
        private static final SystemIconUIResourceSingleton computerIcon = new SystemIconUIResourceSingleton("FNDR");
        private static final SystemIconUIResourceSingleton documentIcon = new SystemIconUIResourceSingleton("docu");
        private static final SystemIconUIResourceSingleton hardDriveIcon = new SystemIconUIResourceSingleton("hdsk");
        private static final SystemIconUIResourceSingleton floppyIcon = new SystemIconUIResourceSingleton("flpy");
        private static final SystemIconSingleton caut = new SystemIconSingleton("caut");
        private static final SystemIconSingleton stop = new SystemIconSingleton("stop");
        final String selector;

        static IconUIResource getFolderIconUIResource() {
            return (IconUIResource)folderIcon.get();
        }

        static IconUIResource getOpenFolderIconUIResource() {
            return (IconUIResource)openFolderIcon.get();
        }

        static IconUIResource getDesktopIconUIResource() {
            return (IconUIResource)desktopIcon.get();
        }

        static IconUIResource getComputerIconUIResource() {
            return (IconUIResource)computerIcon.get();
        }

        static IconUIResource getDocumentIconUIResource() {
            return (IconUIResource)documentIcon.get();
        }

        static IconUIResource getHardDriveIconUIResource() {
            return (IconUIResource)hardDriveIcon.get();
        }

        static IconUIResource getFloppyIconUIResource() {
            return (IconUIResource)floppyIcon.get();
        }

        static SystemIcon getCautionIcon() {
            return (SystemIcon)caut.get();
        }

        static SystemIcon getStopIcon() {
            return (SystemIcon)stop.get();
        }

        public SystemIcon(String string, int n, int n2) {
            super(n, n2);
            this.selector = string;
        }

        public SystemIcon(String string) {
            this(string, 16, 16);
        }

        @Override
        Image createImage() {
            return AquaUtils.getCImageCreator().createSystemImageFromSelector(this.selector, this.getIconWidth(), this.getIconHeight());
        }
    }

    static class SystemIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final String selector;

        public SystemIconUIResourceSingleton(String string) {
            this.selector = string;
        }

        @Override
        protected IconUIResource getInstance() {
            return new IconUIResource(new SystemIcon(this.selector));
        }
    }

    static class SystemIconSingleton
    extends AquaUtils.RecyclableSingleton<SystemIcon> {
        final String selector;

        public SystemIconSingleton(String string) {
            this.selector = string;
        }

        @Override
        protected SystemIcon getInstance() {
            return new SystemIcon(this.selector);
        }
    }

    static class FileIcon
    extends CachingScalingIcon {
        final File file;

        public FileIcon(File file, int n, int n2) {
            super(n, n2);
            this.file = file;
        }

        public FileIcon(File file) {
            this(file, 16, 16);
        }

        @Override
        Image createImage() {
            return AquaUtils.getCImageCreator().createImageOfFile(this.file.getAbsolutePath(), this.getIconWidth(), this.getIconHeight());
        }
    }

    static abstract class ScalingJRSUIIcon
    implements Icon,
    UIResource {
        final int width;
        final int height;

        public ScalingJRSUIIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            AquaPainter<JRSUIState> aquaPainter = AquaPainter.create(JRSUIState.getInstance());
            this.initIconPainter(aquaPainter);
            graphics.clipRect(n, n2, this.width, this.height);
            aquaPainter.paint(graphics, component, n, n2, this.width, this.height);
            graphics.dispose();
        }

        public abstract void initIconPainter(AquaPainter<JRSUIState> var1);

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    static abstract class CachingScalingIcon
    implements Icon,
    UIResource {
        int width;
        int height;
        Image image;

        public CachingScalingIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        void setSize(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.image = null;
        }

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.image = this.createImage();
            }
            return this.image;
        }

        abstract Image createImage();

        public boolean hasIconRef() {
            return this.getImage() != null;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Image image;
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            if ((image = this.getImage()) != null) {
                graphics.drawImage(image, n, n2, this.getIconWidth(), this.getIconHeight(), null);
            }
            graphics.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    static abstract class DynamicallySizingJRSUIIcon
    extends JRSUIIcon {
        protected final AquaUtilControlSize.SizeDescriptor sizeDescriptor;
        protected AquaUtilControlSize.SizeVariant sizeVariant;

        public DynamicallySizingJRSUIIcon(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            this.sizeDescriptor = sizeDescriptor;
            this.sizeVariant = sizeDescriptor.regular;
            this.initJRSUIState();
        }

        public abstract void initJRSUIState();

        @Override
        public int getIconHeight() {
            return this.sizeVariant == null ? 0 : this.sizeVariant.h;
        }

        @Override
        public int getIconWidth() {
            return this.sizeVariant == null ? 0 : this.sizeVariant.w;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JRSUIConstants.Size size = component instanceof JComponent ? AquaUtilControlSize.getUserSizeFrom((JComponent)component) : JRSUIConstants.Size.REGULAR;
            this.sizeVariant = this.sizeDescriptor.get(size);
            ((JRSUIState)this.painter.state).set(size);
            super.paintIcon(component, graphics, n, n2);
        }
    }

    static abstract class JRSUIIcon
    implements Icon,
    UIResource {
        protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());

        JRSUIIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.painter.paint(graphics, component, n, n2, this.getIconWidth(), this.getIconHeight());
        }
    }

    public static interface JRSUIControlSpec {
        public void initIconPainter(AquaPainter<? extends JRSUIState> var1);
    }

    static interface InvertableIcon
    extends Icon {
        public Icon getInvertedIcon();
    }
}

