/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundName
implements Name {
    private static final long serialVersionUID = 3513100557083972036L;
    private static final String SEPARATOR = "jndi.syntax.separator";
    private static final String SEPARATOR_AVA = "jndi.syntax.separator.ava";
    private static final String SEPARATOR_TYPEVAL = "jndi.syntax.separator.typeval";
    private static final String ESCAPE = "jndi.syntax.escape";
    private static final String BEGIN_QUOTE = "jndi.syntax.beginquote";
    private static final String END_QUOTE = "jndi.syntax.endquote";
    private static final String BEGIN_QUOTE2 = "jndi.syntax.beginquote2";
    private static final String END_QUOTE2 = "jndi.syntax.endquote2";
    private static final String IGNORE_CASE = "jndi.syntax.ignorecase";
    private static final String TRIM_BLANKS = "jndi.syntax.trimblanks";
    private static final String DIRECTION = "jndi.syntax.direction";
    private static final String SEPARATOR2 = "jndi.syntax.separator2";
    private static final String LEFT_TO_RIGHT = "left_to_right";
    private static final String RIGHT_TO_LEFT = "right_to_left";
    private static final String FLAT = "flat";
    private static final String NULL_STRING = "";
    private static final int NORMAL_STATUS = 0;
    private static final int QUOTE1_STATUS = 1;
    private static final int QUOTE2_STATUS = 2;
    private static final int INIT_STATUS = 3;
    private static final int QUOTEEND_STATUS = 4;
    private transient String separatorString;
    private transient String separatorString2;
    private transient String escapeString;
    private transient String endQuoteString;
    private transient String endQuoteString2;
    private transient String beginQuoteString;
    private transient String beginQuoteString2;
    private transient String sepAvaString;
    private transient String sepTypeValString;
    private transient String direction;
    private transient boolean trimBlanks;
    private transient boolean ignoreCase;
    private transient boolean flat;
    private transient Vector<String> elem;
    protected transient Properties mySyntax;
    protected transient NameImpl impl = new NameImpl();

    protected CompoundName(Enumeration<String> elements, Properties props) {
        if (props == null || elements == null) {
            throw new NullPointerException();
        }
        this.init(props);
        this.elem = new Vector();
        while (elements.hasMoreElements()) {
            this.elem.add(elements.nextElement());
        }
    }

    public CompoundName(String s, Properties props) throws InvalidNameException {
        if (s == null || props == null) {
            throw new NullPointerException();
        }
        this.init(props);
        this.parseName(s);
    }

    private void init(Properties props) {
        this.trimBlanks = false;
        this.ignoreCase = false;
        this.mySyntax = props;
        String property = props.getProperty(DIRECTION);
        String string = this.direction = property == null ? FLAT : property;
        if (!(LEFT_TO_RIGHT.equals(this.direction) || RIGHT_TO_LEFT.equals(this.direction) || FLAT.equals(this.direction))) {
            throw new IllegalArgumentException(Messages.getString("jndi.04"));
        }
        this.flat = FLAT.equals(this.direction);
        String string2 = this.separatorString = this.flat ? NULL_STRING : props.getProperty(SEPARATOR);
        if (this.separatorString == null && !this.flat) {
            throw new IllegalArgumentException(Messages.getString("jndi.05"));
        }
        this.separatorString2 = this.flat || (property = props.getProperty(SEPARATOR2)) == null ? NULL_STRING : property;
        property = props.getProperty(IGNORE_CASE);
        this.ignoreCase = property == null ? false : Boolean.valueOf(property);
        property = props.getProperty(TRIM_BLANKS);
        this.trimBlanks = property == null ? false : Boolean.valueOf(property);
        property = props.getProperty(ESCAPE);
        this.escapeString = property == null ? NULL_STRING : property;
        property = props.getProperty(BEGIN_QUOTE);
        this.beginQuoteString = property == null ? NULL_STRING : property;
        property = props.getProperty(BEGIN_QUOTE2);
        this.beginQuoteString2 = property == null ? NULL_STRING : property;
        property = props.getProperty(END_QUOTE);
        String string3 = this.endQuoteString = property == null ? this.beginQuoteString : property;
        if (NULL_STRING.equals(this.beginQuoteString)) {
            this.beginQuoteString = this.endQuoteString;
        }
        String string4 = this.endQuoteString2 = (property = props.getProperty(END_QUOTE2)) == null ? this.beginQuoteString2 : property;
        if (NULL_STRING.equals(this.beginQuoteString2)) {
            this.beginQuoteString2 = this.endQuoteString2;
        }
        this.sepTypeValString = (property = props.getProperty(SEPARATOR_TYPEVAL)) == null ? NULL_STRING : property;
        property = props.getProperty(SEPARATOR_AVA);
        this.sepAvaString = property == null ? NULL_STRING : property;
    }

    private void parseName(String s) throws InvalidNameException {
        this.elem = new Vector();
        if (NULL_STRING.equals(s)) {
            return;
        }
        int status = 3;
        StringBuilder element = new StringBuilder();
        int pos = 0;
        int length = s.length();
        boolean hasNotNullElement = false;
        boolean includeQuote = false;
        while (pos < length) {
            if (this.startsWithFromPos(s, pos, this.endQuoteString) && status == 1) {
                status = 4;
                pos += this.addBuffer(element, this.endQuoteString, includeQuote);
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.endQuoteString2) && status == 2) {
                status = 4;
                pos += this.addBuffer(element, this.endQuoteString2, includeQuote);
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.beginQuoteString) && status == 3) {
                hasNotNullElement = true;
                status = 1;
                pos += this.addBuffer(element, this.beginQuoteString, includeQuote);
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.beginQuoteString2) && status == 3) {
                hasNotNullElement = true;
                status = 2;
                pos += this.addBuffer(element, this.beginQuoteString2, includeQuote);
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.separatorString) && !this.flat && (status == 3 || status == 4 || status == 0)) {
                hasNotNullElement = hasNotNullElement || element.length() > 0;
                this.addElement(element);
                status = 3;
                pos += this.separatorString.length();
                includeQuote = false;
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.separatorString2) && !this.flat && (status == 3 || status == 4 || status == 0)) {
                hasNotNullElement = hasNotNullElement || element.length() > 0;
                this.addElement(element);
                status = 3;
                pos += this.separatorString2.length();
                includeQuote = false;
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.escapeString)) {
                if ((pos += this.escapeString.length()) == s.length()) {
                    throw new InvalidNameException(Messages.getString("jndi.06", this.escapeString));
                }
                String str = this.extractEscapedString(s, pos, status);
                if (str == null) {
                    pos -= this.escapeString.length();
                    element.append(s.charAt(pos++));
                    continue;
                }
                pos += str.length();
                element.append(str);
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.sepTypeValString) && (status == 3 || status == 0)) {
                includeQuote = true;
                pos += this.addBuffer(element, this.sepTypeValString, true);
                status = 3;
                continue;
            }
            if (this.startsWithFromPos(s, pos, this.sepAvaString) && (status == 3 || status == 0)) {
                includeQuote = true;
                pos += this.addBuffer(element, this.sepAvaString, true);
                status = 3;
                continue;
            }
            if (status == 4) {
                throw new InvalidNameException(Messages.getString("jndi.07", s));
            }
            status = status == 3 ? 0 : status;
            element.append(s.charAt(pos++));
        }
        if (1 == status || 2 == status) {
            throw new InvalidNameException(Messages.getString("jndi.08", s));
        }
        hasNotNullElement = hasNotNullElement || element.length() > 0;
        this.addElement(element);
        if (!hasNotNullElement) {
            this.elem.remove(this.elem.size() - 1);
        }
    }

    private int addBuffer(StringBuilder buffer, String des, boolean include) {
        if (include) {
            buffer.append(des);
        }
        return des.length();
    }

    private void addElement(StringBuilder element) {
        if (LEFT_TO_RIGHT == this.direction) {
            this.elem.add(element.toString());
        } else {
            this.elem.add(0, element.toString());
        }
        element.setLength(0);
    }

    private String extractEscapedString(String s, int pos, int status) {
        String result = null;
        if (status == 1 && this.startsWithFromPos(s, pos, this.endQuoteString)) {
            result = this.endQuoteString;
        } else if (status == 2 && this.startsWithFromPos(s, pos, this.endQuoteString2)) {
            result = this.endQuoteString2;
        } else if (status != 1 && status != 2) {
            if (this.startsWithFromPos(s, pos, this.beginQuoteString)) {
                result = this.beginQuoteString;
            } else if (this.startsWithFromPos(s, pos, this.beginQuoteString2)) {
                result = this.beginQuoteString2;
            } else if (this.startsWithFromPos(s, pos, this.endQuoteString)) {
                result = this.endQuoteString;
            } else if (this.startsWithFromPos(s, pos, this.endQuoteString2)) {
                result = this.endQuoteString2;
            } else if (this.startsWithFromPos(s, pos, this.separatorString)) {
                result = this.separatorString;
            } else if (this.startsWithFromPos(s, pos, this.separatorString2)) {
                result = this.separatorString2;
            } else if (this.startsWithFromPos(s, pos, this.escapeString)) {
                result = this.escapeString;
            }
        }
        return result;
    }

    private boolean startsWithFromPos(String src, int pos, String des) {
        if (src == null || des == null || NULL_STRING.equals(des) || src.length() - pos < des.length()) {
            return false;
        }
        int length = des.length();
        int i = -1;
        while (++i < length && src.charAt(pos + i) == des.charAt(i)) {
        }
        return i == length;
    }

    @Override
    public Enumeration<String> getAll() {
        return this.elem.elements();
    }

    @Override
    public String get(int index) {
        this.validateIndex(index, false);
        return this.elem.elementAt(index);
    }

    private void validateIndex(int index, boolean isInclude) {
        if (index < 0 || index > this.elem.size() || !isInclude && index == this.elem.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public Name getPrefix(int index) {
        this.validateIndex(index, true);
        return new CompoundName(new Vector(this.elem.subList(0, index)).elements(), this.mySyntax);
    }

    @Override
    public Name getSuffix(int index) {
        this.validateIndex(index, false);
        return new CompoundName(new Vector(this.elem.subList(index, this.elem.size())).elements(), this.mySyntax);
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.elem.size(), name);
    }

    @Override
    public Name addAll(int index, Name name) throws InvalidNameException {
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.00"));
        }
        if (!(name instanceof CompoundName)) {
            throw new InvalidNameException(Messages.getString("jndi.09", name.toString()));
        }
        if (FLAT.equals(this.direction) && this.size() + name.size() > 1) {
            throw new InvalidNameException(Messages.getString("jndi.0A"));
        }
        this.validateIndex(index, true);
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            this.elem.add(index++, enumeration.nextElement());
        }
        return this;
    }

    @Override
    public Name add(String element) throws InvalidNameException {
        if (element == null) {
            throw new IllegalArgumentException(Messages.getString("jndi.8C"));
        }
        if (FLAT.equals(this.direction) && this.size() > 0) {
            throw new InvalidNameException(Messages.getString("jndi.0A"));
        }
        this.elem.add(element);
        return this;
    }

    @Override
    public Name add(int index, String element) throws InvalidNameException {
        if (element == null) {
            throw new IllegalArgumentException(Messages.getString("jndi.8C"));
        }
        if (FLAT.equals(this.direction) && this.size() > 0) {
            throw new InvalidNameException(Messages.getString("jndi.0A"));
        }
        this.validateIndex(index, true);
        this.elem.add(index, element);
        return this;
    }

    @Override
    public Object remove(int index) throws InvalidNameException {
        this.validateIndex(index, false);
        return this.elem.remove(index);
    }

    @Override
    public Object clone() {
        return new CompoundName(this.getAll(), this.mySyntax);
    }

    @Override
    public int size() {
        return this.elem.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elem.isEmpty();
    }

    @Override
    public boolean startsWith(Name name) {
        if (!(name instanceof CompoundName)) {
            return false;
        }
        return this.equals(name, 0, name.size());
    }

    @Override
    public boolean endsWith(Name name) {
        if (!(name instanceof CompoundName)) {
            return false;
        }
        return this.equals(name, this.size() - name.size(), name.size());
    }

    private String preProcess(String string, boolean caseInsensitive, boolean removeBlanks) {
        String result = string;
        if (string != null && !NULL_STRING.equals(string)) {
            result = caseInsensitive ? result.toLowerCase() : result;
            result = removeBlanks ? result.trim() : result;
        }
        return result;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.mySyntax);
        oos.writeInt(this.elem.size());
        int i = 0;
        while (i < this.elem.size()) {
            String element = this.elem.elementAt(i);
            oos.writeObject(element);
            ++i;
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.init((Properties)ois.readObject());
        int size = ois.readInt();
        this.elem = new Vector();
        int i = 0;
        while (i < size) {
            this.elem.add((String)ois.readObject());
            ++i;
        }
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof CompoundName)) {
            throw new ClassCastException();
        }
        int result = -1;
        CompoundName otherName = (CompoundName)o;
        Enumeration<String> otherEnum = otherName.getAll();
        int i = 0;
        while (i < this.size() && otherEnum.hasMoreElements()) {
            String thisElement = this.preProcess(this.elem.get(i), this.ignoreCase, this.trimBlanks);
            String otherElement = this.preProcess(otherEnum.nextElement(), this.ignoreCase, this.trimBlanks);
            int n = thisElement == null ? (otherElement == null ? 0 : -1) : (result = thisElement.compareTo(otherElement));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        if (i < this.size()) {
            result = 1;
        } else if (otherEnum.hasMoreElements()) {
            result = -1;
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        Enumeration<String> enumeration = this.elem.elements();
        while (enumeration.hasMoreElements()) {
            result += this.preProcess(enumeration.nextElement(), this.ignoreCase, this.trimBlanks).hashCode();
        }
        return result;
    }

    public String toString() {
        String separator;
        StringBuilder sb = new StringBuilder();
        String begin = NULL_STRING.equals(this.beginQuoteString) ? this.beginQuoteString2 : this.beginQuoteString;
        String end = NULL_STRING.equals(this.endQuoteString) ? this.endQuoteString2 : this.endQuoteString;
        String string = separator = NULL_STRING.equals(this.separatorString) ? this.separatorString2 : this.separatorString;
        if (RIGHT_TO_LEFT.equals(this.direction)) {
            int i = this.elem.size() - 1;
            while (i >= 0) {
                this.addElement(sb, i, separator, begin, end);
                --i;
            }
        } else {
            int i = 0;
            while (i < this.elem.size()) {
                this.addElement(sb, i, separator, begin, end);
                ++i;
            }
        }
        if (this.size() * separator.length() < sb.length()) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString();
    }

    private void addElement(StringBuilder sb, int index, String separator, String begin, String end) {
        String elemString = this.elem.get(index);
        if (elemString.length() == 0) {
            sb.append(separator);
            return;
        }
        int pos = sb.length();
        sb.append(elemString);
        if (!(NULL_STRING.equals(begin) || NULL_STRING.equals(end) || NULL_STRING.equals(separator) || elemString.indexOf(separator) < 0)) {
            sb.insert(pos, begin);
            pos += begin.length();
            int i = 0;
            int j = 0;
            while ((j = elemString.indexOf(end, i)) >= 0) {
                sb.insert(pos + j, this.escapeString);
                pos += this.escapeString.length();
                i = j + end.length();
            }
            sb.append(end);
        } else {
            if (this.startsWithFromPos(elemString, 0, this.beginQuoteString) || this.startsWithFromPos(elemString, 0, this.beginQuoteString2)) {
                sb.insert(pos, this.escapeString);
                pos += this.escapeString.length();
            }
            int i = 0;
            while (i < elemString.length()) {
                if (this.startsWithFromPos(elemString, i, this.separatorString)) {
                    sb.insert(pos + i, this.escapeString);
                    pos += this.escapeString.length();
                    i += this.separatorString.length();
                    continue;
                }
                if (this.startsWithFromPos(elemString, i, this.separatorString2)) {
                    sb.insert(pos + i, this.escapeString);
                    pos += this.escapeString.length();
                    i += this.separatorString2.length();
                    continue;
                }
                if (this.startsWithFromPos(elemString, i, this.escapeString)) {
                    sb.insert(pos + i, this.escapeString);
                    pos += this.escapeString.length();
                    i += this.escapeString.length();
                    continue;
                }
                ++i;
            }
        }
        sb.append(separator);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompoundName)) {
            return false;
        }
        CompoundName otherName = (CompoundName)o;
        int size = otherName.size();
        if (size != this.size()) {
            return false;
        }
        return this.equals(otherName, 0, size);
    }

    private boolean equals(Name name, int start, int length) {
        if (length > this.size()) {
            return false;
        }
        CompoundName otherName = (CompoundName)name;
        Enumeration<String> otherEnum = otherName.getAll();
        int i = 0;
        while (i < length) {
            String thisElement = this.preProcess(this.elem.get(i + start), this.ignoreCase, this.trimBlanks);
            String otherElement = this.preProcess(otherEnum.nextElement(), this.ignoreCase, this.trimBlanks);
            if (thisElement == null ? otherElement != null : !thisElement.equals(otherElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

