/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomElementsInspection<T extends DomElement>
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance(DomElementsInspection.class);
    private final Set<Class<? extends T>> myDomClasses;

    @SafeVarargs
    public DomElementsInspection(Class<? extends T> domClass, Class<? extends T> ... additionalClasses) {
        if (additionalClasses == null) {
            DomElementsInspection.$$$reportNull$$$0(0);
        }
        this.myDomClasses = ContainerUtil.newHashSet((Object[])additionalClasses);
        this.myDomClasses.add(domClass);
    }

    public void checkFileElement(@NotNull DomFileElement<T> domFileElement, final @NotNull DomElementAnnotationHolder holder) {
        if (domFileElement == null) {
            DomElementsInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            DomElementsInspection.$$$reportNull$$$0(2);
        }
        final DomHighlightingHelper helper = DomElementAnnotationsManager.getInstance(domFileElement.getManager().getProject()).getHighlightingHelper();
        Consumer<DomElement> consumer = new Consumer<DomElement>(){

            @Override
            public void accept(DomElement element) {
                DomElementsInspection.this.checkChildren(element, this);
                DomElementsInspection.this.checkDomElement(element, holder, helper);
            }
        };
        consumer.accept((DomElement)domFileElement.getRootElement());
    }

    protected void checkChildren(@NotNull DomElement element, @NotNull @NotNull Consumer<? super @NotNull DomElement> visitor) {
        XmlElement xmlElement;
        if (element == null) {
            DomElementsInspection.$$$reportNull$$$0(3);
        }
        if (visitor == null) {
            DomElementsInspection.$$$reportNull$$$0(4);
        }
        if ((xmlElement = element.getXmlElement()) instanceof XmlTag) {
            for (DomElement domElement : DomUtil.getDefinedChildren(element, true, true)) {
                XmlElement element1 = domElement.getXmlElement();
                if (element1 == null) {
                    LOG.error("child=" + String.valueOf(domElement) + " of class " + String.valueOf(domElement.getClass()) + "; parent=" + String.valueOf(element));
                    continue;
                }
                if (!element1.isPhysical()) continue;
                visitor.accept(domElement);
            }
            for (AbstractDomChildrenDescription abstractDomChildrenDescription : element.getGenericInfo().getChildrenDescriptions()) {
                if (abstractDomChildrenDescription.getAnnotation(Required.class) == null) continue;
                for (DomElement domElement : abstractDomChildrenDescription.getValues(element)) {
                    if (DomUtil.hasXml(domElement)) continue;
                    visitor.accept(domElement);
                }
            }
        }
    }

    @NotNull
    public final Set<Class<? extends T>> getDomClasses() {
        Set<Class<? extends T>> set = this.myDomClasses;
        if (set == null) {
            DomElementsInspection.$$$reportNull$$$0(5);
        }
        return set;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            DomElementsInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            DomElementsInspection.$$$reportNull$$$0(7);
        }
        if (file instanceof XmlFile && (file.isPhysical() || ApplicationManager.getApplication().isUnitTestMode())) {
            for (Class<? extends T> clazz : this.myDomClasses) {
                DomFileElement<? extends T> fileElement = DomManager.getDomManager(file.getProject()).getFileElement((XmlFile)file, clazz);
                if (fileElement == null) continue;
                return this.checkDomFile(fileElement, manager, isOnTheFly);
            }
        }
        return null;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            DomElementsInspection.$$$reportNull$$$0(8);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected ProblemDescriptor @Nullable [] checkDomFile(@NotNull DomFileElement<T> domFileElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        DomElementAnnotationsManager annotationsManager;
        List<DomElementProblemDescriptor> list;
        if (domFileElement == null) {
            DomElementsInspection.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            DomElementsInspection.$$$reportNull$$$0(10);
        }
        if ((list = (annotationsManager = DomElementAnnotationsManager.getInstance(manager.getProject())).checkFileElement(domFileElement, this, isOnTheFly)).isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List problems = ContainerUtil.concat(list, s -> annotationsManager.createProblemDescriptors(manager, (DomElementProblemDescriptor)s));
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            DomElementsInspection.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            DomElementsInspection.$$$reportNull$$$0(12);
        }
        if (helper == null) {
            DomElementsInspection.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("checkDomElement() is not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClasses";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementsInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementsInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFileElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkChildren";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkDomFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkDomElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }
}

