/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui.preview;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableCsvFormatPreview
implements CsvFormatPreview {
    private final DataGrid myGrid;

    public TableCsvFormatPreview(@NotNull Project project, @NotNull CsvFormat format, @NotNull CharSequence text, @NotNull Disposable parent, final @Nullable Runnable doAfterDataIsLoaded) {
        if (project == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(0);
        }
        if (format == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(1);
        }
        if (text == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(3);
        }
        Document document = EditorFactory.getInstance().createDocument(text);
        document.setReadOnly(true);
        CsvDocumentDataHookUp hookup = new CsvDocumentDataHookUp(project, format, document, null);
        Disposer.register((Disposable)parent, (Disposable)hookup);
        this.myGrid = GridUtil.createCsvPreviewDataGrid(project, (DocumentDataHookUp)hookup);
        Disposer.register((Disposable)parent, (Disposable)this.myGrid);
        Disposer.register((Disposable)parent, (Disposable)UiNotifyConnector.Once.installOn((Component)this.myGrid.getPanel().getComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                ActionCallback loaded = TableCsvFormatPreview.this.loadPreview();
                if (doAfterDataIsLoaded != null) {
                    loaded.doWhenDone(doAfterDataIsLoaded);
                }
            }
        }));
    }

    @NotNull
    public ActionCallback loadPreview() {
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myGrid));
        this.getHookUp().getLoader().loadFirstPage(source);
        ActionCallback actionCallback = source.getActionCallback();
        if (actionCallback == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @Override
    public void setFormat(@NotNull CsvFormat format, @NotNull GridRequestSource source) {
        if (format == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(5);
        }
        if (source == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(6);
        }
        this.getHookUp().setFormat(format, source);
    }

    @NotNull
    public ActionCallback setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(7);
        }
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myGrid));
        this.setFormat(format, source);
        ActionCallback actionCallback = source.getActionCallback();
        if (actionCallback == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(8);
        }
        return actionCallback;
    }

    @NotNull
    public DataGrid getGrid() {
        DataGrid dataGrid = this.myGrid;
        if (dataGrid == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(9);
        }
        return dataGrid;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myGrid.getPanel().getComponent();
        if (jBLoadingPanel == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(10);
        }
        return jBLoadingPanel;
    }

    @NotNull
    private CsvDocumentDataHookUp getHookUp() {
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.myGrid.getDataHookup();
        if (csvDocumentDataHookUp == null) {
            TableCsvFormatPreview.$$$reportNull$$$0(11);
        }
        return csvDocumentDataHookUp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/preview/TableCsvFormatPreview";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/preview/TableCsvFormatPreview";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPreview";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setFormat";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrid";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

