// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6
// RUN: %clang_cc1 -O1 -disable-llvm-passes -emit-llvm %s -o - -triple=x86_64-linux-gnu | FileCheck %s

extern volatile int i;

// CHECK-LABEL: define dso_local void @_Z8OneCaseLv(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2:![0-9]+]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF6:![0-9]+]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void OneCaseL() {
  switch (i) {
    [[likely]] case 1: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z8OneCaseUv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_BB:.*]]
// CHECK-NEXT:    ], !prof [[PROF7:![0-9]+]]
// CHECK:       [[SW_BB]]:
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK-NEXT:    store volatile i32 [[INC]], ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void OneCaseU() {
  switch (i) {
    [[unlikely]] case 1: ++i; break;
  }
}

// CHECK-LABEL: define dso_local void @_Z10TwoCasesLNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG]]
// CHECK-NEXT:      i32 2, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF8:![0-9]+]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void TwoCasesLN() {
  switch (i) {
    [[likely]] case 1: break;
    case 2: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z10TwoCasesUNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG]]
// CHECK-NEXT:      i32 2, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF9:![0-9]+]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void TwoCasesUN() {
  switch (i) {
    [[unlikely]] case 1: break;
    case 2: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z10TwoCasesLUv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG]]
// CHECK-NEXT:      i32 2, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF10:![0-9]+]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void TwoCasesLU() {
  switch (i) {
    [[likely]] case 1: break;
    [[unlikely]] case 2: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z20CasesFallthroughNNLNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_BB:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_BB]]
// CHECK-NEXT:      i32 3, label %[[SW_BB1:.*]]
// CHECK-NEXT:      i32 4, label %[[SW_BB1]]
// CHECK-NEXT:    ], !prof [[PROF11:![0-9]+]]
// CHECK:       [[SW_BB]]:
// CHECK-NEXT:    br label %[[SW_BB1]]
// CHECK:       [[SW_BB1]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void CasesFallthroughNNLN() {
  switch (i) {
    case 1:
    case 2:
    [[likely]] case 3:
    case 4: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z20CasesFallthroughNNUNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_BB:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_BB]]
// CHECK-NEXT:      i32 3, label %[[SW_BB1:.*]]
// CHECK-NEXT:      i32 4, label %[[SW_BB1]]
// CHECK-NEXT:    ], !prof [[PROF12:![0-9]+]]
// CHECK:       [[SW_BB]]:
// CHECK-NEXT:    br label %[[SW_BB1]]
// CHECK:       [[SW_BB1]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void CasesFallthroughNNUN() {
  switch (i) {
    case 1:
    case 2:
    [[unlikely]] case 3:
    case 4: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z28CasesFallthroughRangeSmallLNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_BB:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_BB]]
// CHECK-NEXT:      i32 3, label %[[SW_BB]]
// CHECK-NEXT:      i32 4, label %[[SW_BB]]
// CHECK-NEXT:      i32 5, label %[[SW_BB]]
// CHECK-NEXT:      i32 102, label %[[SW_BB1:.*]]
// CHECK-NEXT:      i32 103, label %[[SW_BB2:.*]]
// CHECK-NEXT:      i32 104, label %[[SW_BB2]]
// CHECK-NEXT:    ], !prof [[PROF13:![0-9]+]]
// CHECK:       [[SW_BB]]:
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK-NEXT:    store volatile i32 [[INC]], ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    br label %[[SW_BB1]]
// CHECK:       [[SW_BB1]]:
// CHECK-NEXT:    br label %[[SW_BB2]]
// CHECK:       [[SW_BB2]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void CasesFallthroughRangeSmallLN() {
  switch (i) {
    case 1 ... 5: ++i;
    case 102:
    [[likely]] case 103:
    case 104: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z28CasesFallthroughRangeSmallUNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_EPILOG:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_BB:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_BB]]
// CHECK-NEXT:      i32 3, label %[[SW_BB]]
// CHECK-NEXT:      i32 4, label %[[SW_BB]]
// CHECK-NEXT:      i32 5, label %[[SW_BB]]
// CHECK-NEXT:      i32 102, label %[[SW_BB1:.*]]
// CHECK-NEXT:      i32 103, label %[[SW_BB2:.*]]
// CHECK-NEXT:      i32 104, label %[[SW_BB2]]
// CHECK-NEXT:    ], !prof [[PROF14:![0-9]+]]
// CHECK:       [[SW_BB]]:
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK-NEXT:    store volatile i32 [[INC]], ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    br label %[[SW_BB1]]
// CHECK:       [[SW_BB1]]:
// CHECK-NEXT:    br label %[[SW_BB2]]
// CHECK:       [[SW_BB2]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void CasesFallthroughRangeSmallUN() {
  switch (i) {
    case 1 ... 5: ++i;
    case 102:
    [[unlikely]] case 103:
    case 104: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z29CasesFallthroughRangeLargeLLNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_CASERANGE:.*]] [
// CHECK-NEXT:      i32 1003, label %[[SW_BB1:.*]]
// CHECK-NEXT:      i32 104, label %[[SW_BB1]]
// CHECK-NEXT:    ], !prof [[PROF8]]
// CHECK:       [[SW_BB:.*]]:
// CHECK-NEXT:    br label %[[SW_BB1]]
// CHECK:       [[SW_BB1]]:
// CHECK-NEXT:    br label %[[SW_EPILOG:.*]]
// CHECK:       [[SW_CASERANGE]]:
// CHECK-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], 0
// CHECK-NEXT:    [[INBOUNDS:%.*]] = icmp ule i32 [[TMP1]], 64
// CHECK-NEXT:    [[INBOUNDS_EXPVAL:%.*]] = call i1 @llvm.expect.i1(i1 [[INBOUNDS]], i1 true)
// CHECK-NEXT:    br i1 [[INBOUNDS_EXPVAL]], label %[[SW_BB]], label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void CasesFallthroughRangeLargeLLN() {
  switch (i) {
    [[likely]] case 0 ... 64:
    [[likely]] case 1003:
    case 104: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z29CasesFallthroughRangeLargeUUNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_CASERANGE:.*]] [
// CHECK-NEXT:      i32 1003, label %[[SW_BB1:.*]]
// CHECK-NEXT:      i32 104, label %[[SW_BB1]]
// CHECK-NEXT:    ], !prof [[PROF9]]
// CHECK:       [[SW_BB:.*]]:
// CHECK-NEXT:    br label %[[SW_BB1]]
// CHECK:       [[SW_BB1]]:
// CHECK-NEXT:    br label %[[SW_EPILOG:.*]]
// CHECK:       [[SW_CASERANGE]]:
// CHECK-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], 0
// CHECK-NEXT:    [[INBOUNDS:%.*]] = icmp ule i32 [[TMP1]], 64
// CHECK-NEXT:    [[INBOUNDS_EXPVAL:%.*]] = call i1 @llvm.expect.i1(i1 [[INBOUNDS]], i1 false)
// CHECK-NEXT:    br i1 [[INBOUNDS_EXPVAL]], label %[[SW_BB]], label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void CasesFallthroughRangeLargeUUN() {
  switch (i) {
    [[unlikely]] case 0 ... 64:
    [[unlikely]] case 1003:
    case 104: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z15OneCaseDefaultLv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_DEFAULT:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG:.*]]
// CHECK-NEXT:    ], !prof [[PROF15:![0-9]+]]
// CHECK:       [[SW_DEFAULT]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void OneCaseDefaultL() {
  switch (i) {
    case 1: break;
    [[likely]] default: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z15OneCaseDefaultUv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_DEFAULT:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG:.*]]
// CHECK-NEXT:    ], !prof [[PROF16:![0-9]+]]
// CHECK:       [[SW_DEFAULT]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void OneCaseDefaultU() {
  switch (i) {
    case 1: break;
    [[unlikely]] default: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z18TwoCasesDefaultLNLv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_DEFAULT:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF17:![0-9]+]]
// CHECK:       [[SW_DEFAULT]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void TwoCasesDefaultLNL() {
  switch (i) {
    [[likely]] case 1: break;
    case 2: break;
    [[likely]] default: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z18TwoCasesDefaultLNNv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_DEFAULT:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF8]]
// CHECK:       [[SW_DEFAULT]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void TwoCasesDefaultLNN() {
  switch (i) {
    [[likely]] case 1: break;
    case 2: break;
    default: break;
  }
}

// CHECK-LABEL: define dso_local void @_Z18TwoCasesDefaultLNUv(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @i, align 4, !tbaa [[INT_TBAA2]]
// CHECK-NEXT:    switch i32 [[TMP0]], label %[[SW_DEFAULT:.*]] [
// CHECK-NEXT:      i32 1, label %[[SW_EPILOG:.*]]
// CHECK-NEXT:      i32 2, label %[[SW_EPILOG]]
// CHECK-NEXT:    ], !prof [[PROF18:![0-9]+]]
// CHECK:       [[SW_DEFAULT]]:
// CHECK-NEXT:    br label %[[SW_EPILOG]]
// CHECK:       [[SW_EPILOG]]:
// CHECK-NEXT:    ret void
//
void TwoCasesDefaultLNU() {
  switch (i) {
    [[likely]] case 1: break;
    case 2: break;
    [[unlikely]] default: break;
  }
}
//.
// CHECK: [[INT_TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0}
// CHECK: [[META3]] = !{!"int", [[META4:![0-9]+]], i64 0}
// CHECK: [[META4]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// CHECK: [[META5]] = !{!"Simple C++ TBAA"}
// CHECK: [[PROF6]] = !{!"branch_weights", i32 357913942, i32 715827883}
// CHECK: [[PROF7]] = !{!"branch_weights", i32 536870912, i32 1}
// CHECK: [[PROF8]] = !{!"branch_weights", i32 238609295, i32 715827883, i32 238609295}
// CHECK: [[PROF9]] = !{!"branch_weights", i32 357913942, i32 1, i32 357913942}
// CHECK: [[PROF10]] = !{!"branch_weights", i32 357913942, i32 715827883, i32 1}
// CHECK: [[PROF11]] = !{!"branch_weights", i32 143165577, i32 143165577, i32 143165577, i32 715827883, i32 143165577}
// CHECK: [[PROF12]] = !{!"branch_weights", i32 214748365, i32 214748365, i32 214748365, i32 1, i32 214748365}
// CHECK: [[PROF13]] = !{!"branch_weights", i32 79536432, i32 79536432, i32 79536432, i32 79536432, i32 79536432, i32 79536432, i32 79536432, i32 715827883, i32 79536432}
// CHECK: [[PROF14]] = !{!"branch_weights", i32 119304648, i32 119304648, i32 119304648, i32 119304648, i32 119304648, i32 119304648, i32 119304648, i32 1, i32 119304648}
// CHECK: [[PROF15]] = !{!"branch_weights", i32 715827883, i32 357913942}
// CHECK: [[PROF16]] = !{!"branch_weights", i32 1, i32 536870912}
// CHECK: [[PROF17]] = !{!"branch_weights", i32 536870912, i32 536870912, i32 268435456}
// CHECK: [[PROF18]] = !{!"branch_weights", i32 1, i32 715827883, i32 357913942}
//.
