/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.syscall;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCallLatencyAnalysis;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class SystemCallAnalysisUsageBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass#System Call Analysis#";
    private static final String TEST_ITERATE_CPU = "Iterate cpu (%s)";
    private static final String TEST_ITERATE_MEMORY = "Iterate memory (%s)";
    private static final String TEST_INTERSECTION_CPU = "Intersection cpu (%s)";
    private static final String TEST_INTERSECTION_MEMORY = "Intersection memory (%s)";
    private static final int LOOP_COUNT = 25;

    private static void deleteSupplementaryFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private static SystemCallLatencyAnalysis getModule(@NonNull CtfTestTrace testTrace, @NonNull LttngKernelTrace trace) {
        SystemCallLatencyAnalysis module = null;
        String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace).getPath();
        try {
            trace.initTrace(null, path, CtfTmfEvent.class);
            SystemCallAnalysisUsageBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
            trace.traceOpened(new TmfTraceOpenedSignal((Object)trace, (ITmfTrace)trace, null));
            IAnalysisModule tidModule = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
            Assert.assertNotNull((Object)tidModule);
            tidModule.schedule();
            tidModule.waitForCompletion();
            module = new SystemCallLatencyAnalysis();
            module.setId("test");
            module.setTrace((ITmfTrace)trace);
            TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        }
        catch (TmfAnalysisException | TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        return module;
    }

    @Test
    public void testTrace2() {
        SystemCallAnalysisUsageBenchmark.runTest(CtfTestTrace.TRACE2, "Trace2");
    }

    @Test
    public void testManyThreads() {
        SystemCallAnalysisUsageBenchmark.runTest(CtfTestTrace.MANY_THREADS, "Many threads");
    }

    @Test
    public void testDjangoHttpd() {
        SystemCallAnalysisUsageBenchmark.runTest(CtfTestTrace.DJANGO_HTTPD, "Django HTTPD");
    }

    private static void runTest(@NonNull CtfTestTrace testTrace, String traceName) {
        LttngKernelTrace trace = new LttngKernelTrace();
        SystemCallLatencyAnalysis module = SystemCallAnalysisUsageBenchmark.getModule(testTrace, trace);
        long segmentEnd = SystemCallAnalysisUsageBenchmark.benchmarkIteration(traceName, module);
        SystemCallAnalysisUsageBenchmark.benchmarkIntersection(traceName, module, trace.getStartTime().getValue(), segmentEnd);
        SystemCallAnalysisUsageBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
        module.dispose();
        trace.dispose();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)testTrace);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static long benchmarkIteration(String testName, SystemCallLatencyAnalysis module) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pmCpu = perf.createPerformanceMeter(TEST_ID + String.format(TEST_ITERATE_CPU, testName));
        perf.tagAsSummary(pmCpu, "Syscall " + String.format(TEST_ITERATE_CPU, testName), Dimension.CPU_TIME);
        PerformanceMeter pmMemory = perf.createPerformanceMeter(TEST_ID + String.format(TEST_ITERATE_MEMORY, testName));
        perf.tagAsSummary(pmMemory, "Syscall " + String.format(TEST_ITERATE_MEMORY, testName), Dimension.USED_JAVA_HEAP);
        @NonNull ISegmentStore ss = module.getSegmentStore();
        if (ss == null) {
            Assert.fail((String)"The segment store is null");
            return -1L;
        }
        long endTime = -1L;
        int i = 0;
        while (i < 25) {
            pmCpu.start();
            for (ISegment segment : ss) {
                endTime = Math.max(endTime, segment.getEnd());
            }
            pmCpu.stop();
            ++i;
        }
        i = 0;
        while (i < 25) {
            System.gc();
            pmMemory.start();
            for (ISegment segment : ss) {
                endTime = Math.max(endTime, segment.getEnd());
            }
            System.gc();
            pmMemory.stop();
            ++i;
        }
        pmCpu.commit();
        pmMemory.commit();
        return endTime;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void benchmarkIntersection(String testName, SystemCallLatencyAnalysis module, long start, long end) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pmCpu = perf.createPerformanceMeter(TEST_ID + String.format(TEST_INTERSECTION_CPU, testName));
        perf.tagAsSummary(pmCpu, "Syscall " + String.format(TEST_INTERSECTION_CPU, testName), Dimension.CPU_TIME);
        PerformanceMeter pmMemory = perf.createPerformanceMeter(TEST_ID + String.format(TEST_INTERSECTION_MEMORY, testName));
        perf.tagAsSummary(pmMemory, "Syscall " + String.format(TEST_INTERSECTION_MEMORY, testName), Dimension.USED_JAVA_HEAP);
        @NonNull ISegmentStore ss = module.getSegmentStore();
        if (ss == null) {
            Assert.fail((String)"The segment store is null");
            return;
        }
        int i = 0;
        while (i < 25) {
            long intersectStart = start;
            long intersectEnd = end;
            pmCpu.start();
            int j = 0;
            while (j < 10) {
                Iterables.getLast((Iterable)ss.getIntersectingElements(intersectStart, intersectEnd), (Object)new BasicSegment(0L, 1L));
                long step = (long)((double)(intersectEnd - intersectStart) * 0.1);
                intersectStart += step;
                intersectEnd -= step;
                ++j;
            }
            pmCpu.stop();
            ++i;
        }
        i = 0;
        while (i < 25) {
            ArrayList<Iterable> lists = new ArrayList<Iterable>();
            long intersectStart = start;
            long intersectEnd = end;
            System.gc();
            pmMemory.start();
            int j = 0;
            while (j < 5) {
                @NonNull Iterable elements = ss.getIntersectingElements(intersectStart, intersectEnd);
                Iterables.getLast((Iterable)elements, (Object)new BasicSegment(0L, 1L));
                lists.add(elements);
                long step = (long)((double)(intersectEnd - intersectStart) * 0.2);
                intersectStart += step;
                intersectEnd -= step;
                ++j;
            }
            System.gc();
            pmMemory.stop();
            ++i;
        }
        pmCpu.commit();
        pmMemory.commit();
    }
}

