/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping.OverlappingNode;

public abstract class AbstractOverlappingHistoryTree<E extends IHTInterval, N extends OverlappingNode<E>>
extends AbstractHistoryTree<E, N> {
    public AbstractOverlappingHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart, IHTIntervalReader<E> intervalReader) throws IOException {
        super(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart, intervalReader);
    }

    public AbstractOverlappingHistoryTree(File existingStateFile, int expectedProviderVersion, IHTIntervalReader<E> objectReader) throws IOException {
        super(existingStateFile, expectedProviderVersion, objectReader);
    }

    @Override
    protected long getNewBranchStart(int depth, E interval) {
        return Math.max(interval.getStart(), this.getLatestNode(depth).getNodeStart());
    }

    @Override
    @VisibleForTesting
    public N getLatestLeaf() {
        return (N)((OverlappingNode)super.getLatestLeaf());
    }

    @Override
    @VisibleForTesting
    public int getDepth() {
        return super.getDepth();
    }

    @Override
    @VisibleForTesting
    public N getLatestNode(int depth) {
        return (N)((OverlappingNode)super.getLatestNode(depth));
    }

    @Override
    @VisibleForTesting
    public boolean verifyChildrenSpecific(N parent, int index, N child) {
        return ((OverlappingNode)parent).getChildStart(index) == ((HTNode)child).getNodeStart() && ((OverlappingNode)parent).getChildEnd(index) == ((HTNode)child).getNodeEnd();
    }

    @Override
    @VisibleForTesting
    public boolean verifyIntersectingChildren(N parent, N child) {
        int childSequence = ((HTNode)child).getSequenceNumber();
        long t = ((HTNode)parent).getNodeStart();
        while (t < ((HTNode)parent).getNodeEnd()) {
            Collection<Integer> nextChildren;
            TimeRangeCondition timeCondition = TimeRangeCondition.singleton(t);
            boolean shouldBeInCollection = timeCondition.intersects(((HTNode)child).getNodeStart(), ((HTNode)child).getNodeEnd());
            if (shouldBeInCollection != (nextChildren = ((HTNode)parent).selectNextChildren(timeCondition)).contains(childSequence)) {
                return false;
            }
            ++t;
        }
        return true;
    }
}

