/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.util.FixedBitSet;

public abstract class DocIdSetIterator {
    public static final int NO_MORE_DOCS = Integer.MAX_VALUE;

    public static DocIdSetIterator empty() {
        return new DocIdSetIterator(){
            boolean exhausted = false;

            @Override
            public int advance(int target) {
                assert (!this.exhausted);
                assert (target >= 0);
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }

            @Override
            public int docID() {
                return this.exhausted ? Integer.MAX_VALUE : -1;
            }

            @Override
            public int nextDoc() {
                assert (!this.exhausted);
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    public static DocIdSetIterator all(final int maxDoc) {
        return new DocIdSetIterator(){
            int doc = -1;

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                return this.advance(this.doc + 1);
            }

            @Override
            public int advance(int target) {
                this.doc = target;
                if (this.doc >= maxDoc) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }

            @Override
            public long cost() {
                return maxDoc;
            }

            @Override
            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) {
                assert (offset <= this.doc);
                if ((upTo = Math.min(upTo, maxDoc)) > this.doc) {
                    bitSet.set(this.doc - offset, upTo - offset);
                    this.advance(upTo);
                }
            }

            @Override
            public int docIDRunEnd() throws IOException {
                return maxDoc;
            }
        };
    }

    public static DocIdSetIterator range(final int minDoc, final int maxDoc) {
        if (minDoc >= maxDoc) {
            throw new IllegalArgumentException("minDoc must be < maxDoc but got minDoc=" + minDoc + " maxDoc=" + maxDoc);
        }
        if (minDoc < 0) {
            throw new IllegalArgumentException("minDoc must be >= 0 but got minDoc=" + minDoc);
        }
        return new DocIdSetIterator(){
            private int doc = -1;

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                return this.advance(this.doc + 1);
            }

            @Override
            public int advance(int target) {
                this.doc = target < minDoc ? minDoc : (target >= maxDoc ? Integer.MAX_VALUE : target);
                return this.doc;
            }

            @Override
            public long cost() {
                return maxDoc - minDoc;
            }

            @Override
            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) {
                assert (offset <= this.doc);
                if ((upTo = Math.min(upTo, maxDoc)) > this.doc) {
                    bitSet.set(this.doc - offset, upTo - offset);
                    this.advance(upTo);
                }
            }

            @Override
            public int docIDRunEnd() throws IOException {
                return maxDoc;
            }
        };
    }

    public abstract int docID();

    public abstract int nextDoc() throws IOException;

    public abstract int advance(int var1) throws IOException;

    protected final int slowAdvance(int target) throws IOException {
        int doc;
        assert (this.docID() < target);
        while ((doc = this.nextDoc()) < target) {
        }
        return doc;
    }

    public abstract long cost();

    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        assert (offset <= this.docID()) : "offset=" + offset + " docID()=" + this.docID() + " upTo=" + upTo;
        int doc = this.docID();
        while (doc < upTo) {
            bitSet.set(doc - offset);
            doc = this.nextDoc();
        }
    }

    public int docIDRunEnd() throws IOException {
        return this.docID() + 1;
    }
}

