/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterViewer;

class FilterDragSourceAdapter
extends DragSourceAdapter {
    private FilterViewer fViewer;

    public FilterDragSourceAdapter(FilterViewer viewer) {
        this.fViewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection s = this.fViewer.getTreeViewer().getSelection();
        LocalSelectionTransfer.getTransfer().setSelection(s);
        LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getTransfer().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            for (Object data : selection.toList()) {
                if (!(data instanceof ITmfFilterTreeNode)) continue;
                ITmfFilterTreeNode e = (ITmfFilterTreeNode)data;
                e.remove();
                this.fViewer.refresh();
            }
        }
        LocalSelectionTransfer.getTransfer().setSelection(null);
        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
    }
}

