/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

public abstract class MultiOperation
extends CModelOperation {
    protected String[] fRenamingsList = null;
    protected Map<ICElement, ICElement> fParentElements;
    protected Map<ICElement, ICElement> fInsertBeforeElements = new HashMap<ICElement, ICElement>(1);
    protected Map<ICElement, String> fRenamings;

    protected MultiOperation(ICElement[] elementsToProcess, ICElement[] parentElements, boolean force) {
        super(elementsToProcess, parentElements, force);
        this.fParentElements = new HashMap<ICElement, ICElement>(elementsToProcess.length);
        if (elementsToProcess.length == parentElements.length) {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[i]);
                ++i;
            }
        } else {
            ICElement[] iCElementArray = elementsToProcess;
            int n = elementsToProcess.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement elementsToProces = iCElementArray[n2];
                this.fParentElements.put(elementsToProces, parentElements[0]);
                ++n2;
            }
        }
    }

    protected MultiOperation(ICElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    protected void error(int code, ICElement element) throws CModelException {
        throw new CModelException(new CModelStatus(code, element));
    }

    @Override
    protected void executeOperation() throws CModelException {
        try {
            this.processElements();
        }
        finally {
            this.mergeDeltas();
        }
    }

    protected ICElement getDestinationParent(ICElement child) {
        return this.fParentElements.get(child);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(ICElement element) {
        if (this.fRenamings != null) {
            return this.fRenamings.get(element);
        }
        return null;
    }

    private void initializeRenamings() {
        if (this.fRenamingsList != null && this.fRenamingsList.length == this.fElementsToProcess.length) {
            this.fRenamings = new HashMap<ICElement, String>(this.fRenamingsList.length);
            int i = 0;
            while (i < this.fRenamingsList.length) {
                if (this.fRenamingsList[i] != null) {
                    this.fRenamings.put(this.fElementsToProcess[i], this.fRenamingsList[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected void mergeDeltas() {
        if (this.fDeltas != null) {
            CElementDelta rootDelta = this.newCElementDelta();
            boolean insertedTree = false;
            for (ICElementDelta delta : this.fDeltas) {
                ICElementDelta[] children;
                ICElementDelta[] iCElementDeltaArray = children = delta.getAffectedChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElementDelta element = iCElementDeltaArray[n2];
                    CElementDelta projectDelta = (CElementDelta)element;
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++n2;
                }
            }
            if (insertedTree) {
                this.fDeltas.clear();
                this.fDeltas.add(rootDelta);
            } else {
                this.fDeltas = null;
            }
        }
    }

    protected abstract void processElement(ICElement var1) throws CModelException;

    protected void processElements() throws CModelException {
        this.beginTask(this.getMainTaskName(), this.fElementsToProcess.length);
        ICModelStatus[] errors = new ICModelStatus[3];
        int errorsCounter = 0;
        ICElement[] iCElementArray = this.fElementsToProcess;
        int n = this.fElementsToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                ICElement elementsToProces = iCElementArray[n2];
                try {
                    try {
                        this.verify(elementsToProces);
                        this.processElement(elementsToProces);
                    }
                    catch (CModelException jme) {
                        if (errorsCounter == errors.length) {
                            ICModelStatus[] iCModelStatusArray = errors;
                            errors = new ICModelStatus[errorsCounter * 2];
                            System.arraycopy(iCModelStatusArray, 0, errors, 0, errorsCounter);
                        }
                        errors[errorsCounter++] = jme.getCModelStatus();
                        this.worked(1);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.worked(1);
                    throw throwable;
                }
                this.worked(1);
            }
            ++n2;
        }
        this.done();
        if (errorsCounter == 1) {
            throw new CModelException(errors[0]);
        }
        if (errorsCounter > 1) {
            if (errorsCounter != errors.length) {
                ICModelStatus[] iCModelStatusArray = errors;
                errors = new ICModelStatus[errorsCounter];
                System.arraycopy(iCModelStatusArray, 0, errors, 0, errorsCounter);
            }
            throw new CModelException(CModelStatus.newMultiStatus(errors));
        }
    }

    public void setInsertBefore(ICElement modifiedElement, ICElement newSibling) {
        this.fInsertBeforeElements.put(modifiedElement, newSibling);
    }

    public void setRenamings(String[] renamings) {
        this.fRenamingsList = renamings;
        this.initializeRenamings();
    }

    protected abstract void verify(ICElement var1) throws CModelException;

    protected void verifyDestination(ICElement element, ICElement destination) throws CModelException {
        if (destination == null || !destination.exists()) {
            this.error(969, destination);
        } else if (element.getElementType() == 60) {
            IResource res = destination.getResource();
            if (!(res instanceof IContainer)) {
                this.error(978, element);
            }
            ITranslationUnit tu = (ITranslationUnit)element;
            if (this.isMove() && tu.isWorkingCopy()) {
                this.error(967, element);
            }
        }
    }

    protected void verifyRenaming(ICElement element) throws CModelException {
        String newName = this.getNewNameFor(element);
        boolean isValid = true;
        if (newName.indexOf(32) != -1) {
            isValid = false;
        }
        if (!isValid) {
            throw new CModelException(new CModelStatus(983, element, newName));
        }
    }

    protected void verifySibling(ICElement element, ICElement destination) throws CModelException {
        ICElement insertBeforeElement = this.fInsertBeforeElements.get(element);
        if (!(insertBeforeElement == null || insertBeforeElement.exists() && insertBeforeElement.getParent().equals(destination))) {
            this.error(993, insertBeforeElement);
        }
    }
}

