/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.common.core.format.LongToPercentFormat;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;

public final class FormatTimeUtils {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final long HOURS_PER_DAY = 24L;
    private static final long MIN_PER_HOUR = 60L;
    private static final long SEC_PER_MIN = 60L;
    private static final long SEC_IN_NS = 1000000000L;
    private static final long MILLISEC_IN_NS = 1000000L;

    private FormatTimeUtils() {
    }

    public static void updateTimeZone() {
        TimeZone timeZone = TmfTimePreferences.getTimeZone();
        TIME_FORMAT.setTimeZone(timeZone);
        DATE_FORMAT.setTimeZone(timeZone);
    }

    public static String formatTime(long time, TimeFormat format, Resolution resolution) {
        boolean neg;
        switch (format) {
            case CALENDAR: {
                return FormatTimeUtils.formatTimeAbs(time, resolution);
            }
            case NUMBER: {
                return NumberFormat.getInstance().format(time);
            }
            case CYCLES: {
                return NumberFormat.getInstance().format(time) + Messages.Utils_ClockCyclesUnit;
            }
            case RELATIVE: {
                return FormatTimeUtils.formatTimeRelative(time, resolution);
            }
            case PERCENTAGE: {
                return LongToPercentFormat.getInstance().format(time);
            }
        }
        StringBuilder str = new StringBuilder();
        long t = time;
        boolean bl = neg = t < 0L;
        if (neg) {
            t = -t;
            str.append('-');
        }
        long sec = t / 1000000000L;
        str.append(sec);
        String ns = FormatTimeUtils.formatNs(t, resolution);
        if (!ns.isEmpty()) {
            str.append('.');
            str.append(ns);
        }
        return str.toString();
    }

    public static String formatDate(long absTime) {
        return DATE_FORMAT.format(new Date(absTime / 1000000L));
    }

    public static String formatTimeAbs(long time, Resolution res) {
        String stime = TIME_FORMAT.format(new Date(time / 1000000L));
        StringBuilder str = new StringBuilder(stime);
        String ns = FormatTimeUtils.formatNs(time, res);
        if (!ns.isEmpty()) {
            str.append('.');
            str.append(ns);
        }
        return str.toString();
    }

    public static String formatDelta(long delta, TimeFormat format, Resolution resolution) {
        if (format == TimeFormat.CALENDAR) {
            return FormatTimeUtils.formatDeltaAbs(delta, resolution);
        }
        return FormatTimeUtils.formatTime(delta, format, resolution);
    }

    private static String formatTimeRelative(long time, Resolution resolution) {
        StringBuilder str = new StringBuilder();
        if (time < 0L) {
            str.append('-');
        }
        long ns = Math.abs(time);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(ns);
        str.append(seconds);
        str.append('.');
        str.append(FormatTimeUtils.formatNs(time, resolution));
        str.append('s');
        if (seconds == 0L) {
            str.append(" (");
            str.append(new DecimalUnitFormat(1.0E-9).format((Object)time));
            str.append("s)");
        }
        return str.toString();
    }

    public static String formatDeltaAbs(long delta, Resolution resolution) {
        StringBuilder str = new StringBuilder();
        if (delta < 0L) {
            str.append('-');
        }
        long ns = Math.abs(delta);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(ns);
        long minutes = TimeUnit.NANOSECONDS.toMinutes(ns);
        long hours = TimeUnit.NANOSECONDS.toHours(ns);
        long days = TimeUnit.NANOSECONDS.toDays(ns);
        if (days > 0L) {
            str.append(days);
            str.append("d ");
        }
        if (hours > 0L) {
            str.append(hours % 24L);
            str.append("h ");
        }
        if (minutes > 0L) {
            str.append(minutes % 60L);
            str.append("m ");
        }
        str.append(seconds % 60L);
        str.append('.');
        str.append(FormatTimeUtils.formatNs(delta, resolution));
        str.append("s");
        if (seconds == 0L) {
            str.append(" (");
            str.append(new DecimalUnitFormat(1.0E-9).format((Object)delta));
            str.append("s)");
        }
        return str.toString();
    }

    public static String formatNs(long srcTime, Resolution res) {
        StringBuilder str = new StringBuilder();
        long ns = Math.abs(srcTime % 1000000000L);
        String nanos = Long.toString(ns);
        str.append("000000000".substring(nanos.length()));
        str.append(nanos);
        if (res == Resolution.MILLISEC) {
            return str.substring(0, 3);
        }
        if (res == Resolution.MICROSEC) {
            return str.substring(0, 6);
        }
        if (res == Resolution.NANOSEC) {
            return str.substring(0, 9);
        }
        return "";
    }

    public static enum Resolution {
        SECONDS,
        MILLISEC,
        MICROSEC,
        NANOSEC;

    }

    public static enum TimeFormat {
        RELATIVE,
        CALENDAR,
        NUMBER,
        CYCLES,
        PERCENTAGE;

    }
}

