/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.model.elements.ElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.ui.IMemento;

public abstract class DebugElementMementoProvider
extends ElementMementoProvider {
    protected static final String ELEMENT_NAME = "ELEMENT_NAME";

    @Override
    protected boolean encodeElement(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        if (this.supportsContext(context)) {
            String name = this.getElementName(element, context);
            memento.putString(ELEMENT_NAME, name);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isEqual(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        String name;
        String mementoName = memento.getString(ELEMENT_NAME);
        if (mementoName != null && (name = this.getElementName(element, context)) != null) {
            return name.equals(mementoName);
        }
        return false;
    }

    protected boolean supportsContext(IPresentationContext context) {
        return this.supportsContextId(context.getId());
    }

    protected boolean supportsContextId(String id) {
        return true;
    }

    protected abstract String getElementName(Object var1, IPresentationContext var2) throws CoreException;
}

