/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;

public abstract class SelectAllAction
extends AbstractRemoveAllActionDelegate {
    private IViewPart fView;

    @Override
    public void init(IViewPart view) {
        this.fView = view;
        IDebugView debugView = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (debugView != null) {
            debugView.setAction(this.getActionId(), this.getAction());
        }
        super.init(view);
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected abstract String getActionId();

    private void collectExpandedAndVisible(TreeItem[] items, List<TreeItem> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            result.add(item);
            if (item.getExpanded()) {
                this.collectExpandedAndVisible(item.getItems(), result);
            }
            ++n2;
        }
    }

    public void run(IAction action) {
        if (!(this.getView() instanceof IDebugView)) {
            return;
        }
        Viewer viewer = ((IDebugView)this.getView()).getViewer();
        if (viewer instanceof TreeViewer) {
            ArrayList<TreeItem> allVisible = new ArrayList<TreeItem>();
            Tree tree = ((TreeViewer)viewer).getTree();
            this.collectExpandedAndVisible(tree.getItems(), allVisible);
            tree.setSelection(allVisible.toArray(new TreeItem[allVisible.size()]));
            viewer.setSelection(viewer.getSelection());
        }
    }
}

