/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.IRos2Model;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2FlowTargetInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuilder;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2PublicationMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2SubCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2TimerCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messagelinks.Ros2MessageCausalLinksModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TakeInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2MessageFlowModel
implements IRos2Model {
    private final @NonNull Ros2FlowTargetInfo fInfo;
    private final @NonNull Ros2MessageFlowBuildInfo fBuildInfo;
    private final @NonNull Ros2MessageFlowBuilder fBuilder;
    private Ros2MessageFlowSegment fInitialSegment = null;
    private boolean fIsModelDone = false;
    private final @NonNull HashMap<@NonNull Ros2MessageFlowSegment, @NonNull Ros2MessageFlowSegment> fSegments = new HashMap();

    public Ros2MessageFlowModel(@NonNull Ros2FlowTargetInfo info, @NonNull ITmfStateSystem objectsSs, @NonNull ITmfStateSystem messagesSs, @NonNull Ros2MessageCausalLinksModel messageLinksModel) {
        this.fInfo = info;
        this.fBuildInfo = new Ros2MessageFlowBuildInfo(objectsSs, messagesSs, messageLinksModel);
        this.fBuilder = new Ros2MessageFlowBuilder(this.fBuildInfo, this.fSegments);
    }

    public boolean isDone() {
        return this.fIsModelDone;
    }

    public @Nullable Ros2MessageFlowSegment getInitialSegment() {
        return this.fInitialSegment;
    }

    public void generateModel() {
        this.fIsModelDone = false;
        this.generate();
        this.fIsModelDone = true;
    }

    private void generate() {
        this.fInitialSegment = this.getSegmentFromTargetInfo(this.fInfo);
        if (this.fInitialSegment != null) {
            this.buildFlow(this.fInitialSegment);
        }
    }

    private @Nullable Ros2MessageFlowSegment getSegmentFromTargetInfo(Ros2FlowTargetInfo targetInfo) {
        Ros2MessageFlowSegment segment = null;
        switch (targetInfo.getTargetType()) {
            case PUBLISHER: {
                Ros2PubInstance pubInstance = (Ros2PubInstance)((Object)targetInfo.getTargetEvent());
                Ros2PublisherObject publisherObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(this.fBuildInfo.getObjectsSs(), targetInfo.getStartTime(), pubInstance.getPublisherHandle());
                if (publisherObject == null) break;
                segment = new Ros2PublicationMessageFlowSegment(targetInfo.getStartTime(), targetInfo.getEndTime(), pubInstance, publisherObject);
                break;
            }
            case SUBSCRIPTION: {
                Ros2SubCallbackInstance subCallbackInstance;
                long timestamp;
                Ros2ObjectHandle subHandle;
                if (targetInfo.getTargetEvent() instanceof Ros2TakeInstance) {
                    Ros2TakeInstance takeInstance = (Ros2TakeInstance)((Object)targetInfo.getTargetEvent());
                    subHandle = takeInstance.getSubscriptionHandle();
                    timestamp = takeInstance.getStartTime();
                } else if (targetInfo.getTargetEvent() instanceof Ros2CallbackInstance) {
                    Ros2CallbackInstance callbackInstance = (Ros2CallbackInstance)((Object)targetInfo.getTargetEvent());
                    subHandle = callbackInstance.getOwnerHandle();
                    timestamp = callbackInstance.getStartTime();
                } else {
                    throw new IllegalStateException();
                }
                Ros2SubscriptionObject subObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(this.fBuildInfo.getObjectsSs(), targetInfo.getStartTime(), subHandle);
                ITmfStateInterval subCallbackInstanceInterval = Ros2MessagesUtil.getSubCallbackInstanceInterval(this.fBuildInfo.getMessagesSs(), this.fBuildInfo.getObjectsSs(), timestamp, subHandle);
                if (subObject == null || subCallbackInstanceInterval == null || (subCallbackInstance = (Ros2SubCallbackInstance)((Object)subCallbackInstanceInterval.getValue())) == null) break;
                segment = new Ros2SubCallbackMessageFlowSegment(targetInfo.getStartTime(), targetInfo.getEndTime(), subCallbackInstance, subObject);
                break;
            }
            case TIMER: {
                Ros2CallbackInstance callbackInstance = (Ros2CallbackInstance)((Object)targetInfo.getTargetEvent());
                Ros2TimerObject timerObject = Ros2ObjectsUtil.getTimerObjectFromHandle(this.fBuildInfo.getObjectsSs(), targetInfo.getStartTime(), callbackInstance.getOwnerHandle());
                if (timerObject == null) break;
                segment = new Ros2TimerCallbackMessageFlowSegment(targetInfo.getStartTime(), targetInfo.getEndTime(), callbackInstance, timerObject);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return segment;
    }

    private void buildFlow(@NonNull Ros2MessageFlowSegment initialSegment) {
        this.fBuilder.getNextSegments(initialSegment);
        this.fBuilder.getPreviousSegments(initialSegment);
    }

    public static void printFlow(@NonNull Ros2MessageFlowSegment segment) {
        Ros2MessageFlowModel.printFlow(segment, 0, true, false);
        Ros2MessageFlowModel.printFlow(segment, 0, false, true);
    }

    private static void printFlow(@NonNull Ros2MessageFlowSegment segment, int depth, boolean forward, boolean skip) {
        if (!skip) {
            Activator.getInstance().logInfo(StringUtils.repeat((String)" ", (int)(depth * 2)) + segment.toString());
        }
        for (Ros2MessageFlowSegment next : forward ? segment.getNext() : segment.getPrevious()) {
            Ros2MessageFlowModel.printFlow(next, depth + 1, forward, false);
        }
    }
}

