/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2Object;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public class Ros2TimerObject
extends Ros2Object<Ros2ObjectHandle> {
    public static final byte CUSTOM_TYPE_ID = 63;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory ROS2_TIMER_OBJECT_VALUE_FACTORY = b -> Ros2TimerObject.read(b);
    private final long fPeriod;
    private final @NonNull HostProcessPointer fCallback;
    private final @NonNull Ros2ObjectHandle fNodeHandle;

    public Ros2TimerObject(@NonNull Ros2ObjectHandle timerHandle, long period, @NonNull HostProcessPointer callback, @NonNull Ros2ObjectHandle nodeHandle) {
        super(timerHandle);
        this.fPeriod = period;
        this.fCallback = callback;
        this.fNodeHandle = nodeHandle;
    }

    public long getPeriod() {
        return this.fPeriod;
    }

    public @NonNull HostProcessPointer getCallback() {
        return this.fCallback;
    }

    public @NonNull Ros2ObjectHandle getNodeHandle() {
        return this.fNodeHandle;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fPeriod, this.fCallback, this.fNodeHandle, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2TimerObject o = (Ros2TimerObject)((Object)obj);
        return o.fPeriod == this.fPeriod && o.fCallback.equals((Object)this.fCallback) && o.fNodeHandle.equals((Object)this.fNodeHandle);
    }

    @Override
    public String toString() {
        return String.format("Ros2TimerObject: %s, period=%d, callback=[%s], nodeHandle=[%s]", super.toString(), this.fPeriod, this.fCallback.toString(), this.fNodeHandle.toString());
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)63;
    }

    @Override
    protected void serializeValue(ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        buffer.putLong(this.fPeriod);
        this.fCallback.serializeValue(buffer);
        this.fNodeHandle.serializeValue(buffer);
    }

    @Override
    protected int getSerializedValueSize() {
        int size = 0;
        size += super.getSerializedValueSize();
        size += 8;
        size += this.fCallback.getSerializedValueSize();
        return size += this.fNodeHandle.getSerializedValueSize();
    }

    public static @NonNull Ros2TimerObject read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle timerHandle = Ros2ObjectHandle.read(buffer);
        long period = buffer.getLong();
        HostProcessPointer callback = HostProcessPointer.read(buffer);
        Ros2ObjectHandle nodeHandle = Ros2ObjectHandle.read(buffer);
        return new Ros2TimerObject(timerHandle, period, callback, nodeHandle);
    }
}

