/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.AbstractCommentActionXMLDelegate;

public class RemoveBlockCommentActionXMLDelegate
extends AbstractCommentActionXMLDelegate {
    @Override
    void processAction(IDocument document, ITextSelection textSelection) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            try {
                IndexedRegion selectionStartIndexedRegion = model.getIndexedRegion(textSelection.getOffset());
                IndexedRegion selectionEndIndexedRegion = model.getIndexedRegion(textSelection.getOffset() + textSelection.getLength());
                if (selectionStartIndexedRegion == null || selectionEndIndexedRegion == null) {
                    return;
                }
                int openCommentOffset = selectionStartIndexedRegion.getStartOffset();
                int closeCommentOffset = selectionEndIndexedRegion.getEndOffset() - "<!--".length() - "-->".length();
                model.beginRecording((Object)this, XMLUIMessages.RemoveBlockComment_tooltip);
                model.aboutToChangeModel();
                try {
                    try {
                        if (textSelection.getLength() == 0) {
                            if (selectionStartIndexedRegion instanceof CommentImpl) {
                                document.replace(openCommentOffset, "<!--".length(), "");
                                document.replace(closeCommentOffset, "-->".length(), "");
                            }
                        } else {
                            if (selectionStartIndexedRegion instanceof CommentImpl) {
                                document.replace(openCommentOffset, "<!--".length(), "");
                            }
                            if (selectionEndIndexedRegion instanceof CommentImpl) {
                                document.replace(closeCommentOffset, "-->".length(), "");
                            }
                        }
                        this.removeOpenCloseComments(document, openCommentOffset + "<!--".length(), closeCommentOffset - openCommentOffset - "-->".length());
                    }
                    catch (BadLocationException e) {
                        Logger.log(202, e.getMessage(), e);
                        model.changedModel();
                        model.endRecording((Object)this);
                    }
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                }
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(XMLUIMessages.RemoveBlockComment_label);
            action.setToolTipText(XMLUIMessages.RemoveBlockComment_tooltip);
            action.setDescription(XMLUIMessages.RemoveBlockComment_description);
        }
    }
}

